macro "Complete Analysis [q]"{
	AttachmentFile = File.openDialog("Select attachment stack");
	GrowthFile = File.openDialog("Select growth stack");
	QuickAnalysis(AttachmentFile, GrowthFile);		
}

function QuickAnalysis(attachmentFile, growthFile) {

	parent = File.getParent(attachmentFile);
	open(attachmentFile);
	wait(100);
	run("Duplicate...", "title=attachment duplicate");

	open(growthFile);
	wait(100);
	run("Duplicate...", "title=growth duplicate");

	File.makeDirectory(parent+"\\Data");
	File.makeDirectory(parent+"\\Data\\Clustering");
	File.makeDirectory(parent+"\\Data\\Collision");
	
	run("Concatenate...", "  title=Concatenated keep image1=attachment image2=growth image3=[-- None --]");
	
	save(parent+"\\Concatenated.tif");


	run("Clear Results");
	selectWindow("attachment");
	run("Attachment Counter");
	selectWindow("Results");	
	save(parent+"\\Data\\Attachment Count.txt");
	run("Clear Results");
	
	selectWindow("Concatenated");
	run("Detachment Counter");
	selectWindow("Results");
	save(parent+"\\Data\\Detachment Count.txt");
	run("Clear Results");

	selectWindow("Concatenated");
	run("Sum Intensity");
	selectWindow("Results");
	save(parent+"\\Data\\SumIntensities.txt");
	run("Clear Results");

	
	selectWindow("Concatenated");
	run("Coverage Area");

	selectWindow("Results");
	save(parent+"\\Data\\Coveragearea.txt");
	run("Clear Results");


	selectWindow("Concatenated");	
	run("Close");

	selectWindow("attachment");	
	run("Close");

	selectWindow("growth");	
	run("Close");

	print("Made using the quick analysis macro, last updated 2017.02.10");
	wait(200);
	selectWindow("Log");
	save(parent+"\\info.txt");
	run("Close");
		
}


macro "Sum Intensity"{
	run("Duplicate...", "title=duplicate duplicate");
	wait(100);
	run("8-bit");
	wait(100);
	run("Duplicate...", "title=Mask duplicate");


	setThreshold(15, 255);
	run("Convert to Mask", "method=Default background=Dark");
	wait(500);

	imageCalculator("AND create stack", "duplicate","Mask");

	run("Set Scale...", "distance=0 known=0 pixel=1 unit=pixel");

	run("Set Measurements...", "integrated redirect=None decimal=3");

	for (t=1; t<= nSlices; ++t){
		setSlice(t);
		run("Measure");
	}	

	selectWindow("duplicate");
	setOption("Changes", false);
	close("duplicate");
	
	selectWindow("Mask");
	setOption("Changes", false);
	close("Mask");

	selectWindow("Result of duplicate");
	setOption("Changes", false);
}

macro "Coverage Area"{
	run("Duplicate...", "title=duplicate duplicate");
	wait(100);
	run("8-bit");
	wait(100);

	setThreshold(15, 255);
	run("Convert to Mask", "method=Default background=Dark");
	wait(200);

	run("Set Scale...", "distance=0 known=0 pixel=1 unit=pixel");

	run("Set Measurements...", "area_fraction redirect=None decimal=3");

	wait(100);
	for (t=1; t<= nSlices; ++t){
		setSlice(t);
		run("Measure");		
	}	

	selectWindow("duplicate");
	setOption("Changes", false);
	close("duplicate");
}


macro "Attachment Counter" {
	run("Duplicate...", "title=duplicateNT duplicate");
	wait(100);
	run("8-bit");
	wait(100);
	
	title = getTitle();
	slices = nSlices;
	short = nSlices-1;
	run("Duplicate...", "title=n duplicate range=1-&short");
	selectWindow(title);
	run("Duplicate...", "title=n+1 duplicate range=2-&slices");
	imageCalculator("Subtract create stack", "n+1","n");
	wait(200);
	close("n");
	
	run("Duplicate...", "title=subtractedImage duplicate");
	selectWindow("Result of n+1");
	
	setThreshold(15, 255);
	run("Convert to Mask", "method=Default background=Dark");
	wait(500);
	
	run("Set Scale...", "distance=0 known=0 pixel=1 unit=pixel");

	run("Fill Holes", "stack");
	run("Options...", "iterations=5 count=4 pad do=Erode stack");

	
	run("Analyze Particles...", "size=400-Infinity circularity=0.30-1.00 show=Masks stack");

	imageCalculator("AND create stack", "Mask of Result of n+1","subtractedImage");

	run("Set Measurements...", "integrated redirect=None decimal=0");
	wait(100);
	for (t=1; t<= nSlices; ++t){
		setSlice(t);
		run("Measure");
	}	

	selectWindow("duplicateNT");
	setOption("Changes", false);
	close("duplicateNT");
	close("n+1");
	close("Mask of Result of n+1");
	selectWindow("subtractedImage");
	setOption("Changes", false);
	close("subtractedImage");
}

macro "Detachment Counter" {
	run("Duplicate...", "title=duplicate duplicate");
	wait(100);	
	run("8-bit");
	wait(100);
	title = getTitle();
	slices = nSlices;
	short = nSlices-1;
	run("Duplicate...", "title=n duplicate range=1-&short");
	selectWindow(title);
	run("Duplicate...", "title=n+1 duplicate range=2-&slices");
	imageCalculator("Subtract create stack", "n","n+1");
	wait(200);
	close("n+1");
	run("Duplicate...", "title=subtractedImage duplicate");
	selectWindow("Result of n");
	
	setThreshold(15, 255);
	run("Convert to Mask", "method=Default background=Dark");
	wait(200);
	
	run("Set Scale...", "distance=0 known=0 pixel=1 unit=pixel");

	run("Fill Holes", "stack");
	run("Options...", "iterations=5 count=4 pad do=Erode stack");
	
	run("Analyze Particles...", "size=400-Infinity circularity=0.30-1.00 show=Masks stack");

	imageCalculator("AND create stack", "Mask of Result of n","subtractedImage");

	run("Set Measurements...", "integrated redirect=None decimal=0");
	for (t=1; t<= nSlices; ++t){
		setSlice(t);
		run("Measure");
	}	

	
	selectWindow("duplicate");
	setOption("Changes", false);
	close("duplicate");
	close("n");
	close("Mask of Result of n");
	selectWindow("subtractedImage");
	setOption("Changes", false);
	close("subtractedImage");
}



