%% Temperature Phases %%
% Comfortable tile that changes location on every iteration while the other
% two tiles increase temperature

global par;

%% Info about the experiment:
par.expName = 'Run';
par.expVersion = '1';
par.expChangeData = '140212';

%% Keyboard settings:
KbName('UnifyKeyNames');

%% Debugging stuff:
% Enter the debugger when an error is signalled.
dbstop if error
dbstop if warning

%% Define duration of pre-recording phases and of experimental phases
par.PreRecording = 5  ;
par.StimulusDur = 60;

%% Start Arena
arena = LoB;

if (ispc)
    par.port_nat = 'COM5';
end

if (ismac)
    par.port_nat = '/dev/tty.usbmodem2411';
end

arena.Init(par.port_nat)
arena.Message('Init done');

arena.LED(0,0);

arena.SetBaseTemp(15);
arena.SetTileTemp(16,16,16);

arena.Wait('Init...',5);
arena.Wait('Explore...',par.PreRecording);

%% Start the experimental block

for i = 1:28
    if mod(i,2) == 1
        arena.LED(1,0)
    else
        arena.LED(0,1)
    end
    
    if i > 8 && i <= 18
        a = a + 2;
    elseif i > 18
        a = a - 2;
    else
        a = 16;
    end
    
    if mod(i,3) == 1               %The comfortable tile at 22?C will change
        arena.SetTileTemp(a,a,22); %location on every iteration
    elseif mod(i,3) == 2
        arena.SetTileTemp(a,22,a);
    else
        arena.SetTileTemp(22,a,a);
    end
    arena.Wait(sprintf('%dStim',curTrial),par.StimulusDur);
end

arena.LED(0,0);
arena.SetTileTemp(22,22,22);


