
%% TemperaturePhases

clear java
clear all
close all

global par;

%% Info about the experiment:
par.expName = 'Run';
par.expVersion = '1';
par.expChangeData = '140212';

%% Debugging stuff:
% Enter the debugger when an error/warning is signalled.
dbstop if error
dbstop if warning

%% Define variables of the different experimental parts.

par.StimulusDur = 60;

%% Start Arena

arena = LoB;
par.port_nat = '/dev/tty.usbmodem2411';
  
arena.Init(par.port_nat)
arena.Message('Init done');

arena.LED(0,0);

arena.SetBaseTemp(16);
arena.SetTileTemp(22,22,22);

arena.Wait('Init...',5);

startTime = datestr(now,'yymmddHHMM');
GetChar;

%% Start the experimental block

for i = 1:21
    if mod(i,2) == 1
        arena.LED(1,0)
    else
        arena.LED(0,1)
    end
    if i > 8
        a = a + 2;
    else
        a = 16;
    end
   
    arena.SetTileTemp(a,a,a);
    arena.Wait(sprintf('%dStim',i),par.StimulusDur);
end

arena.LED(0,0);
arena.SetTileTemp(22,22,22);

