% Supplementary File 3 - Test

% Jonghee Yoon et al. "Label-free optical technique for identifying 
% lymphocyte types using 3D quantitative phase imaging and machine
% learning," Journal of Visualized Experiments

% Written by YoungJu Jo
% KAIST Biomedical Optics Lab & Tomocube

%%

clear; close all;

model_dir = 'D:\lymphocytes\models';  % directory with trained classification model
model_name = 'trained_model';  % name of trained classification model 

test_set = 'D:\lymphocytes\features_split\test';  % directory with test data


%%

% restore saved classification model
cd(model_dir);
load(model_name);

% read features in test set

cd(test_set);

class_folders = dir;
class_folders(1:2) = [];

num_classes = length(class_folders);
if num_classes ~= length(classes)
    error('Check training and test classes.');
end

feature_test = [];
label_test = [];

for class_idx = 1:num_classes
    
    cd(test_set);
    cd(class_folders(class_idx).name);
    class_name = class_folders(class_idx).name;
    if class_folders(class_idx).name ~= cell2mat(classes(class_idx))
        error('Check training and test classes.');
    end
    
    exp_files = dir('*.mat');
    
    feature_class = zeros(length(exp_files),size(feature_combination,1));
    label_class = class_idx * ones(length(exp_files),1);
    
    for exp_idx = 1:length(exp_files)
        
        load(exp_files(exp_idx).name);
        
        feature_selected = zeros(1,size(feature_combination,1));
        for feature_idx = 1:size(feature_combination,1)
            feature_selected(feature_idx) = features(round(RI_threshold*1000)==round(feature_combination(feature_idx,1)*1000),feature_combination(feature_idx,2));
        end
        feature_class(exp_idx,:) = feature_selected;

    end
    
    label_class(sum(isnan(feature_class),2)~=0) = [];
    feature_class(sum(isnan(feature_class),2)~=0,:) = [];
    
    feature_test = [feature_test; feature_class];
    label_test = [label_test; label_class];
    
end

num_test_samples = size(feature_test,1);
feature_test_standardized = (feature_test-repmat(feature_mu,[num_test_samples 1]))./repmat(feature_sigma,[num_test_samples 1]); % per-feature standardization with mean and standard deviation of training set
prediction_test = predict(classification_model,feature_test_standardized);  % testing the restored k-NN classifier

figure('units','normalized','outerposition',[0 0 1 1]),
plot(prediction_test,'.r','MarkerSize',10); hold on;
plot(label_test,'ob'); hold off;
xlabel('Individual Cell'); ylabel('Class'); legend('Prediction','Ground Truth');
test_accuracy = sum(prediction_test==label_test) / num_test_samples * 100;
title(strcat(num2str(test_accuracy),'% (Test Accuracy)'),'FontSize',20); % classification result
yticks(1:num_classes); yticklabels(classes);

% save
cd(model_dir);
save(model_name,'classification_model','feature_mu','feature_sigma','feature_combination','feature_train','label_train','feature_test','label_test','classes','CV_accuracy','test_accuracy');

       
        
