/**
  * \file waveformMaker.h
  * \author Blanc.O & Chardes.C
  * \version 0.1
  * \date 11 janvier 2010
  */

#ifndef WAVEFORMMAKER_
#define WAVEFORMMAKER_

#include <QComboBox>
#include <QDebug>
#include <QDoubleSpinBox>
#include <QGridLayout>
#include <QLabel>
#include <QMap>
#include <QSpinBox>
#include <QStringList>

#include "tool.h"
#include <math.h>
#include "NIDAQmx.h"

class waveformMaker : public QWidget
{
    Q_OBJECT;

public :

        waveformMaker (qConsole *thisConsole, int sRate, int bSize, QWidget *parent = 0 );
        ~waveformMaker ();
        float64 *makeBuffer(float64 *buff);
        void getWFParameters (QMap<QString, QString> &map);
        QDoubleSpinBox *offsetSB;

public slots :

        void setSamplingRate (int sRate);
        void setBufferSize (int bSize);

private :

        float64 *buffer;
        //samplingRate : [sample.s-1], maxFrequency [Hz], frequency : [Hz]
        int bufferSize;
        int samplingRate;
        int periodByBuffer;
        int maxFrequency;
        double frequency;
        int wfType;
        //phaseLag : [rad], amplitude : [volt], offset[volt]
        double phaseLag;
        double amplitude;
        double offset;
        static const double maxVoltage = 10.0;
        static const double  minVoltage = -10.0;
        static const double pi = 3.1415926535;
        QComboBox *wfTypeCB;
        QDoubleSpinBox *amplitudeSB;
        QDoubleSpinBox *phaseLagSB;
        QSpinBox *periodByBufferSB;
        QLabel *frequencyL;
        QLabel *offsetL;
        QLabel *amplitudeL;
        QLabel *wfTypeL;
        QLabel *phaseLagL;
        qConsole *console;

private slots :

    void changeFrequency();
    void changeAmplitude(double amp);
    void changeOffset(double off);
    void changePhaseLag(double lag);

};

#endif // WAVEFORMMAKER_
