/**
  * \file tool.h
  * \author Blanc.O
  * \version 0.1
  * \date 11 janvier 2010
  */

#ifndef TOOL_H
#define TOOL_H

#include <QDir>
#include <QEventTransition>
#include <QFileDialog>
#include <Qlabel>
#include <QlineEdit>
#include <QMenu>
#include <QPushButton>
#include <QSlider>
#include <QStateMachine>
#include <QState>
#include <QString>
#include <QStringBuilder>
#include <QTextEdit>
#include <QVBoxLayout>
#include <QWidget>

#include <windows.h>

//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////qConsole///////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////


class qConsole : public QWidget
{

    Q_OBJECT

public :

        qConsole (QWidget * parent =0);
        //~qConsole();

        qConsole& operator << (char const *intext);
        qConsole& operator << (float value);
        qConsole& operator << (QString const &qString);
        void write (QString inText);
        void testError (unsigned int err, QString instruction, QColor &color);
        void msgFrom (QString sender, QString message);

private :

        QTextEdit *cZone;

};


//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////slideAndDisplay////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////

class slideAndDisplay : public QWidget
{
    Q_OBJECT

public :
        slideAndDisplay (Qt::Orientation orientation, QWidget *parent = 0);
        void setSliderRange (int min, int max)
        {
            slider->setRange(min, max);
        };
        void setValue (int value)
        {
            slider->setValue(value);
            label->setText(QString::number(value));
        };

        int value()
        {
            return(slider->value());
        };

signals :

        void newValue (int value);

private :

        QGridLayout *layout;
        QSlider *slider;
        QLabel *label;

private slots :

        void valueUpdating (int val)
        {
            label->setText(QString::number(val));
        };
        void valueUpdated ()
        {
            emit (newValue(slider->value()));
        };


};


//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////browseSystemWidget////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////

class browseSystemWidget : public QWidget
{
    Q_OBJECT
public :

    browseSystemWidget(QWidget *parent = 0);
    void broadCastPath()
    {
        emit newFolder (directory);
    }
    QString getPath()
    {
        return (pathEdit->text());
    }
    void setDefaultFolder (QString folder)
    {
        pathEdit->setText(folder);
    }

private :

    QGridLayout *layout;
    QString directory;
    QPushButton *browseButton;
    QLineEdit *pathEdit;

private slots :

    void browse();

signals:

    void newFolder (QString dir);
};

#endif // TOOL_H
