/**
 * \file tools.cpp
 * \brief
 * \author Blanc.O
 * \version 0.1
 * \date 11 janvier 2010
 *
 * tools used in microRheo
 *  - binarybutton (2 states on/off for example)
 *  - qConsole (a console to dsplay message in the GUI)
 *  - slide and display (a slider + label widget)
 *  - browseSystemWidget (a widget to get the address of a folder and to display it)
 */

#include "tool.h"

//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////qConsole///////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////

/**
 * @brief qConsole::qConsole
 * @param parent
 */
qConsole::qConsole (QWidget *parent) : QWidget(parent)
{

    cZone = new QTextEdit();
    cZone->append("console Zone !!");
    QVBoxLayout *layout = new QVBoxLayout();
    layout->addWidget (cZone);
    layout->setContentsMargins(0, 0, 0, 0);
    setLayout(layout);

}

/**
 * @brief qConsole::write
 * @param inText
 */
void qConsole::write(QString inText)
{
    cZone->insertPlainText(inText);
}

/**
 * @brief qConsole::operator <<
 * @param qString
 * @return
 */
qConsole& qConsole::operator<<(QString const &qString)
{
    cZone->insertPlainText(qString);
    return *this;
}

/**
 * @brief qConsole::operator <<
 * @param inText
 * @return
 */
qConsole& qConsole::operator<<(char const *inText)
{
    cZone->insertPlainText(QString::fromAscii(inText));
    return *this;
}

/**
 * @brief qConsole::operator <<
 * @param value
 * @return
 */
qConsole& qConsole::operator<<(float value)
{
    cZone->insertPlainText(QString::number(value));
    return *this;
}

/**
 * @brief qConsole::testError - test the andor error code and return its meaning
 * @param err
 * @param instruction
 * @param color
 */
void qConsole::testError (unsigned int err, QString instruction, QColor &color)
{
        if (err == 20000)
        {
            cZone->setTextColor(color);
            QString answer  = QString("->  ") % instruction % QString(" : JUMPED!! \n");
            cZone->insertPlainText(answer);
        }
        if ((err != 20002) & (err != 20000))
        {
            QString answer = QString ("->  ") % instruction % QString(" :  FAILED -> ");
            answer += (QString::number(err) % QString ("\n"));
            cZone->setTextColor(color);
            cZone->insertPlainText(answer);
        }
}

/**
 * @brief qConsole::msgFrom - display the QString message precede by the QString sender thus the user know witch class send a message
 * @param sender
 * @param message
 */
void qConsole::msgFrom(QString sender, QString message)
{
    *this<<sender<<">>  "<<message;
}


//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////slideAndDisplay////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////


/**
 * @brief slideAndDisplay::slideAndDisplay - constructor - a simple widget composed by label linked to a slider, it allows to display the changing value of the slider in the label
 * @param orientation
 * @param parent
 */
slideAndDisplay::slideAndDisplay (Qt::Orientation orientation, QWidget *parent) :
        QWidget(parent)
{
    slider = new QSlider(orientation);
    slider->setContentsMargins(0, 0, 0, 0);
    label = new QLabel ("0");
    label->setContentsMargins(5, 0, 0, 0);
    label->setFrameShape(QFrame::Box);
    label->setMargin(0);

    layout = new QGridLayout();
    layout->setContentsMargins(0, 0, 0, 0);

    if (orientation == Qt::Horizontal)
    {
        layout->addWidget(slider, 0, 1, 1, 4);
        layout->addWidget(label, 0, 0, 1, 1);
    }
    else
    {
        layout->addWidget(label, 0, 0, 1, 1);
        layout->addWidget(label, 1, 0, 4, 1);
    }
    setLayout(layout);

    connect (slider, SIGNAL(sliderReleased()), this, SLOT(valueUpdated()));
    connect (slider, SIGNAL(valueChanged(int)), this, SLOT(valueUpdating(int)));
}

//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////browseSystemWidget//////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////

/**
 * @brief browseSystemWidget::browseSystemWidget - constructor
 * a simple widget designed to choose a specific directory in the system
 * the directory's path can be writen in the QLineEdit or be chosen via
 * a QFileDialog by clicking on the browse button
 * the chosen directory can be accessed by getDirectory();
 * @param parent
 */
browseSystemWidget::browseSystemWidget(QWidget *parent) : QWidget(parent)
        , directory("C:/microRheo")
{
    layout =  new QGridLayout();
    layout->setContentsMargins(0, 0, 0, 0);
    pathEdit = new QLineEdit("C:/microRheo");
    pathEdit->setContentsMargins(0, 0, 0, 0);
    browseButton = new QPushButton("Browse...");
    browseButton->setContentsMargins(0, 0, 0, 0);

    layout->addWidget(pathEdit, 0, 0, 1, 4);
    layout->addWidget(browseButton, 0, 5, 1, 1);
    layout->setContentsMargins(0, 0, 0, 0);
    setLayout(layout);

    connect(browseButton, SIGNAL(clicked()), this, SLOT(browse()));
    connect(pathEdit, SIGNAL(textChanged(QString)), this, SIGNAL(newFolder(QString)) );
}

/**
 * @brief browseSystemWidget::browse
 */
void browseSystemWidget::browse()
{
    directory = QFileDialog::getExistingDirectory(this,
                                        tr("Select the directory"), QDir::currentPath());
    if (!directory.isEmpty())
    {
        pathEdit->setText(directory);
        emit newFolder (directory);
    }
}
