/**
  * \file sDisplay.h
  * \author Blanc.O
  * \version 0.1
  * \date 11 janvier 2010
  */

#ifndef SDISPLAY_H
#define SDISPLAY_H

#include <QLabel>
#include <QPainter>
#include <QPen>
#include <QPixmap>
#include <QSize>
#include <Qwidget>

#include "tool.h"
#include "NIDAQmx.h"

class sDisplay : public QLabel
{
    Q_OBJECT

public :
    sDisplay (qConsole *myConsole, QLabel *parent = 0);
    ~sDisplay ();

    void setVRange(int range);

public slots :
        void paint(float64 *newData, int nbSignal, int bufferSize);

private:

    qConsole *console;
    QPainter *painter;
    QPen *pen;
    QSize *size;
    int vRange;
};

#endif // SDISPLAY_H
