/**
  * \file callbackCaps.cpp
  * \author Blanc.O
  * \version 0.1
  * \date 11 janvier 2010
  */

#include "callbackCaps.h"

/**
 * @brief callbackCaps::callbackCaps - constructor
 * @param g
 */
callbackCaps::callbackCaps(aoGenerator* g) : gen(g)
{    
    int32 error;
    error = DAQmxRegisterDoneEvent(g->getAIHandle(), 0, aiDoneCB, gen);
    error = DAQmxRegisterDoneEvent(g->getSCOHandle(), 0, scoDoneCB, gen);
    error = DAQmxRegisterDoneEvent(g->getCOHandle(), 0, coDoneCB, gen);
}

/**
 * @brief callbackCaps::~callbackCaps - destructor
 */
callbackCaps::~callbackCaps()
{

}

int32 CVICALLBACK callbackCaps::aiDoneCB(TaskHandle taskHandle, int32 status, void *callbackData)
{
    aoGenerator *g = (aoGenerator*)callbackData;
    g->aiDCB();
    return(1);
}

int32 CVICALLBACK callbackCaps::scoDoneCB(TaskHandle taskHandle, int32 status, void *callbackData)
{
    aoGenerator *g = (aoGenerator*)callbackData;
    g->scoDCB();
    return(1);
}

int32 CVICALLBACK callbackCaps::coDoneCB(TaskHandle taskHandle, int32 status, void *callbackData)
{    
    aoGenerator *g = (aoGenerator*)callbackData;
    g->coDCB();
    return(1);
}

/**
 * @brief callbackCaps::DAQErrChk
 * @param DAQError
 * @param fctName
 */
void callbackCaps::DAQErrChk(int32 DAQError, QString fctName)
{
    char errorBuffer[2048];
    if (DAQError != 0)
    {
        DAQmxGetExtendedErrorInfo(errorBuffer, 2048);
        qDebug()<<"\n"<<fctName<<" : "<<errorBuffer;
    }
}
