/**
  * \file aoline.h
  * \author Blanc.O & Chardes.C
  * \version 0.1
  * \date 11 janvier 2010
  */

#ifndef AOLINE_H
#define AOLINE_H

#include <QDebug>
#include <QDoubleSpinBox>
#include <QWidget>
#include "tool.h"
#include "math.h"
#include "NIDAQmx.h"

class AOLine : public QWidget
{
    Q_OBJECT;

public:
    AOLine(qConsole *thisConsole, QWidget *parent = 0);
    ~AOLine();
    QDoubleSpinBox *Vx0SB;
    QDoubleSpinBox *Vy0SB;
    QDoubleSpinBox *Vx1SB;
    QDoubleSpinBox *Vy1SB;
    double delayLaser;//ms
    QDoubleSpinBox *delayLaserSB;
    float64 *makeBuffer();

public slots:
    void setBufferSize (int bSize);

private:
    int bufferSize;
    float64 *buffer;    
    qConsole *console;
};

#endif // AOLINE_H
