/**
  * \file aoline.cpp
  * \author Blanc.O & Chardes.C
  * \version 0.1
  * \date 11 janvier 2010
  */

#include "aoline.h"

/**
 * @brief AOLine::AOLine - constructor
 * @param parent
 */
AOLine::AOLine(qConsole *thisConsole, QWidget *parent):QWidget(parent)
{
    // initialisation
    double minVoltage = -5.0;
    double maxVoltage = 5.0;
    delayLaser = 0;
    double maxDelay = 60;
    // beginning point
    QLabel *V0label = new QLabel("V0");
    Vx0SB = new QDoubleSpinBox();
    Vx0SB->setLocale(QLocale::English);
    Vx0SB->setRange(minVoltage, maxVoltage);
    Vx0SB->setDecimals(2);
    Vx0SB->setSingleStep(0.05);
    Vx0SB->setPrefix("V0(x)       ");
    Vx0SB->setSuffix ("  (Volt)");
    Vx0SB->setValue(0.0);
    Vx0SB->setWhatsThis("Vy0");
    Vy0SB = new QDoubleSpinBox();
    Vy0SB->setLocale(QLocale::English);
    Vy0SB->setRange(minVoltage, maxVoltage);
    Vy0SB->setDecimals(2);
    Vy0SB->setSingleStep(0.05);
    Vy0SB->setPrefix("V0(y)       ");
    Vy0SB->setSuffix ("  (Volt)");
    Vy0SB->setValue(0.0);
    Vy0SB->setWhatsThis("Vy0");
    // end point
    QLabel *V1label = new QLabel("V1");
    Vx1SB = new QDoubleSpinBox();
    Vx1SB->setLocale(QLocale::English);
    Vx1SB->setRange(minVoltage, maxVoltage);
    Vx1SB->setDecimals(2);
    Vx1SB->setSingleStep(0.05);
    Vx1SB->setPrefix("V1(x)       ");
    Vx1SB->setSuffix ("  (Volt)");
    Vx1SB->setValue(0.0);
    Vx1SB->setWhatsThis("Vx1");
    Vy1SB = new QDoubleSpinBox();
    Vy1SB->setLocale(QLocale::English);
    Vy1SB->setRange(minVoltage, maxVoltage);
    Vy1SB->setDecimals(2);
    Vy1SB->setSingleStep(0.05);
    Vy1SB->setPrefix("V1(y)       ");
    Vy1SB->setSuffix ("  (Volt)");
    Vy1SB->setValue(0.0);
    Vy1SB->setWhatsThis("Vy1");
    // how long before stopping the laser ?
    QLabel *delayLabel = new QLabel("delay before turning off the laser");
    delayLaserSB = new QDoubleSpinBox();
    delayLaserSB->setLocale(QLocale::English);
    delayLaserSB->setRange(0, maxDelay);
    delayLaserSB->setDecimals(3);
    delayLaserSB->setSingleStep(0.005);
    delayLaserSB->setPrefix("Delay       ");
    delayLaserSB->setSuffix ("  (s)");
    delayLaserSB->setValue(0.0);
    delayLaserSB->setWhatsThis("Delay for laser end");
    // widget construction
    QGridLayout *layout = new QGridLayout();
    layout->addWidget(V0label, 0, 0, 1, 1);
    layout->addWidget(Vx0SB, 0, 1, 1, 2);
    layout->addWidget(Vy0SB, 0, 3, 1, 2);
    layout->addWidget(V1label, 1, 0, 1, 1);
    layout->addWidget(Vx1SB, 1, 1, 1, 2);
    layout->addWidget(Vy1SB, 1, 3, 1, 2);
    layout->addWidget(delayLabel, 2, 0, 1, 1);
    layout->addWidget(delayLaserSB, 2, 1, 1, 2);
    setLayout(layout);

}

/**
 * @brief AOLine::~AOLine - destructor
 */
AOLine::~AOLine()
{
}

/**
 * @brief AOLine::makeBuffer
 * @return
 */
float64 *AOLine::makeBuffer()
{
    buffer = new float64 [2*bufferSize];
    delayLaser = delayLaserSB->value()*1000; // s*1000 to obtain the value in ms

    // Vy = a*Vx+b
    double a;
    double b;
    double Vx0 = Vx0SB->value();
    double Vy0 = Vy0SB->value();
    double Vx1 = Vx1SB->value();
    double Vy1 = Vy1SB->value();
    if (Vx1==Vx0)
    {
        Vx1 = Vx0+0.000001;
    }
    a = (Vy1-Vy0)/(Vx1-Vx0); // slope
    b = Vy1-a*Vx1; // offset
    // step : depends on buffer size
    double step = (Vx1-Vx0)/bufferSize;
    double Vx;
    double Vy;
    qDebug()<<"makebuffer aoline";
    for (int i = 0 ; i<bufferSize ; i++)
    {
        Vx = Vx0 + step*i;
        Vy = a * Vx + b;
        buffer[i] = Vx;
        buffer[i+bufferSize] = Vy;
        qDebug()<<i<<buffer[i]<<buffer[i+bufferSize];
    }

    return buffer;
}

/**
 * @brief AOLine::setBufferSize
 * @param bSize
 */
void AOLine::setBufferSize(int bSize)
{
    bufferSize = bSize;
}
