/**
  * \file aodoubletweezer.h
  * \author Chardes.C
  * \version 0.1
  * \date 2012
  */

#ifndef AODOUBLETWEEZER_H
#define AODOUBLETWEEZER_H

#include <QDebug>
#include <QDoubleSpinBox>
#include <QFile>
#include <QPushButton>
#include <QTextStream>
#include <QWidget>
#include "constant.h"
#include "tool.h"
#include "math.h"
#include "NIDAQmx.h"

class aoDoubleTweezer : public QWidget
{
    Q_OBJECT;

public:
    aoDoubleTweezer(QWidget *parent = 0);
    //~aoDoubleTweezer();
    QDoubleSpinBox *Vx0SB;
    QDoubleSpinBox *Vy0SB;
    QDoubleSpinBox *Vx1SB;
    QDoubleSpinBox *Vy1SB;
    QPushButton *updatePB;
    float64 *makeBuffer();

public slots:
    void updatePositions();
    void setBufferSize(int bSize);

private:
    int bufferSize;
    float64 *buffer;
    double *x, *y; // correspondance values x/Vx and y/Vy
    double *Vx, *Vy;
    double *xx, *yy; // current values
    double *Vxx, *Vyy;
};

#endif // AODOUBLETWEEZER_H
