/**
  * \file AOGenerator.cpp
  * \author Chardes.C
  * \version 0.1
  * \date 2012
  */


#include "aodoubletweezer.h"

/**
  * @brief constructor
  */
aoDoubleTweezer::aoDoubleTweezer(QWidget *parent):QWidget(parent)
{
    // initialisation
    double minVoltage = -5.0;
    double maxVoltage = 5.0;
    // first point
    QLabel *V0label = new QLabel("V0");
    Vx0SB = new QDoubleSpinBox();
    Vx0SB->setLocale(QLocale::English);
    Vx0SB->setRange(minVoltage, maxVoltage);
    Vx0SB->setDecimals(3);
    Vx0SB->setSingleStep(0.005);
    Vx0SB->setPrefix("V0(x)       ");
    Vx0SB->setSuffix ("  (Volt)");
    Vx0SB->setValue(0.0);
    Vx0SB->setWhatsThis("Vy0");
    Vy0SB = new QDoubleSpinBox();
    Vy0SB->setLocale(QLocale::English);
    Vy0SB->setRange(minVoltage, maxVoltage);
    Vy0SB->setDecimals(3);
    Vy0SB->setSingleStep(0.005);
    Vy0SB->setPrefix("V0(y)       ");
    Vy0SB->setSuffix ("  (Volt)");
    Vy0SB->setValue(0.0);
    Vy0SB->setWhatsThis("Vy0");
    // second point
    QLabel *V1label = new QLabel("V1");
    Vx1SB = new QDoubleSpinBox();
    Vx1SB->setLocale(QLocale::English);
    Vx1SB->setRange(minVoltage, maxVoltage);
    Vx1SB->setDecimals(3);
    Vx1SB->setSingleStep(0.05);
    Vx1SB->setPrefix("V1(x)       ");
    Vx1SB->setSuffix ("  (Volt)");
    Vx1SB->setValue(0.0);
    Vx1SB->setWhatsThis("Vx1");
    Vy1SB = new QDoubleSpinBox();
    Vy1SB->setLocale(QLocale::English);
    Vy1SB->setRange(minVoltage, maxVoltage);
    Vy1SB->setDecimals(3);
    Vy1SB->setSingleStep(0.05);
    Vy1SB->setPrefix("V1(y)       ");
    Vy1SB->setSuffix ("  (Volt)");
    Vy1SB->setValue(0.0);
    Vy1SB->setWhatsThis("Vy1");
    // update BTN (to read position values in file (point A and point B)
    updatePB = new QPushButton("update !");

    // widget construction
    QGridLayout *layout = new QGridLayout();
    layout->addWidget(V0label, 0, 0, 1, 1);
    layout->addWidget(Vx0SB, 0, 1, 1, 2);
    layout->addWidget(Vy0SB, 0, 3, 1, 2);
    layout->addWidget(V1label, 1, 0, 1, 1);
    layout->addWidget(Vx1SB, 1, 1, 1, 2);
    layout->addWidget(Vy1SB, 1, 3, 1, 2);
    layout->addWidget(updatePB, 2,0,1,1);
    setLayout(layout);

    //connection
    connect(updatePB, SIGNAL(clicked()), this, SLOT(updatePositions()));

    QFile mFile(FILENAMEPOSITION);
    if (!mFile.open(QIODevice::ReadOnly | QIODevice::Text))
     qDebug()<<"file does not exist";
    else
    {
        QTextStream in(&mFile);
        QString mText ;
        QStringList list;
        x  = new double[NBLINEINFILENAMEPOSITION];
        y  = new double[NBLINEINFILENAMEPOSITION];
        Vx = new double[NBLINEINFILENAMEPOSITION];
        Vy = new double[NBLINEINFILENAMEPOSITION];

        for (int i=0;i<NBLINEINFILENAMEPOSITION;i++)
        {
            mText = in.readLine();
            list = mText.split(QRegExp("\\s+"));
            x[i] = list.value(0).toDouble();
            y[i] =list.value(1).toDouble();
            Vx[i]=list.value(2).toDouble();
            Vy[i]=list.value(3).toDouble();
            list.clear();
        }
        mFile.close();
    }
}

/**
  * @brief
  */
void aoDoubleTweezer::updatePositions()
{
    // read file
    // print positions
    qDebug()<<"positions reading";
    QFile mFile(FILENAMEDOUBLEPOSITION);
    if (!mFile.open(QIODevice::ReadOnly | QIODevice::Text))
     qDebug()<<"file does not exist";
    else
    {
        QTextStream in(&mFile);
        QString mText ;
        QStringList list;
        xx  = new double[2];
        yy  = new double[2];
        Vxx  = new double[2];
        Vyy  = new double[2];
        for (int i=0;i<2;i++)
        {
            mText = in.readLine();
            list = mText.split(QRegExp("\\s+"));
            xx[i] = list.value(0).toDouble();
            yy[i] =list.value(1).toDouble();
            qDebug()<<"point "<<i<<xx[i]<<yy[i];
            list.clear();
        }
        mFile.close();

        // convert positions to tensions
        // on doit trouver le plus proche point x,y pour avoir Vx,Vy
        double dist = 512;
        int ind = 0;
        for (int j=0;j<2;j++)
        {
            qDebug()<<"recherche dans la liste"<<xx[j]<<yy[j];
            for (int i=0;i<NBLINEINFILENAMEPOSITION;i++)
            {
                if (sqrt((x[i]-xx[j])*(x[i]-xx[j])+(y[i]-yy[j])*(y[i]-yy[j]))<dist)
                {
                    dist = sqrt((x[i]-xx[j])*(x[i]-xx[j])+(y[i]-yy[j])*(y[i]-yy[j]));
                    ind = i;
                }
            }
            Vxx[j]=Vx[ind];
            Vyy[j]=Vy[ind];
            qDebug()<<x[ind]<<y[ind];
            dist = 512;
            ind=0;
        }
        Vx0SB->setValue(Vxx[0]);
        Vx1SB->setValue(Vxx[1]);
        Vy0SB->setValue(Vyy[0]);
        Vy1SB->setValue(Vyy[1]);
    }
}

float64 *aoDoubleTweezer::makeBuffer()
{
    buffer = new float64 [2*bufferSize];

    //pt0 et pt1 determines en cliquant sur l image
    //on lit les positions dans un fichier qd on fait update
    //ces positions doivent tre converties en tensions pr
    //les galvos grace a la carte obtenue par calibration
    //on peut modifier directement les tensions ensuite

    double Vx0 = Vx0SB->value();
    double Vy0 = Vy0SB->value();
    double Vx1 = Vx1SB->value();
    double Vy1 = Vy1SB->value();
    qDebug()<<Vx0<<Vx1<<Vy0<<Vy1;

    qDebug()<<"makebuffer aoline";
    for (int i = 0 ; i<bufferSize ; i++)
    {
        if (i%2==0) //paire
        {
            buffer[i]=Vx0;
            buffer[i+bufferSize]=Vy0;
            //qDebug()<<"pair"<<Vx0<<Vy0;
        }
        else
        {
            buffer[i]=Vx1;
            buffer[i+bufferSize]=Vy1;
            //qDebug()<<"impair"<<Vx1<<Vy1;
        }

        //qDebug()<<i<<buffer[i]<<" "<<buffer[i+bufferSize];
    }

    return buffer;
}

/**
  * @brief
  */
void aoDoubleTweezer::setBufferSize(int bSize)
{
    bufferSize = bSize;
}
