/**
  * \file aiParameter.h
  * \author Blanc.O & Chardes.C
  * \version 0.1
  * \date 11 janvier 2010
  */

#ifndef AIPARAMETERS_H
#define AIPARAMETERS_H

#include <QCheckBox>
#include <QComboBox>
#include <QDoubleSpinBox>
#include <QGridLayout>
#include <QGroupBox>
#include <QLabel>
#include <QSpinBox>
#include <QString>
#include <QWidget>

#include "tool.h"

class aiParameters : public QWidget
{
    Q_OBJECT;

public :
        aiParameters (qConsole *thisConsole, QWidget *parent = 0);
        ~aiParameters ();

        int getBufferSize ();
        int getNChannels();
        int getSamplingRate();
        int getNBuffer();
        bool getWait4it();

private :
        QSpinBox *nChannelsSB, *bufferSizeSB, *samplingRateSB, *bufferNumberSB;
        QCheckBox *wait4itCB;

        QLabel *infoL;
        qConsole *console;

private slots :
        void nChannelChanged(int n);
        void acquLengthChanged ();

};
#endif // AIPARAMETERS_H
