/**
  * \file aiParameters.cpp
  * \author Blanc.O & Chardes.C
  * \version 0.1
  * \date 11 janvier 2010
  */


#include "aiParameters.h"

/**
 * @brief aiParameters::aiParameters - constructor
 * @param thisConsole
 * @param parent
 */
aiParameters::aiParameters(qConsole *thisConsole, QWidget *parent)
{

    //nAIChannelsSB definition
    nChannelsSB = new QSpinBox();
    nChannelsSB->setRange(1, 8);
    nChannelsSB->setValue(4);
    nChannelsSB->setPrefix("nb AI\t");
    nChannelsSB->setDisabled(true);

    //bufferSizeSB definition
    bufferSizeSB = new QSpinBox();
    bufferSizeSB->setRange(100, 1000000);
    bufferSizeSB->setValue(1000);
    bufferSizeSB->setPrefix("buffer size\t");

    //samplingRateSB definition
    samplingRateSB = new QSpinBox ();
    samplingRateSB->setRange(1, 250000);
    samplingRateSB->setValue(1000);
    samplingRateSB->setSuffix ("   (sa.s-1)");

    //bufferNumberSB definition
    bufferNumberSB = new QSpinBox();
    bufferNumberSB->setRange(1, 1000);
    bufferNumberSB->setValue(1);
    bufferNumberSB->setPrefix("n buffer    ");

    //wai4it checkbox
    wait4itCB = new QCheckBox("Wait for it...");
    wait4itCB->setChecked(false);
    wait4itCB->setToolTip("if checked, record task will wait for an external trigger on the PFI 0 input" );

    infoL = new QLabel ("acquisition overall length...");

    QGridLayout *layout = new QGridLayout();
    //ligne 1
    layout->addWidget(nChannelsSB, 0, 0, 1, 1);
    layout->addWidget(bufferSizeSB, 0, 1, 1, 1);
    layout->addWidget(samplingRateSB, 0, 2, 1, 1);
    layout->addWidget(bufferNumberSB, 0, 3, 1, 1);
    //ligne 2
    layout->addWidget(infoL, 1, 0, 1, 2);
    layout->addWidget(wait4itCB, 1, 2, 1, 2);

    setLayout(layout);

    connect (nChannelsSB, SIGNAL(valueChanged(int)), this, SLOT(nChannelChanged(int)));

    connect (bufferSizeSB, SIGNAL(editingFinished()), this, SLOT(acquLengthChanged()));
    connect (samplingRateSB, SIGNAL(editingFinished()), this, SLOT(acquLengthChanged()));
    connect (bufferNumberSB, SIGNAL(editingFinished()), this, SLOT(acquLengthChanged()));

}

/**
 * @brief aiParameters::~aiParameters - destructor
 */
aiParameters::~aiParameters()
{
}

/**
 * @brief aiParameters::nChannelChanged
 * @param n
 */
void aiParameters::nChannelChanged(int n)
{
    int max = int(250000/nChannelsSB->value());
    samplingRateSB->setRange(1, max);
    if (samplingRateSB->value()>max)
        samplingRateSB->setValue(max);
}

/**
 * @brief aiParameters::acquLengthChanged
 */
void aiParameters::acquLengthChanged()
{
    QString TT("filling of the buffer last : ");
    double t = bufferNumberSB->value()*bufferSizeSB->value()/samplingRateSB->value();

    TT.append(QString::number(t));
    TT.append("  (s).");
    infoL->setText(TT);
}

/**
 * @brief aiParameters::getBufferSize
 * @return
 */
int aiParameters::getBufferSize()
{
    return(bufferNumberSB->value()*bufferSizeSB->value());
}

/**
 * @brief aiParameters::getNChannels
 * @return
 */
int aiParameters::getNChannels()
{
    return(nChannelsSB->value());
}

/**
 * @brief aiParameters::getSamplingRate
 * @return
 */
int aiParameters::getSamplingRate()
{
    return(samplingRateSB->value());
}

/**
 * @brief aiParameters::getNBuffer
 * @return
 */
int aiParameters::getNBuffer()
{
    return(bufferNumberSB->value());
}

/**
 * @brief aiParameters::getWait4it
 * @return
 */
bool aiParameters::getWait4it()
{
    return(wait4itCB->isChecked());
}
