/**
  * \file aogenerator.h
  * \author Blanc.O & Chardes.C
  * \version 0.1
  * \date 11 janvier 2010
  */

#ifndef AOGENERATOR_H
#define AOGENERATOR_H

#include <QCheckBox>
#include <QDateTime>
#include <QDebug>
#include <QFile>
#include <QGridLayout>
#include <QGroupBox>
#include <QLabel>
#include <QLineEdit>
#include <QMap>
#include <QMapIterator>
#include <QPushButton>
#include <QSpinBox>
#include <QString>
#include <QStringList>
#include <QTextStream>
#include <QWidget>

#include <stdio.h>
#include <time.h>
#include <windows.h>
#include <winbase.h>

#include "NIDAQmx.h"
#include "aiParameters.h"
#include "aoline.h"
#include "aodoubletweezer.h"
#include "constant.h"
#include "tool.h"
#include "waveformMaker.h"


class aoGenerator : public QWidget
{
        Q_OBJECT

public :

        aoGenerator (QWidget * parent = 0);
        ~aoGenerator();

        // TASKHANDLE Accessors
        TaskHandle getAIHandle();
        TaskHandle getSCOHandle();
        TaskHandle getCOHandle();

        // Event Trigged function
        void NCB ();
        int32 aiDCB ();  //aka Analog Input Done Call Back
        int32 scoDCB (); //aka Start COunter Done Call Back
        int32 coDCB ();  //aka COunter Done Call Back

        float *x;
        float *y;
        float *Vx;
        float *Vy;

private :

        float64 *buffer;

        //TASKHANDLE
        TaskHandle aoTask;  //aka Analog Output Task
        TaskHandle aiTask;  //aka Analog Input Task
        TaskHandle scoTask; //aka Start COunter Task
        TaskHandle coTask;  //aka Counter Task

        int aiChannelNumber, aoChannelNumber;

        //Gui object : Qt
        QLineEdit *fNameE;
        QGroupBox *wfmBox1;
        QGroupBox *wfmBox2;
        QGroupBox *aiBox;
        QGroupBox *lineBox;
        QGroupBox *doubleTBox;
        QPushButton *startGenPB;
        QPushButton *zeroGenPB;
        QPushButton *onePulsePB;
        QPushButton *aiRecordPB;
        QSpinBox *bufferSizeSB;
        QSpinBox *samplingRateSB;
        QFile *file;
        QTextStream *out;
        QString *fileName;
        QString *folder;

        //GUI object : custom
        browseSystemWidget *browseFolder;
        waveformMaker *wfm1;
        waveformMaker *wfm2;
        aiParameters *aiParam;
        qConsole *console;
        AOLine *aoline;
        aoDoubleTweezer *aoDoubleT;

        QGroupBox *boxIt (QWidget *wToBox, QString header);
        static int32 CVICALLBACK EveryNCallback (TaskHandle taskHandle, int32 EveryNsamplesEventType, uInt32 nSamples, void *calbackData);
        void GetTerminalNameWithDevPrefix (TaskHandle taskHandle, const char terminalName[], char triggerName[]);

private slots :

        void startStopGen(bool state);
        void aiRecord(bool state);
        void justOnePulse ();
        void makeHeader ();
        void zeroGeneration();
        void data(float64 aiBuffer[],int bSize);
        void DAQErrChk(int32 DAQError, QString fctName);
        void test(bool state);

signals :

        void newD(float64 aiBuffer[], int bSize);
};

#endif // AOGENERATOR_H

