% [X,Y,P] = IMPROFILE_THICK(IM, X1, X2, Y1, Y2, THICKNESS) returns 
%
% Syntax:  [x,y,p] = improfile_thick(im, x1, x2, y1, y2, thickness)
%
% Inputs:
%    im - image (uint16)
%    x1 - x min position (double)
%    x2 - x max position (double)
%    y1 - y min position (double)
%    y2 - y max position (double)
%    thickness - not used for the moment - 3 by default
%
% Outputs:
%    x - x positions 
%    y - y positions
%    p - mean profile of 3 paralell lines centered on the (x,y) positions
%
% Other m-files required: 
% Subfunctions: improfile
% MAT-files required: 
%

% Author: Chardes.C, IBDM
% email address: claire.chardes@univ-amu.fr
% 2012 

%------------- BEGIN CODE --------------

function [x,y,p] = improfile_thick(im, x1, x2, y1, y2, thickness)

% 'thickness of the profile is 3'
v = [(x2-x1); (y2-y1)];
vortho = [y1-y2, x2-x1];
vortho = vortho/(norm(vortho));

x3 = x1+vortho(1);
y3 = y1+vortho(2);
x4 = x2+vortho(1);
y4 = y2+vortho(2);

x5 = x1-vortho(1);
y5 = y1-vortho(2);
x6 = x2-vortho(1);
y6 = y2-vortho(2);

[x,y,p1] = improfile(im, [x1,x2],[y1,y2]);
p2 = improfile(im, [x3,x4],[y3,y4], numel(p1));
p3 = improfile(im, [x5,x6],[y5,y6], numel(p1));

p = (p1+p2+p3)/3.0;

end
%------------- END OF CODE --------------