% im = imgaussian2d(iSize, jSize, sigma, u0, v0) generate an 2d gaussian 
% (image) centered at the point (u0,v0). iSize is the size of the resulted 
% image, and sigma is the standard deviation of the gaussian function (same
% in the 2 directions).
% 
% Syntax: im = imgaussian2d(iSize, jSize, sigma, u0, v0)
%
% Inputs:
%    iSize - 
%    jSize - 
%    sigma - 
%    u0 -
%    v0 - 
%    
% Outputs:
%    im
%
% Other m-files required: 
% Subfunctions: 
% MAT-files required: 
%

% Author: Chardes.C, IBDM
% email address: claire.chardes@univ-amu.fr
% 2012 

%------------- BEGIN CODE --------------
function im = imgaussian2d(iSize, jSize, sigma, u0, v0)

x = 1:jSize;
%y = x';
y = (1:iSize)';
imx = 1/(sigma*sqrt(2*pi))*exp(-(x-u0).*(x-u0)/(2*sigma^2));
imy = exp(-(y-v0).*(y-v0)/(2*sigma^2));

im = imy*imx;

end
%------------- END OF CODE --------------