% [x,y] = getXYPos(ffolder, fname, nIm0, nIm1) returns the x and y
% positions for the "better" bead.
%
% Syntax: [x,y] = getXYPos(ffolder, fname, nIm0, nIm1)
%
% Inputs:
%    ffolder
%    fname
%    nIm0
%    nIm1
%
% Outputs:
%    x - x positon
%    y - y position
%
% Other m-files required: 
% Subfunctions: 
% MAT-files required: 
%

% Author: Chardes.C, IBDM
% email address: claire.chardes@univ-amu.fr
% 2012 

%------------- BEGIN CODE --------------
function [x,y] = getXYPos(ffolder, fname, nIm0, nIm1)

% open image stack
if isequal(fname,0) || isequal(ffolder,0) % nothing selected
    disp('User pressed cancel');          
else
    
    info = imfinfo([ffolder, fname]);
    image(:,:) = zeros(info(1,1).Height, info(1,1).Width);
    x = zeros(nIm1-nIm0+1,1);
    y = x;
    xmin = 1;
    xmax = 1000;
    ymin = 1;
    ymax = 1000;
    for nIm=nIm0:nIm1
        disp(nIm);
        % read image
        image = imread([ffolder, fname], 'tif', nIm);
        % find x y position of the bead
        [x0,y0] = detect_reconnex(image(:,:), 10, 50);
        ind = find(x0>xmin & x0<xmax & y0>ymin & y0<ymax);
        if (numel(ind)>1)
            x(nIm-nIm0+1) = x0(ind(1));
            y(nIm-nIm0+1) = y0(ind(1));
        else
            if (numel(ind) == 1)
                x(nIm-nIm0+1) = x0(ind);
                y(nIm-nIm0+1) = y0(ind);
            else
                x(nIm-nIm0+1) = 0;
                y(nIm-nIm0+1) = 0;
            end
        end
        
        % display
%         figure(120);
%         colormap('gray');
%         imagesc(image);
%         hold on;
%         plot(x(nIm-nIm0+1),y(nIm-nIm0+1),'xr');
%         hold off;
        
        % Hand control of the localization
%         choice = questdlg('Is localization fine?', ...
%          'Hand Control', ...
%          'Yes','No', 'Yes');
%         % Handle response
%         switch choice
%             case 'Yes'
%                 disp([nIm ' detection is ok'])                
%             case 'No'
%                 disp([nIm ' detection to NaN'])
%                 x(nIm) = NaN;
%                 y(nIm) = NaN;
%         end

    end
    
    figure(27);
    plot(x, y, 'xb');
    axis equal
    xlabel('x(pixel)');
    ylabel('y(pixel)');
    
    % keep points inside a hand made polygon
    h = impoly;
    position = wait(h);
    IN = inpolygon(x,y,position(:,1),position(:,2));
    figure(27); hold on; plot(x(IN), y(IN), 'ro');
    x = x(IN);
    y = y(IN);
    figure(27); hold off; plot(x,y,'xb');
    
    % Hand correction of the localization
    flag = 0;
    while (flag == 0)
        choice = questdlg('Do you want to eliminate a point?', ...
         'Hand Correction', ...
         'Yes','No', 'Yes');
        % Handle response
        switch choice
            case 'Yes'
                disp('select a point');
                [a,b] = ginput(1);
                ind = closestPoint(x,y,a,b);
                x(ind) = NaN;
                y(ind) = NaN;
                disp(['point ', num2str(ind), 'put to NaN']);
                figure(27); hold off; plot(x,y,'xb');
            case 'No'
                disp('perfect detection');
                flag = 1;
        end
    end
    
end

% find bead position (subpixel localization)


%------------- END OF CODE --------------
