% [Vx, Vy] = getVxVy(ffolder, fname) returns the tensions Vx and Vy for 
% each image.
% reads a text file and calculate the mean tensions Vx and Vy
% corresponding to each image acquired by the camera (based on the fire of
% the camera)
%
% Syntax: [Vx, Vy] = getVxVy(ffolder, fname)
%
% Inputs:
%    ffolder
%    fname
%
% Outputs:
%    Vx - tensions galvo 1 
%    Vy - tensions galvo 2
%
% Other m-files required: 
% Subfunctions: 
% MAT-files required: 
%

% Author: Chardes.C, IBDM
% email address: claire.chardes@univ-amu.fr
% 2012 

%------------- BEGIN CODE --------------
function [Vx, Vy] = getVxVy(ffolder, fname)

% open text file
if isequal(fname,0) || isequal(ffolder,0) % nothing selected
    disp('User pressed cancel');          
else
    
        % read text file recorded during the acquisition
        % 1st colonn of data: Vx
        % 2nd colonn of data: Vy
        % 3rd colonn of data: TTL
        signal = importdata([ffolder,fname]);
        data = signal.data;
        
        % obtain mean Vx and mean Vy for each image
        TTL = data(:,3)>4.4;
        Vx = [];
        Vy = [];
        ind = [];
        for inc=1:size(TTL,1) 
            if (TTL(inc)==1)
                ind = [ind, inc];
            else
                if (~isempty(ind))
                    Vx = [Vx, mean(data(ind, 1))];
                    Vy = [Vy, mean(data(ind, 2))];
                   ind = [];
                end
            end
        end
        figure(28); 
        plot(Vx,'xb');
        set(gca,'XGrid','on');
        set(gca,'XTick',0:50:size(Vx,2));
        hold on; plot(Vy, '*r');
        xlabel('# image');
        ylabel('V(volt)');
        hold off;
end

%------------- END OF CODE --------------