%% function g=gausswin2(sig, wn_i, wn_j, offset_i, offset_j)
%%
%% generation d_une gaussienne 2D
%% de largeur sig, de puissance 1
%% sur une fenetre carree wn
%%
%% ex : g=gausswin2(1.3, 8)
%%
%% si deux arguments supplementaire
%% alors offset_x et offset_y (en pixel)
%%
%% ex : g=gausswin2(1.3, 8, 0.3, -0.8)
%%
%% si un nombre d_arguments impaire la taille 
%% de la fenetre differente en i et j :
%% 
%% ex : g=gausswin2(1.3, 8, 9, 0.3, -0.8)


function g=gausswin2(sig, wn_i, wn_j, offset_i, offset_j)

if (nargin < 5)
  offset_i = 0.0 ;
  offset_j = 0.0 ;
end%if

if (nargin < 3)
     wn_j = wn_i ;
end%if

refi = 0.5 + (0:(wn_i-1)) - wn_i/2 ;
i = refi - offset_i ;
refj = 0.5 + (0:(wn_j-1)) - wn_j/2 ;
j = refj - offset_j ;
ii = i' * ones(1,wn_j) ; %'
jj = ones(wn_i,1) * j ;   

%% puissance unitaire
g = (1/(sqrt(pi)*sig)) * exp(-(1/(2*sig^2))*(ii.*ii + jj.*jj)) ;

 %function
