% DIST = COORD2DIST(X,Y) returns the distance between consecutive points 
% in the list done by the coordinates (X,Y)
%
% Syntax: dist = coord2dist(x,y)
%
% Inputs:
%    X - x  position (double)
%    Y - Y position (double)
%    
% Outputs:
%    dist - distance
%
% Other m-files required: 
% Subfunctions: 
% MAT-files required: 
%

% Author: Chardes.C, IBDM
% email address: claire.chardes@univ-amu.fr
% 2012 

%------------- BEGIN CODE --------------
function dist = coord2dist(x,y)

    dist = zeros(numel(x), 1);

    for i=2:numel(x)

        dist(i) = sqrt((x(i)-x(1))*(x(i)-x(1))+(y(i)-y(1))*(y(i)-y(1)));

    end

end

%------------- END OF CODE --------------