% ind = closestPoint(X,Y,x0,y0) returns the index of the closest point in
% the vector (X,Y) from the point (x0,y0)
%
% Syntax: ind = closestPoint(X,Y,x0,y0)
%
% Inputs:
%    X - X values 
%    Y - Y values - [X,Y] is the list of points to be compared.
%    x0 - x of the ref point
%    y0 - y of the ref point
% Outputs:
%    ind
%
% Other m-files required: 
% Subfunctions: 
% MAT-files required: 
%

% Author: Chardes.C, IBDM
% email address: claire.chardes@univ-amu.fr
% 2011 

%------------- BEGIN CODE --------------
function ind = closestPoint(X,Y,x0,y0)

    distance = 10000;
    ind = 0;

    for i=1:numel(X)
        if (sqrt((X(i)-x0)*(X(i)-x0)+(Y(i)-y0)*(Y(i)-y0))<distance)
            distance = sqrt((X(i)-x0)*(X(i)-x0)+(Y(i)-y0)*(Y(i)-y0));
            ind = i;
        end
    end

end

%------------- END OF CODE --------------