//add required libraries
#include "Timer.h"
#include <AccelStepper.h>

//initialize constructs
Timer t1, t2;
AccelStepper stepper2(1, 10, 13);
AccelStepper stepper1(1, 9, 8);

//initialize global variables
int milliTiming = 200;
int printTiming = 1000;
float setPoint1 = 0.75;
float setPoint2 = 0.75;
float sensor1 = 0;
float sensor2 = 0;
float error1 = 0;
float error2 = 0;
float error1RunSum = 0;
float error2RunSum = 0;
float previousError1 = 0;
float previousError2 = 0;
float stepper1Out = 1;
float stepper2Out = 1;
float maxError = 5.0;

//set gains
float Kp = 10000;
float Ki = 5.0;
float Kd = 5000;

//from calibration offset
//these can be different for every sensor
float sensor1Offset = 0.00;
float sensor2Offset= 0.00;

//initial setup
void setup()
{
  stepper1.setMaxSpeed(6000);
  stepper2.setMaxSpeed(6000);
  
  Serial.begin(9600);
  
  t1.every(milliTiming, simplePID);
  t2.every(printTiming, printReading);
}

//main loop
void loop()
{
  t1.update();
  t2.update();

  stepper1.setSpeed(-1*stepper1Out);
  stepper2.setSpeed(-1*stepper2Out);
  
  stepper1.runSpeed();
  stepper2.runSpeed();

// For interface move
  if (millis()>4*40000 && millis()<4*80000) {
    setPoint1 = 0.85;
    setPoint2 = 0.65;
    error1RunSum = 0;
    error2RunSum = 0;
  }
  
  else if (millis()>4*80000 && millis()<=4*120000) {
    setPoint1 = 1.0;
    setPoint2 = 0.5;
    error1RunSum = 0;
    error2RunSum = 0;
  }

  else if (millis()>4*120000 && millis()<=4*160000) {
    setPoint1 = 0.85;
    setPoint2 = 0.65;
    error1RunSum = 0;
    error2RunSum = 0;
  }

  else if (millis()>4*160000 && millis()<=4*200000) {
    setPoint1 = 0.75;
    setPoint2 = 0.75;
    error1RunSum = 0;
    error2RunSum = 0;
  }

  else if (millis()>4*200000 && millis()<=4*240000) {
    setPoint1 = 0.65;
    setPoint2 = 0.85;
    error1RunSum = 0;
    error2RunSum = 0;
  }

  else if (millis()>4*240000 && millis()<=4*280000) {
    setPoint1 = 0.50;
    setPoint2 = 1.0;
    error1RunSum = 0;
    error2RunSum = 0;
  }

  else if (millis()>4*280000 && millis()<=4*320000) {
    setPoint1 = 0.65;
    setPoint2 = 0.85;
    error1RunSum = 0;
    error2RunSum = 0;
  }

  else if (millis()>4*320000 && millis()<=4*360000) {
    setPoint1 = 0.75;
    setPoint2 = 0.75;
    error1RunSum = 0;
    error2RunSum = 0;
  }

  else if (millis()>4*360000 && millis()<=4*400000) {
    setPoint1 = 0.75;
    setPoint2 = 0.75;
    error1RunSum = 0;
    error2RunSum = 0;
  }

}

//PID function
void simplePID()
{
  takeReading();
  error1 = (setPoint1 - (sensor1-sensor1Offset)) / maxError;
  error2 = (setPoint2 - (sensor2-sensor2Offset)) / maxError;
  
  float P1 = Kp * error1;
  float I1 = Ki * error1RunSum;
  float D1 = Kd * (error1 - previousError1);

  float P2 = Kp * error2;
  float I2 = Ki * error2RunSum;
  float D2 = Kd * (error2 - previousError2);
  
  float PID1 = P1 + I1 + D1;
  float PID2 = P2 + I2 + D2;
  
  stepper1Out = PID1;
  stepper2Out = PID2;

  if (stepper1Out > 6000) {
    stepper1Out = 6000;
  }

  if (stepper1Out < -6000) {
    stepper1Out = -6000;
  }

  if (stepper2Out > 6000) {
    stepper2Out = 6000;
  }

  if (stepper2Out < -6000) {
    stepper2Out = -6000;
  }
  
  error1RunSum = error1RunSum + error1;
  error2RunSum = error2RunSum + error2;
  previousError1 = error1;
  previousError2 = error2;
  
}

void takeReading()
{
  sensor1 = analogRead(1)*5.0/1024.0;
  sensor2 = analogRead(2)*5.0/1024.0;
}

void printReading()
{
  String MillisTime = String(millis());
  String Output = String(String(sensor1,3) + ", " + String(sensor2,3) + ", " + MillisTime + ", " + String(stepper1Out) + ", " + String(stepper2Out));
  Serial.println(Output);
}

