%%% Note: This is an example script for step 5.3, which could be used to compute the omega complexity of 
%%% eight frequency bands (delta, theta, alpha1, alpha2, beta1, beta2, gamma1, and gamma2) through averaging the omega complexity of frequency points within each frequency limit.
%%% The omega complexity of each frequency point was computed using sLORETA(Utilities --> Global connectivity) before this step.
%%% This script was designed to compute the global omega complexity of eight frequency bands. However, it could also be used to 
%%% compute the anterior/posterior omega complexity of eight frequency bands after small modification.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clc;clear all
cd('G:\QQPCmgr\Desktop\jove\spatial_complexity\global\normal');
%%% Set the above folder, which stores the global omega complexity computed in sLORETA, as current folder.
%%% The 15 asc files, which store the the global omega complexity of 15 subjects, can be seen in this folder. 
for i = 1:15  %%% The '15' is the number of subejcts.
    data = load(['normal',num2str(i),'-Classic-257x5-ConnDimNoHeader.asc']);
    normal{1,i} = data;
end
save normal normal
%%%%%% Load the global omega complexity of all 15 subjects.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%  index = {'TotConn','InstConn','LagConn','OmegaCmplx','SourceDimnsion'};
for idx = 4 %%%%% The forth column of each asc loaded above stores the omega complexity value.  
    for i = 1:15  %%% The '15' is the number of subejcts.
        n(i,:) = normal{1,i}(:,idx);   %%%%15*257
    end
    %%%%% The variable is a 15(number of subjects) by 257(number of frequency points) matrix.
    %%%%% Since the sampling rate of EEG data and the length of each epoch
    %%%%% are 256 Hz and 2 sec respectively, the Nyquist frequency and frequency resolution during FFT is 128 Hz and 0.5 Hz, which result in 257 frequency points (0:0.5:128). 
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%  delta: 0.5~3.5 Hz, theta: 4~7.5 Hz, alpha1: 8~10 Hz,
    %%%%  alpha2: 10.5~13.5 Hz,beta1: 14~18 Hz, beta2: 18.5~30 Hz, gamma1: 30.5~48 Hz;
    %%%%  gamma2: 52~80 Hz
    global_sc(:,1) = mean(n(:,2:8),2);      %%%%  delta
    global_sc(:,2) = mean(n(:,9:16),2);     %%%%  theta
    global_sc(:,3) = mean(n(:,17:21),2);    %%%%  alpha1
    global_sc(:,4) = mean(n(:,22:28),2);    %%%%  alpha2
    global_sc(:,5) = mean(n(:,29:37),2);    %%%%  beta1
    global_sc(:,6) = mean(n(:,38:61),2);    %%%%  beta2
    global_sc(:,7) = mean(n(:,62:97),2);    %%%%  gamma1
    global_sc(:,8) = mean(n(:,105:161),2);  %%%%  gamma2   
end
 save global_sc global_sc   
    
    
    
    
  


    

