%%% This is an example script for step 5.1 (Save the EEG data of each epoch and each subject in ASCII format).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clc;clear
files = dir('G:\QQPCmgr\Desktop\jove\preprocessed_eegdata');
%%%%%%  The above folder stores all the preprocessed EEG data (****.set)
a = 0;
for i = 3:length(files)
    if strcmp(files(i,1).name(end-2:end),'set') == 1
        a = a+1;
        filenames{a,1} = files(i,1).name;
    end
end
a
%%%%%%%% Store the file names of preprocessed EEG data (****.set) of all 15
%%%%%%%% subejcts in the variable 'filenames'.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
filepaths = {'G:\QQPCmgr\Desktop\jove\preprocessed_eegdata'};%%%%%%%% 
for f = 1:length(filenames)
    EEG = pop_loadset('filename',filenames{f},'filepath',filepaths{1,1});  %%%% load the prprocessed EEG data of each subject.
    EEG = eeg_checkset( EEG );
    EEG = pop_reref( EEG, []);  %%%%  The reference electrodes of EEG data were converted to common average.
    EEG = eeg_checkset( EEG );
    data1  = EEG.data;  %%%%%% The EEG data is stored in the field 'data' of variable 'EEG'. 
    data1 = double(data1);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    mkdir(['G:\QQPCmgr\Desktop\jove\MapWin\microstate_analysis\normal\normal',num2str(f)]);
    cd(['G:\QQPCmgr\Desktop\jove\MapWin\microstate_analysis\normal\normal',num2str(f)]);
    for i = 1:size(data1,3)
        data2 = squeeze(data1(:,:,i))';
        save([num2str(i),'.asc'],'data2','-ascii');
    end
    %%%%% Store the EEG data of each epoch in asc file with 8-digit ASCII format.
end