#!/usr/bin/env python

import sys, os, string, operator, glob, gzip, math, time

args = sys.argv
if len(args) != 2:
    print 'Usage:', args[0], 'inputDir'
    sys.exit()

statdict = {}
inputdir = args[1]
filelist = glob.glob(os.path.join(inputdir, '*.txt'))
for filename in filelist:
    infotag, sampleId, counttag = os.path.basename(filename).rsplit('_', 2)
    mycount = int(counttag.replace('.txt', ''))
    statdict.setdefault(sampleId, [0]*5)
    if infotag == 'SAMPLE_TAG_FULLEND_L_TRIMMED': statdict[sampleId][0] += mycount
    if infotag == 'SAMPLE_TAG_FULLEND_NO_TRIMMED': statdict[sampleId][1] += mycount
    if infotag == 'SAMPLE_TAG_NOMATCH': statdict[sampleId][2] += mycount
    if infotag == 'SAMPLE_TAG_TRUNCATED_L_TRIMMED': statdict[sampleId][3] += mycount
    if infotag == 'SAMPLE_TAG_TRUNCATED_NO_TRIMMED': statdict[sampleId][4] += mycount

print '%s\t%s\t%s\t%s\t%s\t%s' % ('sampleId', 'SAMPLE_TAG_FULLEND_L_TRIMMED', 'SAMPLE_TAG_FULLEND_NO_TRIMMED', 'SAMPLE_TAG_NOMATCH', 'SAMPLE_TAG_TRUNCATED_L_TRIMMED', 'SAMPLE_TAG_TRUNCATED_NO_TRIMMED')
statlist = statdict.keys()
statlist.sort()
for sampleId in statlist:
    wlist = [sampleId] + statdict[sampleId]
    print '\t'.join(map(str, wlist))













"""
-rw-rw-r-- 1 deepreds deepreds 435239 Oct 26 15:42 SAMPLE_TAG_FULLEND_L_TRIMMED_F2L_4826.txt
-rw-rw-r-- 1 deepreds deepreds  51970 Oct 26 15:42 SAMPLE_TAG_FULLEND_NO_TRIMMED_F2L_765.txt
-rw-rw-r-- 1 deepreds deepreds 124876 Oct 26 15:42 SAMPLE_TAG_NOMATCH_F2L_709.txt
-rw-rw-r-- 1 deepreds deepreds 303426 Oct 26 15:42 SAMPLE_TAG_TRUNCATED_L_TRIMMED_F2L_4254.txt
-rw-rw-r-- 1 deepreds deepreds 147307 Oct 26 15:42 SAMPLE_TAG_TRUNCATED_NO_TRIMMED_F2L_2331.txt
"""

