#!/usr/bin/env python

import sys, os, string, operator, glob, gzip, math, time

args = sys.argv
if len(args) != 3:
    print 'Usage:', args[0], 'inputDir outputDir'
    sys.exit()

inDir = args[1]
outDir = args[2]

#inDir = 'Preprocessed_Separate_Samples2/raw_data'
#outDir = 'Preprocessed_Separate_Samples2'

fileDict = {}
for filename in glob.glob(os.path.join(inDir, '*.txt')):
    filebase = os.path.basename(filename)
    filestem = filebase.split('_', 1)[1]
    for lines in open(filename, 'r').xreadlines():
        try:
            fileDict[filestem].write(lines)
        except:
            fileDict[filestem] = open(os.path.join(outDir, filestem), 'w')
            fileDict[filestem].write(lines)
for ofile in fileDict.keys():
    fileDict[ofile].close()

# ADD SEQUENCE NUMBER AT THE END OF FILE NAME
fileList = glob.glob(os.path.join(outDir, '*.txt'))
for filename in fileList:
    nSeq = 0
    for lines in open(filename, 'r').xreadlines():
        if lines[0] == '>': nSeq += 1
    q = os.rename(filename, filename[:-4] + '_' + str(nSeq) + '.txt')

"""
[deepreds@s48 Retrovirus_Pyrosequencing]$ ls Preprocessed_Separate_Samples2/0_*
Preprocessed_Separate_Samples2/0_SAMPLE_ID_INFORMATION.txt
Preprocessed_Separate_Samples2/0_SAMPLE_NOTAG.txt
Preprocessed_Separate_Samples2/0_SAMPLE_OTHERS.txt
Preprocessed_Separate_Samples2/0_SAMPLE_TAG_FULLEND_L_TRIMMED3.txt
Preprocessed_Separate_Samples2/0_SAMPLE_TAG_FULLEND_L_TRIMMED.txt
Preprocessed_Separate_Samples2/0_SAMPLE_TAG_FULLEND_NO_TRIMMED2.txt
Preprocessed_Separate_Samples2/0_SAMPLE_TAG_FULLEND_NO_TRIMMED3.txt
Preprocessed_Separate_Samples2/0_SAMPLE_TAG_FULLEND_NO_TRIMMED.txt
Preprocessed_Separate_Samples2/0_SAMPLE_TAG_NOMATCH.txt
Preprocessed_Separate_Samples2/0_SAMPLE_TAG_TRUNCATED_L_TRIMMED3.txt
Preprocessed_Separate_Samples2/0_SAMPLE_TAG_TRUNCATED_L_TRIMMED.txt
Preprocessed_Separate_Samples2/0_SAMPLE_TAG_TRUNCATED_NO_TRIMMED2.txt
Preprocessed_Separate_Samples2/0_SAMPLE_TAG_TRUNCATED_NO_TRIMMED3.txt
Preprocessed_Separate_Samples2/0_SAMPLE_TAG_TRUNCATED_NO_TRIMMED.txt
"""

