#!/usr/bin/env python

import sys, os, string, operator, gzip, glob, time, math, csv, popen2, copy

args = sys.argv
if len(args) != 4:
    print 'Usage:', args[0], 'inputfasta outDir runId[0-7]'
    sys.exit()

inputname =args[1]#'trial_run.fa'#'sanggu_oct2011run_total536507.txt'# args[1]
outDir = args[2]#'justrun'#args[2]
runId = args[3]
#Function to generate revers compliment
def RC(inSeq):
    cDict = {'a':'t', 't':'a', 'g':'c', 'c':'g', 'A':'T', 'T':'A', 'G':'C', 'C':'G', 'u':'a', 'U':'A'}
    outSeq = ''.join([cDict.get(inSeq[ix], inSeq[ix]) for ix in range(len(inSeq) -1, -1, -1)])
    return outSeq

def GetTmpDir():
    tDir = '/tmp'
    runList = glob.glob('/tmp/run*')
    while 1:
        try:
            tmpDir = os.path.join(tDir, 'run%d' % len(runList))
            os.mkdir(tmpDir)
            break
        except:
            time.sleep(1)
            continue
    return tmpDir

#tmpDir = GetTmpDir()
try:
    os.mkdir('tmp/run%s' % runId)
except:
    pass
tmpDir = 'tmp/run%s' % runId
os.system('rm -f %s' % os.path.join(tmpDir, '*.fa')) # CLEAN UP
os.system('cp water %s' % tmpDir)

# FIRST LINE: FIELD IDENTIFIER, TAB-DELIMITED TEXT
csvReader = csv.reader(open('Demultiplexing_Trimming_blunt_GTAC.tsv', 'rU'), delimiter = '\t')
#csvReader = csv.reader(open('Plan_Documents24/INDICATOR_Dec2012_NK_UPPER.txt', 'r'), delimiter = '\t')
#csvReader = csv.reader(open('Plan_Documents20/INDICATOR_11232011_UPPER.txt', 'r'), delimiter = '\t')
#csvReader = csv.reader(open('Plan_Documents16/INDICATOR_101511a_UPPER.txt', 'r'), delimiter = '\t')
#csvReader = csv.reader(open('Plan_Documents14/INDICATOR_073111-3_UPPER.txt', 'r'), delimiter = '\t')
#csvReader = csv.reader(open('Plan_Documents13/INDICATOR_060911_UPPER.txt', 'r'), delimiter = '\t')
#csvReader = csv.reader(open('Plan_Documents7/012411_INDICATOR_UPPER.txt', 'r'), delimiter = '\t')
#csvReader = csv.reader(open('Plan_Documents5/092910_INDICATOR-3.txt', 'r'), delimiter = '\t')
#csvReader = csv.reader(open('Plan_Documents3/454_titanium_071510_analysis_indicator_total_yue1_upper.txt', 'r'), \
#    delimiter = '\t')
#csvReader = csv.reader(open('Plan_Documents2/454analysis_indicator_042709.txt', 'r'), delimiter = '\t')
#csvReader = csv.reader(open('Plan_Documents1/454analysis_indicator_total.txt', 'r'), delimiter = '\t')
csvFields = csvReader.next()
csvValues = [row for row in csvReader]
# GATHER ALL
iSample = csvFields.index('SAMPLE')
itag = csvFields.index('MID')
iA = csvFields.index('A')
iB = csvFields.index('B')
iC = csvFields.index('C')
iD = csvFields.index('D')
iDD = csvFields.index('DD')
iE = csvFields.index('E')
iF = csvFields.index('F')
iFF = csvFields.index('FF')
iG = csvFields.index('G')
iJ = csvFields.index('J')
iH = csvFields.index('H')
iI = csvFields.index('I')
iK = csvFields.index('K')
iL = csvFields.index('L')
tagList, aList, bList, cList, dList, ddList, eList, fList, ffList, gList, jhList, iList, kList = \
    [], [], [], [], [], [], [], [], [], [], [], [], []
jnhList = []
kCutDict = {} # L: CUT LENGTH FOR K
sampleList = []

tagseqdict = {}

for row in csvValues:
    if len(row) == 0: continue
    if len(row) > iSample:
        if row[iSample] not in sampleList and len(row[iSample]):
            if len(row) > iB and len(row[itag]) and len(row[iA]) and len(row[iB]):
                sampleList.append((row[iSample], row[itag], row[iA], row[iB]))
    if row[itag] not in tagList and len(row[itag]):
        tagList.append(row[itag])
    if len(row) > iA:
        if row[iA] not in aList and len(row[iA]):
            aList.append(row[iA])
    if len(row) > iB:
        if row[iB] not in bList and len(row[iB]):
            bList.append(row[iB])
    if len(row) > iC:
        if row[iC] not in cList and len(row[iC]):
            cList.append(row[iC])
    if len(row) > iD:
        if row[iD] not in dList and len(row[iD]):
            dList.append(row[iD])
    if len(row) > iDD:
        if row[iDD] not in ddList and len(row[iDD]):
            ddList.append(row[iDD])
    if len(row) > iE:
        if row[iE] not in eList and len(row[iE]):
            eList.append(row[iE])
    if len(row) > iF:
        if row[iF] not in fList and len(row[iF]):
            fList.append(row[iF])
    if len(row) > iFF:
        if row[iFF] not in ffList and len(row[iFF]):
            ffList.append(row[iFF])
    if len(row) > iG:
        if row[iG] not in gList and len(row[iG]):
            gList.append(row[iG])
    if len(row) > iJ and len(row) > iH:
        if row[iJ] + row[iH] not in jhList and len(row[iJ] + row[iH]):
            jhList.append(row[iJ] + row[iH])
            jnhList.append((row[iJ], row[iH]))
    if len(row) > iI:
        if row[iI] not in iList and len(row[iI]):
            iList.append(row[iI])
    if len(row) > iK:
        if row[iK] not in kList and len(row[iK]):
            kList.append(row[iK])
            if len(row) > iL:
                lDistance = int(reduce(operator.add, [ix for ix in row[iL] if ix.isdigit()]))
                kCutDict[row[iK]] = lDistance
    # add tag seq
    if len(row[itag]):
        if len(row[iA]):
            tagseqdict.setdefault(row[itag], {}).setdefault('A', []).append(row[iA])
        if len(row[iB]):
            tagseqdict.setdefault(row[itag], {}).setdefault('B', []).append(row[iB])
        if len(row[iC]):
            tagseqdict.setdefault(row[itag], {}).setdefault('C', []).append(row[iC])
        if len(row[iD]):
            tagseqdict.setdefault(row[itag], {}).setdefault('D', []).append(row[iD])
        if len(row[iDD]):
            tagseqdict.setdefault(row[itag], {}).setdefault('DD', []).append(row[iDD])
        if len(row[iE]):
            tagseqdict.setdefault(row[itag], {}).setdefault('E', []).append(row[iE])
        if len(row[iF]):
            tagseqdict.setdefault(row[itag], {}).setdefault('F', []).append(row[iF])
        if len(row[iFF]):
            tagseqdict.setdefault(row[itag], {}).setdefault('FF', []).append(row[iFF])
        if len(row[iG]):
            tagseqdict.setdefault(row[itag], {}).setdefault('G', []).append(row[iG])
        if len(row[iJ]) and len(row[iH]):
            tagseqdict.setdefault(row[itag], {}).setdefault('JH', []).append(row[iJ]+row[iH])
        if len(row[iI]):
            tagseqdict.setdefault(row[itag], {}).setdefault('I', []).append(row[iI])

tagList.sort()
aList.sort()
bList.sort()
cList.sort()
dList.sort()
ddList.sort()
eList.sort()
fList.sort()
ffList.sort()
gList.sort()
jhList.sort()
iList.sort()
jnhList.sort()
kList.sort()

tagdict = {}
for tag1 in tagseqdict.keys():
    itag = tagList.index(tag1)
    for ikey, vlist in tagseqdict[tag1].items():
        if ikey == 'A':
            vindexlist = [aList.index(ix) for ix in vlist]
            for vindex in vindexlist:
                tagdict.setdefault(itag, {}).setdefault('A', [])
                if vindex not in tagdict[itag]['A']:
                    tagdict[itag]['A'].append(vindex)
        if ikey == 'B':
            vindexlist = [bList.index(ix) for ix in vlist]
            for vindex in vindexlist:
                tagdict.setdefault(itag, {}).setdefault('B', [])
                if vindex not in tagdict[itag]['B']:
                    tagdict[itag]['B'].append(vindex)
        if ikey == 'C':
            vindexlist = [cList.index(ix) for ix in vlist]
            for vindex in vindexlist:
                tagdict.setdefault(itag, {}).setdefault('C', [])
                if vindex not in tagdict[itag]['C']:
                    tagdict[itag]['C'].append(vindex)
        if ikey == 'D':
            vindexlist = [dList.index(ix) for ix in vlist]
            for vindex in vindexlist:
                tagdict.setdefault(itag, {}).setdefault('D', [])
                if vindex not in tagdict[itag]['D']:
                    tagdict[itag]['D'].append(vindex)
        if ikey == 'DD':
            vindexlist = [ddList.index(ix) for ix in vlist]
            for vindex in vindexlist:
                tagdict.setdefault(itag, {}).setdefault('DD', [])
                if vindex not in tagdict[itag]['DD']:
                    tagdict[itag]['DD'].append(vindex)
        if ikey == 'E':
            vindexlist = [eList.index(ix) for ix in vlist]
            for vindex in vindexlist:
                tagdict.setdefault(itag, {}).setdefault('E', [])
                if vindex not in tagdict[itag]['E']:
                    tagdict[itag]['E'].append(vindex)
        if ikey == 'F':
            vindexlist = [fList.index(ix) for ix in vlist]
            for vindex in vindexlist:
                tagdict.setdefault(itag, {}).setdefault('F', [])
                if vindex not in tagdict[itag]['F']:
                    tagdict[itag]['F'].append(vindex)
        if ikey == 'FF':
            vindexlist = [ffList.index(ix) for ix in vlist]
            for vindex in vindexlist:
                tagdict.setdefault(itag, {}).setdefault('FF', [])
                if vindex not in tagdict[itag]['FF']:
                    tagdict[itag]['FF'].append(vindex)
        if ikey == 'G':
            vindexlist = [gList.index(ix) for ix in vlist]
            for vindex in vindexlist:
                tagdict.setdefault(itag, {}).setdefault('G', [])
                if vindex not in tagdict[itag]['G']:
                    tagdict[itag]['G'].append(vindex)
        if ikey == 'JH':
            vindexlist = [jhList.index(ix) for ix in vlist]
            for vindex in vindexlist:
                tagdict.setdefault(itag, {}).setdefault('JH', [])
                if vindex not in tagdict[itag]['JH']:
                    tagdict[itag]['JH'].append(vindex)
        if ikey == 'I':
            vindexlist = [iList.index(ix) for ix in vlist]
            for vindex in vindexlist:
                tagdict.setdefault(itag, {}).setdefault('I', [])
                if vindex not in tagdict[itag]['I']:
                    tagdict[itag]['I'].append(vindex)


junctionDict = {}
iJunction = csvFields.index('JUNCTION')
iAnimal = csvFields.index('VECTOR')
iSample = csvFields.index('SAMPLE')
for row in csvValues:
    if len(row) < max(iJunction, iAnimal, iSample): continue
    if len(row[iSample]) and len(row[iJunction]) and len(row[iAnimal]):
        sampleId = row[iSample]#.replace('_', '').replace('-', '').replace('\'', '').replace('`', '')
        animalId = row[iAnimal].replace('_', '').replace('-', '').replace('\'', '').replace('`', '')
        junctionDict[sampleId] = (row[iJunction], animalId)

sampleIdDict = {}
for sampleId, tagId, aId, bId in sampleList:
    newId = sampleId#.replace('_', '').replace('-', '')
    sampleIdDict[(tagList.index(tagId), aList.index(aId), bList.index(bId))] = newId
    sampleIdDict[(tagList.index(tagId), -1, bList.index(bId))] = newId
    sampleIdDict[(tagList.index(tagId), aList.index(aId), -1)] = newId

# load K check list. August 20, 2010.
kSelectionDict = {}
for row in csvValues:
    if len(row) < max(iJunction, iAnimal, iSample): continue
    if len(row[iSample]) and len(row[iK]):
        kSelectionDict[row[iSample]] = row[iK]

# prefix for all motifs for each sample, later on search only for these motifs
motifDict = {}
for row in csvValues:
    if len(row) < max(iJunction, iAnimal, iSample): continue
    if len(row[iSample]) and len(row[iD]):
        motifDict.setdefault(row[iSample], {})['D'] = row[iD]
    if len(row[iSample]) and len(row[iDD]):
        motifDict.setdefault(row[iSample], {})['DD'] = row[iDD]
    if len(row[iSample]) and len(row[iE]):
        motifDict.setdefault(row[iSample], {})['E'] = row[iE]
    if len(row[iSample]) and len(row[iF]):
        motifDict.setdefault(row[iSample], {})['F'] = row[iF]
    if len(row[iSample]) and len(row[iFF]):
        motifDict.setdefault(row[iSample], {})['FF'] = row[iFF]
    if len(row[iSample]) and len(row[iG]):
        motifDict.setdefault(row[iSample], {})['G'] = row[iG]
    if len(row[iSample]) and len(row[iJ]) and len(row[iH]):
        motifDict.setdefault(row[iSample], {})['JH'] = row[iJ] + row[iH]
    if len(row[iSample]) and len(row[iI]):
        motifDict.setdefault(row[iSample], {})['I'] = row[iI]
    if len(row[iSample]) and len(row[iK]):
        motifDict.setdefault(row[iSample], {})['K'] = row[iK]

def CheckJunction(tagIndex, aIndex, bIndex, sampleIdDict, junctionDict):
    if tagIndex == -1 or aIndex == -1 or bIndex == -1: return ''
    if sampleIdDict.has_key((tagIndex, aIndex, bIndex)):
        sampleId = sampleIdDict[(tagIndex, aIndex, bIndex)]
        Junction = junctionDict[sampleId][0]
    else:
        Junction = ''
    return Junction

# TCGA check list. August 20, 2010.
tcgaCheckDict = {}
#for lines in open('Plan_Documents7/CHECK_TCGA_GTAC_CATG_012411_UPPER.txt', 'r').xreadlines():
#for lines in open('Plan_Documents13/CHECK_TCGA_GTAC_CATG_060911_UPPER.txt', 'r').xreadlines():
#for lines in open('Plan_Documents14/CHECK_TCGA_GTAC_CATG_073111_UPPER.txt', 'r').xreadlines():
#for lines in open('Plan_Documents16/CHECK_TCGA_GTAC_CATG_073111B_UPPER.txt', 'r').xreadlines():
#for lines in open('Plan_Documents20/CHECK_TCGA_GTAC_CATG_11232011_UPPER.txt', 'r').xreadlines():
#for lines in open('Plan_Documents24/CHECK_TCGA_GTAC_CATG_DEC20012a_UPPER.txt', 'r').xreadlines():
for lines in open('Enzyme.tsv', 'r').xreadlines():
    print lines
    if lines[:6] == 'VECTOR': continue
    if len(lines.strip()) == 0: continue
    myAnimal, mySample, myToCheck = lines.split('\t')[:3]
    myToCheck = myToCheck.strip()
    tcgaCheckDict[mySample] = myToCheck

# SAVE ALL INTO TEMPORARY DIRECTORY
for ix in range(len(tagList)):
    open(os.path.join(tmpDir, 'MID%d.fa' % ix), 'w').write('>MID%d\n%s\n' % (ix, str(tagList[ix]).upper()))
for ix in range(len(aList)):
    open(os.path.join(tmpDir, 'A%d.fa' % ix), 'w').write('>A%d\n%s\n' % (ix, aList[ix]))
for ix in range(len(bList)):
    open(os.path.join(tmpDir, 'B%d.fa' % ix), 'w').write('>B%d\n%s\n' % (ix, bList[ix]))
for ix in range(len(cList)):
    open(os.path.join(tmpDir, 'C%d.fa' % ix), 'w').write('>C%d\n%s\n' % (ix, cList[ix]))
for ix in range(len(dList)):
    open(os.path.join(tmpDir, 'D%d.fa' % ix), 'w').write('>D%d\n%s\n' % (ix, dList[ix]))
for ix in range(len(ddList)):
    open(os.path.join(tmpDir, 'DD%d.fa' % ix), 'w').write('>DD%d\n%s\n' % (ix, ddList[ix]))
for ix in range(len(eList)):
    open(os.path.join(tmpDir, 'E%d.fa' % ix), 'w').write('>E%d\n%s\n' % (ix, eList[ix]))
for ix in range(len(fList)):
    open(os.path.join(tmpDir, 'F%d.fa' % ix), 'w').write('>F%d\n%s\n' % (ix, fList[ix]))
for ix in range(len(ffList)):
    open(os.path.join(tmpDir, 'FF%d.fa' % ix), 'w').write('>FF%d\n%s\n' % (ix, ffList[ix]))
for ix in range(len(gList)):
    open(os.path.join(tmpDir, 'G%d.fa' % ix), 'w').write('>G%d\n%s\n' % (ix, gList[ix]))
for ix in range(len(jhList)):
    open(os.path.join(tmpDir, 'JH%d.fa' % ix), 'w').write('>JH%d\n%s\n' % (ix, jhList[ix]))
for ix in range(len(iList)):
    open(os.path.join(tmpDir, 'I%d.fa' % ix), 'w').write('>I%d\n%s\n' % (ix, iList[ix]))
for ix in range(len(kList)):
    open(os.path.join(tmpDir, 'K%d.fa' % ix), 'w').write('>K%d\n%s\n' % (ix, kList[ix]))
primerASeq = open('Primers_dir/PrimerA.fa', 'r').readlines()[1].strip().upper()
primerBSeq = open('Primers_dir/PrimerB.fa', 'r').readlines()[1].strip().upper()
open(os.path.join(tmpDir, 'PrimerA1.fa'), 'w').write('>%s\n%s\n' % ('PrimerA1', primerASeq.upper()))
open(os.path.join(tmpDir, 'PrimerA2.fa'), 'w').write('>%s\n%s\n' % ('PrimerA2', \
    RC(primerASeq).upper()))
open(os.path.join(tmpDir, 'PrimerB1.fa'), 'w').write('>%s\n%s\n' % ('PrimerB1', primerBSeq.upper()))
open(os.path.join(tmpDir, 'PrimerB2.fa'), 'w').write('>%s\n%s\n' % ('PrimerB2', \
    RC(primerBSeq).upper()))
leftStartSeq = open('Primers_dir/LEFT.fa', 'r').readlines()[1].strip().upper()
rightStartSeq = open('Primers_dir/RIGHT.fa', 'r').readlines()[1].strip().upper()
open(os.path.join(tmpDir, 'LEFT.fa'), 'w').write('>%s\n%s\n' % ('LEFT', leftStartSeq))
open(os.path.join(tmpDir, 'RIGHT.fa'), 'w').write('>%s\n%s\n' % ('RIGHT', rightStartSeq))

# LOAD ALL SEQUENCES INTO MEMORY
seqDict = {}
seqLine, seqHead = '', ''
for lines in open(inputname, 'r').xreadlines():
    lines = lines.upper() # make all sequences upper character
    if lines[0] == '>':
        if len(seqLine):
            if seqDict.has_key(seqHead): print 'dulicate', seqHead
            seqDict[seqHead] = seqLine
            seqLine = ''
        seqHead = lines[1:].strip().upper()
    else:
        seqLine += lines.strip()
seqDict[seqHead] = seqLine
seqList = seqDict.keys()
seqList.sort()

def CheckIdent(filename1, filename2, minIdentity):
    # filename1 : IDENTIFIER SEQUENCE, filename2 : 454 READS
 
    q = '%s -asequence %s -bsequence %s -gapopen 10.0 -gapextend 0.5 -outfile stdout -aformat3 fasta' % \
        (os.path.join(tmpDir, 'water'), filename1, filename2)
    stdout, stdin, stderr = popen2.popen3(q)
    stdin.write('')
    stdin.close()
    matchList = []
    matchHead, matchSeq = '', ''
    for lines in stdout.readlines():
        if lines[0] == '>':
            if len(matchSeq):
                matchList.append((matchHead, matchSeq))
                matchSeq = ''
            matchHead = lines[1:].strip().upper()
        else:
            matchSeq += lines.strip()
    matchList.append((matchHead, matchSeq))
    stdout.close()
    x = stderr.read()
    stderr.close()
    if os.path.getsize(filename1) == 0 or os.path.getsize(filename2) == 0: return -1, 0, ''
    oriSeq = open(filename1, 'r').readlines()[1].strip()
    targetSeq = open(filename2, 'r').readlines()[1].strip()
    if len(matchList) <= 1: return -1, 0, ''
    # IF THERE ARE MULTIPLE HITS,
    # SELECT ONLY LEFT MOST MATCHED REGIONS
    identityList = []
    for ix in range(0, len(matchList), 2):
        if matchList[ix][0][0].isalpha():
            idSeq = matchList[ix][1]
            readSeq = matchList[ix+1][1]
        else:
            idSeq = matchList[ix+1][1]
            readSeq = matchList[ix][1]
        nMatchLength = len([ix for ix in range(len(idSeq)) if idSeq[ix] == readSeq[ix]])
        curIdentity = 100.*float(nMatchLength)/float(len(oriSeq))
        if curIdentity < minIdentity: continue
        identityList.append((targetSeq.index(readSeq.replace('-', '')), curIdentity, readSeq.replace('-', '')))
    #print oriSeq, targetSeq, identityList
    #raw_input('Press Enter Key')
    if len(identityList) == 0: return -1, 0, ''
    maxIdentity = max([iy for ix, iy, iz in identityList])
    if maxIdentity < minIdentity: return -1, 0, ''
    maxIdentityList = [ix for ix in range(len(identityList)) if identityList[ix][1] == maxIdentity]
    #print identityList[maxIdentityList[0]]
    #raw_input('Press Enter Key')
    return identityList[maxIdentityList[0]]

nTagSize = 10 # was 4
nTagACutoff = 16 #2 TAG now 10bp

# RANG OF MOTIF A RECOGNITION REGION, TAG IS 10 BP
nTagAMinCutoff = nTagSize - 4 #9
nTagAMaxCutoff = nTagSize + 8 #27

nTagBMinCutoff = 8 #9
nTagBMaxCutoff = 35 #27
nLinkerCutoff = -1 # THIS SHOULD BE MODIFIED. LINKER LENGTH CAN BE CHANGED.
nVectorMinCutoff = 11 #9 # modified. 2010.10.25.
nVectorMaxCutoff = 145 #95 #65
# February 7, 2013. Max Vector area extended to 145
pMinIdentity = 90.0
pMinIdentity2 = 85.0
pMinIdentity3 = 98.0

for iSeq in range(len(seqList)):
    if iSeq % 8 != int(runId): continue
    seqId = seqList[iSeq]
    # INDICES, IDENTITY, START/END
    tagIndex, tagIdentity, tagStart, tagEnd = -1, 0, -1, -1
    aIndex, aIdentity, aStart, aEnd = -1, 0, -1, -1
    bIndex, bIdentity, bStart, bEnd = -1, 0, -1, -1
    cIndex, cIdentity, cStart, cEnd = -1, 0, -1, -1
    dIndex, dIdentity, dStart, dEnd = -1, 0, -1, -1
    ddIndex, ddIdentity, ddStart, ddEnd = -1, 0, -1, -1
    eIndex, eIdentity, eStart, eEnd = -1, 0, -1, -1
    fIndex, fIdentity, fStart, fEnd = -1, 0, -1, -1
    ffIndex, ffIdentity, ffStart, ffEnd = -1, 0, -1, -1
    gIndex, gIdentity, gStart, gEnd = -1, 0, -1, -1
    jhIndex, jhIdentity, jhStart, jhEnd = -1, 0, -1, -1
    iIndex, iIdentity, iStart, iEnd = -1, 0, -1, -1
    kIndex, kIdentity, kStart, kEnd = -1, 0, -1, -1
    # CALCULATION STARTS HERE
    mySeq = seqDict[seqId].upper()

    # CHECK & REMOVE 454 PRIMERS (A & B)
    open(os.path.join(tmpDir, seqId + '.fa'), 'w').write('>' + seqId + '\n' + mySeq + '\n')
    pIndex1, pIdentity1, pSeq1, pIndex2, pIdentity2, pSeq2 = -1, 0, '', -1, 0, ''
    pIndex1rc, pIdentity1rc, pSeq1rc, pIndex2rc, pIdentity2rc, pSeq2rc = -1, 0, '', -1, 0, ''
    pIndexList = []
    if primerASeq in mySeq:
        pIndex1, pIdentity1, pSeq1 = mySeq.rfind(primerASeq), 100., ''
    else:
        pIndex1, pIdentity1, pSeq1 = \
            CheckIdent(os.path.join(tmpDir, 'PrimerA1.fa'), os.path.join(tmpDir, seqId + '.fa'), pMinIdentity)
    if pIndex1 >= 0:
        print >> sys.stderr, seqId, pIndex1, 'PrimerA found by water...'
        pIndexList.append(pIndex1)
    if primerBSeq in mySeq:
        pIndex2, pIdentity2, pSeq2 = mySeq.rfind(primerBSeq), 100., ''
    else:
        pIndex2, pIdentity2, pSeq2 = \
            CheckIdent(os.path.join(tmpDir, 'PrimerB1.fa'), os.path.join(tmpDir, seqId + '.fa'), pMinIdentity)
    if pIndex2 >= 0:
        print >> sys.stderr, seqId, pIndex2, 'PrimerB found by water...'
        pIndexList.append(pIndex2)
    if RC(primerASeq) in mySeq:
        pIndex1rc, pIdentity1rc, pSeq1rc = mySeq.rfind(RC(primerASeq)), 100., ''
    else:
        pIndex1rc, pIdentity1rc, pSeq1rc = \
            CheckIdent(os.path.join(tmpDir, 'PrimerA2.fa'), os.path.join(tmpDir, seqId + '.fa'), pMinIdentity)
    if pIndex1rc >= 0:
        print >> sys.stderr, seqId, pIndex1rc, 'PrimerA RC found by water...'
        pIndexList.append(pIndex1rc)
    if RC(primerBSeq) in mySeq:
        pIndex2rc, pIdentity2rc, pSeq2rc = mySeq.rfind(RC(primerBSeq)), 100., ''
    else:
        pIndex2rc, pIdentity2rc, pSeq2rc = \
            CheckIdent(os.path.join(tmpDir, 'PrimerB2.fa'), os.path.join(tmpDir, seqId + '.fa'), pMinIdentity)
    if pIndex2rc >= 0:
        print >> sys.stderr, seqId, pIndex2rc, 'PrimerB RC found by water...'
        pIndexList.append(pIndex2rc)
    if len(pIndexList):
        mySeq = mySeq[:min(pIndexList)]
        os.remove(os.path.join(tmpDir, seqId + '.fa'))
        open(os.path.join(tmpDir, seqId + '.fa'), 'w').write('>' + seqId + '\n' + mySeq + '\n')
    # DEBUGGING MAY 29, 2009. DONE BY NAMSHIN KIM. N@RNA.KR
    #nLinkerCutoff = max(0, len(mySeq) - nVectorMinCutoff)
    # DEBUGGING OCTOBER 27, 2010. DO BY NAMSHIN KIM. N@RNA.KR
    nLinkerCutoff = max(1, len(mySeq) - nVectorMinCutoff)
    #if pIndex1 < 0 and pIndex2 < 0: continue
    #print pIndex1, pIdentity1, pSeq1, pIndex2, pIdentity2, pSeq2
    #raw_input('Press Enter Key')
    #continue

    # SAVE CUT SEQUENCES
    open(os.path.join(tmpDir, seqId + '_TA.fa'), 'w').write('>' + seqId + '\n' + \
        mySeq[nTagAMinCutoff:nTagAMaxCutoff] + '\n')
    open(os.path.join(tmpDir, seqId + '_B.fa'), 'w').write('>' + seqId + '\n' + \
        mySeq[nTagBMinCutoff:nTagBMaxCutoff] + '\n')
    open(os.path.join(tmpDir, seqId + '_VC.fa'), 'w').write('>' + seqId + '\n' + \
        mySeq[nVectorMinCutoff:nVectorMaxCutoff] + '\n')
    open(os.path.join(tmpDir, seqId + '_LK.fa'), 'w').write('>' + seqId + '\n' + mySeq[-nLinkerCutoff:] + '\n')
    tagSeq = mySeq[:nTagSize] # SEQUENCE QUALITY SHOULD BE VERY HIGH AT FRONT OF ALL READS
    #tagList2=[x.upper() for x in tagList]
    if tagSeq in tagList:
        #print('I am here')
        tagIndex = tagList.index(tagSeq)
        # CHECK A/B. FIRST BY INDEX AND SECOND BY WATER
        for iA in tagdict[tagIndex]['A']: #range(len(aList)):
            if aList[iA] in mySeq[nTagAMinCutoff:nTagAMaxCutoff]:
                aIndex = iA
               
        if aIndex < 0:
            sFileList = [os.path.join(tmpDir, 'A%d.fa' % iA) for iA in tagdict[tagIndex]['A']]
          
            #glob.glob(os.path.join(tmpDir, 'A[0-9].fa'))
            #sFileList.sort()
            sMapList = []
            for sIndex, sFileName in zip(tagdict[tagIndex]['A'], sFileList): #range(len(sFileList)):
                #sFileName = sFileList[sIndex]
                xIndex, xIdentity, xSeq = \
                    CheckIdent(sFileName, os.path.join(tmpDir, seqId + '_TA.fa'), pMinIdentity)
                if xIndex < 0: continue
                sMapList.append((xIdentity, sIndex, xIndex, xSeq))
            if len(sMapList):
                sMapList.sort()
                sMapList.reverse()
                xIdentity, sIndex, xIndex, xSeq = sMapList[0]
                aIndex = sIndex
                aStart, aEnd = nTagAMinCutoff + xIndex, nTagAMinCutoff + xIndex + len(xSeq)
                aIdentity = xIdentity
        else:
            aStart = nTagAMinCutoff + mySeq[nTagAMinCutoff:nTagAMaxCutoff].index(aList[aIndex])
            aEnd = aStart + len(aList[aIndex])
            aIdentity = 100.
        for iB in tagdict[tagIndex]['B']: #range(len(bList)):
            if bList[iB] in mySeq[nTagBMinCutoff:nTagBMaxCutoff]:
                bIndex = iB
        if bIndex < 0:
            sFileList = [os.path.join(tmpDir, 'B%d.fa' % iB) for iB in tagdict[tagIndex]['B']]
            #glob.glob(os.path.join(tmpDir, 'B[0-9].fa'))
            #sFileList.sort()
            sMapList = []
            for sIndex, sFileName in zip(tagdict[tagIndex]['B'], sFileList): #range(len(sFileList)):
                #sFileName = sFileList[sIndex]
                xIndex, xIdentity, xSeq = \
                    CheckIdent(sFileName, os.path.join(tmpDir, seqId + '_B.fa'), pMinIdentity)
                if xIndex < 0: continue
                sMapList.append((xIdentity, sIndex, xIndex, xSeq))
            if len(sMapList):
                sMapList.sort()
                sMapList.reverse()
                xIdentity, sIndex, xIndex, xSeq = sMapList[0]
                bIndex = sIndex
                bStart, bEnd = nTagBMinCutoff + xIndex, nTagBMinCutoff + xIndex + len(xSeq)
                bIdentity = xIdentity
        else:
            bStart = nTagBMinCutoff + mySeq[nTagBMinCutoff:nTagBMaxCutoff].index(bList[bIndex])
            bEnd = bStart + len(bList[bIndex])
            bIdentity = 100.
        #if aIdentity > 0 and bIdentity > 0 and aStart > bStart:
        #    aIndex, aIdentity, aStart, aEnd = -1, 0, -1, -1
        # CHECK C, D, DD, E, F, FF. FIRST BY INDEX AND SECOND BY WATER
        for iC in tagdict[tagIndex]['C']: #range(len(cList)):
            if cList[iC] in mySeq[nVectorMinCutoff:nVectorMaxCutoff]:
                cIndex = iC
        if cIndex < 0:
            sFileList = [os.path.join(tmpDir, 'C%d.fa' % iC) for iC in tagdict[tagIndex]['C']]
            #glob.glob(os.path.join(tmpDir, 'C[0-9].fa'))
            #sFileList.sort()
            sMapList = []
            for sIndex, sFileName in zip(tagdict[tagIndex]['C'], sFileList): #range(len(sFileList)):
                #sFileName = sFileList[sIndex]
                xIndex, xIdentity, xSeq = \
                    CheckIdent(sFileName, os.path.join(tmpDir, seqId + '_VC.fa'), pMinIdentity)
                if xIndex < 0: continue
                sMapList.append((xIdentity, sIndex, xIndex, xSeq))
            if len(sMapList):
                sMapList.sort()
                sMapList.reverse()
                xIdentity, sIndex, xIndex, xSeq = sMapList[0]
                cIndex = sIndex
                cStart, cEnd = nVectorMinCutoff + xIndex, nVectorMinCutoff + xIndex + len(xSeq)
                cIdentity = xIdentity
        else:
            cStart = nVectorMinCutoff + mySeq[nVectorMinCutoff:nVectorMaxCutoff].index(cList[cIndex])
            cEnd = cStart + len(cList[cIndex])
            cIdentity = 100.
        #if bIdentity > 0 and cIdentity > 0 and bStart > cStart:
        #    bIndex, bIdentity, bStart, bEnd = -1, 0, -1, -1
        #if aIdentity > 0 and cIdentity > 0 and aStart > cStart and bIndex < 0:
        #    aIndex, aIdentity, aStart, aEnd = -1, 0, -1, -1
        # TAG, A, B HAVE BEEN DETERMINED
        if sampleIdDict.has_key((tagIndex, aIndex, bIndex)):
            sampleId = sampleIdDict[(tagIndex, aIndex, bIndex)]
            myJunction = junctionDict[sampleId][0]
        else:
            sampleId = ''
            myJunction = ''
        if len(sampleId): currIndex = dList.index(motifDict[sampleId]['D'])
        else: currIndex = -1
        for iD in tagdict[tagIndex]['D']: #range(len(dList)):
            if iD != currIndex: continue
            if dList[iD] in mySeq[nVectorMinCutoff:nVectorMaxCutoff]:
                dIndex = iD
        if dIndex < 0:
            sFileList = [os.path.join(tmpDir, 'D%d.fa' % iD) for iD in tagdict[tagIndex]['D']]
            #glob.glob(os.path.join(tmpDir, 'D[0-9].fa'))
            #sFileList.sort()

            if len(sampleId):
                #currIndex = dList.index(motifDict[sampleId]['D'])
                sFileList = [os.path.join(tmpDir, 'D%d.fa' % iD) for iD in tagdict[tagIndex]['D']]
                #[os.path.join(tmpDir, 'D%d.fa' % currIndex)]

            sMapList = []
            for sIndex, sFileName in zip(tagdict[tagIndex]['D'], sFileList): #range(len(sFileList)):
                #sFileName = sFileList[sIndex]
                xIndex, xIdentity, xSeq = \
                    CheckIdent(sFileName, os.path.join(tmpDir, seqId + '_VC.fa'), pMinIdentity)
                if xIndex < 0: continue
                sMapList.append((xIdentity, sIndex, xIndex, xSeq))
            if len(sMapList):
                sMapList.sort()
                sMapList.reverse()
                xIdentity, sIndex, xIndex, xSeq = sMapList[0]
                dIndex = sIndex
                dStart, dEnd = nVectorMinCutoff + xIndex, nVectorMinCutoff + xIndex + len(xSeq)
                dIdentity = xIdentity
        else:
            dStart = nVectorMinCutoff + mySeq[nVectorMinCutoff:nVectorMaxCutoff].index(dList[dIndex])
            dEnd = dStart + len(dList[dIndex])
            dIdentity = 100.
        #if cIdentity > 0 and dIdentity > 0 and cStart > dStart:
        #    print 'DELETED', sampleId, 'C<->D', cStart, dStart
        #    cIndex, cIdentity, cStart, cEnd = -1, 0, -1, -1
        #if bIdentity > 0 and dIdentity > 0 and bStart > dStart and cIndex < 0:
        #    print 'DELETED', sampleId, 'B<->D', bStart, dStart
        #    bIndex, bIdentity, bStart, bEnd = -1, 0, -1, -1
        #if aIdentity > 0 and dIdentity > 0 and aStart > dStart and bIndex < 0 and cIndex < 0:
        #    print 'DELETED', sampleId, 'A<->D', aStart, dStart
        #    aIndex, aIdentity, aStart, aEnd = -1, 0, -1, -1
        if len(sampleId): currIndex = ddList.index(motifDict[sampleId]['DD'])
        else: currIndex = -1
        for iDD in tagdict[tagIndex]['DD']: #range(len(ddList)):
            if iDD != currIndex: continue
            if ddList[iDD] in mySeq[nVectorMinCutoff:nVectorMaxCutoff]:
                ddIndex = iDD
        if ddIndex < 0:
            sFileList = [os.path.join(tmpDir, 'DD%d.fa' % iDD) for iDD in tagdict[tagIndex]['DD']]
            #glob.glob(os.path.join(tmpDir, 'DD[0-9].fa'))
            #sFileList.sort()

            if len(sampleId):
                #currIndex = ddList.index(motifDict[sampleId]['DD'])
                sFileList = [os.path.join(tmpDir, 'DD%d.fa' % iDD) for iDD in tagdict[tagIndex]['DD']]
                #[os.path.join(tmpDir, 'DD%d.fa' % currIndex)]

            sMapList = []
            for sIndex, sFileName in zip(tagdict[tagIndex]['DD'], sFileList): #in range(len(sFileList)):
                #sFileName = sFileList[sIndex]
                xIndex, xIdentity, xSeq = \
                    CheckIdent(sFileName, os.path.join(tmpDir, seqId + '_VC.fa'), pMinIdentity)
                if xIndex < 0: continue
                sMapList.append((xIdentity, sIndex, xIndex, xSeq))
            if len(sMapList):
                sMapList.sort()
                sMapList.reverse()
                xIdentity, sIndex, xIndex, xSeq = sMapList[0]
                ddIndex = sIndex
                ddStart, ddEnd = nVectorMinCutoff + xIndex, nVectorMinCutoff + xIndex + len(xSeq)
                ddIdentity = xIdentity
        else:
            ddStart = nVectorMinCutoff + mySeq[nVectorMinCutoff:nVectorMaxCutoff].index(ddList[ddIndex])
            ddEnd = ddStart + len(ddList[ddIndex])
            ddIdentity = 100.
        #if dIdentity > 0 and ddIdentity > 0 and dStart > ddStart:
        #    print 'DELETED', sampleId, 'D<->DD', dStart, ddStart
        #    dIndex, dIdentity, dStart, dEnd = -1, 0, -1, -1
        #if cIdentity > 0 and ddIdentity > 0 and cStart > ddStart and dIndex < 0:
        #    print 'DELETED', sampleId, 'C<->DD', cStart, ddStart
        #    cIndex, cIdentity, cStart, cEnd = -1, 0, -1, -1
        #if bIdentity > 0 and ddIdentity > 0 and bStart > ddStart and cIndex < 0 and dIndex < 0:
        #    print 'DELETED', sampleId, 'B<->DD', bStart, ddStart
        #    bIndex, bIdentity, bStart, bEnd = -1, 0, -1, -1
        #if aIdentity > 0 and ddIdentity > 0 and aStart > ddStart and bIndex < 0 and cIndex < 0 and dIndex < 0:
        #    print 'DELETED', sampleId, 'A<->DD', aStart, ddStart
        #    aIndex, aIdentity, aStart, aEnd = -1, 0, -1, -1
        if len(sampleId): currIndex = ffList.index(motifDict[sampleId]['FF'])
        else: currIndex = -1
        for iFF in tagdict[tagIndex]['FF']: #range(len(ffList)):
            if iFF != currIndex: continue
            if ffList[iFF] in mySeq[nVectorMinCutoff:nVectorMaxCutoff]:
                ffIndex = iFF
        if ffIndex < 0:
            sFileList = [os.path.join(tmpDir, 'FF%d.fa' % iFF) for iFF in tagdict[tagIndex]['FF']]
            #glob.glob(os.path.join(tmpDir, 'FF[0-9].fa'))
            #sFileList.sort()

            if len(sampleId):
                #currIndex = ffList.index(motifDict[sampleId]['FF'])
                sFileList = [os.path.join(tmpDir, 'FF%d.fa' % iFF) for iFF in tagdict[tagIndex]['FF']]
                #[os.path.join(tmpDir, 'FF%d.fa' % currIndex)]

            sMapList = []
            for sIndex, sFileName in zip(tagdict[tagIndex]['FF'], sFileList): #range(len(sFileList)):
                #sFileName = sFileList[sIndex]
                xIndex, xIdentity, xSeq = \
                    CheckIdent(sFileName, os.path.join(tmpDir, seqId + '_VC.fa'), pMinIdentity)
                if xIndex < 0: continue
                sMapList.append((xIdentity, sIndex, xIndex, xSeq))
            if len(sMapList):
                sMapList.sort()
                sMapList.reverse()
                xIdentity, sIndex, xIndex, xSeq = sMapList[0]
                ffIndex = sIndex
                ffStart, ffEnd = nVectorMinCutoff + xIndex, nVectorMinCutoff + xIndex + len(xSeq)
                ffIdentity = xIdentity
        else:
            ffStart = nVectorMinCutoff + mySeq[nVectorMinCutoff:nVectorMaxCutoff].index(ffList[ffIndex])
            ffEnd = ffStart + len(ffList[ffIndex])
            ffIdentity = 100.
        #if myJunction == 'LEFT': # DD COMES FIRST
        #    if ddIdentity > 0 and ffIdentity > 0 and ddStart > ffStart: # DD INVALID
        #        print 'DELETED', sampleId, 'LEFT DD<->FF', ddStart, ffStart
        #        ddIndex, ddIdentity, ddStart, ddEnd = -1, 0, -1, -1
        #if myJunction == 'RIGHT': # FF COMES FIRST
        #    if ddIdentity > 0 and ffIdentity > 0 and ffStart > ddStart: # FF INVALID
        #        print 'DELETED', sampleId, 'RIGHT FF<->DD', ffStart, ddStart
        #        ffIndex, ffIdentity, ffStart, ffEnd = -1, 0, -1, -1
        #if dIdentity > 0 and ffIdentity > 0 and dStart > ffStart and ddIndex < 0:
        #    print 'DELETED', sampleId, 'D<->FF', dStart, ffStart
        #    dIndex, dIdentity, dStart, dEnd = -1, 0, -1, -1
        #if cIdentity > 0 and ffIdentity > 0 and cStart > ffStart and dIndex < 0 and ddIndex < 0:
        #    print 'DELETED', sampleId, 'C<->FF', cStart, ffStart
        #    cIndex, cIdentity, cStart, cEnd = -1, 0, -1, -1
        #if dIdentity > 0 and ffIdentity > 0 and bStart > ffStart and cIndex < 0 and dIndex < 0 and ddIndex < 0:
        #    print 'DELETED', sampleId, 'B<->FF', bStart, ffStart
        #    bIndex, bIdentity, bStart, bEnd = -1, 0, -1, -1
        #if aIdentity > 0 and ffIdentity > 0 and aStart > ffStart and bIndex < 0 and cIndex < 0 and dIndex < 0 \
        #    and ddIndex < 0:
        #    print 'DELETED', sampleId, 'A<->FF', aStart, ffStart
        #    aIndex, aIdentity, aStart, aEnd = -1, 0, -1, -1
        if len(sampleId): currIndex = fList.index(motifDict[sampleId]['F'])
        else: currIndex = -1
        for iF in tagdict[tagIndex]['F']: #range(len(fList)):
            if iF != currIndex: continue
            if fList[iF] in mySeq[nVectorMinCutoff:nVectorMaxCutoff]:
                fIndex = iF
        if fIndex < 0:
            sFileList = [os.path.join(tmpDir, 'F%d.fa' % iF) for iF in tagdict[tagIndex]['F']]
            #glob.glob(os.path.join(tmpDir, 'F[0-9].fa'))
            #sFileList.sort()

            if len(sampleId):
                #currIndex = fList.index(motifDict[sampleId]['F'])
                sFileList = [os.path.join(tmpDir, 'F%d.fa' % iF) for iF in tagdict[tagIndex]['F']]
                #[os.path.join(tmpDir, 'F%d.fa' % currIndex)]

            sMapList = []
            for sIndex, sFileName in zip(tagdict[tagIndex]['F'], sFileList): #range(len(sFileList)):
                #sFileName = sFileList[sIndex]
                xIndex, xIdentity, xSeq = \
                    CheckIdent(sFileName, os.path.join(tmpDir, seqId + '_VC.fa'), pMinIdentity)
                if xIndex < 0: continue
                sMapList.append((xIdentity, sIndex, xIndex, xSeq))
            if len(sMapList):
                sMapList.sort()
                sMapList.reverse()
                xIdentity, sIndex, xIndex, xSeq = sMapList[0]
                fIndex = sIndex
                fStart, fEnd = nVectorMinCutoff + xIndex, nVectorMinCutoff + xIndex + len(xSeq)
                fIdentity = xIdentity
        else:
            fStart = nVectorMinCutoff + mySeq[nVectorMinCutoff:nVectorMaxCutoff].index(fList[fIndex])
            fEnd = fStart + len(fList[fIndex])
            fIdentity = 100.
        #if ffIdentity > 0 and fIdentity > 0 and ffStart > fStart:
        #    print 'DELETED', sampleId, 'FF<->F', ffStart, fStart
        #    ffIndex, ffIdentity, ffStart, ffEnd = -1, 0, -1, -1
        #if ddIdentity > 0 and fIdentity > 0 and ddStart > fStart and ffIndex < 0:
        #    print 'DELETED', sampleId, 'DD<->F', ddStart, fStart
        #    ddIndex, ddIdentity, ddStart, ddEnd = -1, 0, -1, -1
        #if dIdentity > 0 and fIdentity > 0 and dStart > fStart and ddIndex < 0 and ffIndex < 0:
        #    print 'DELETED', sampleId, 'D<->F', dStart, fStart
        #    dIndex, dIdentity, dStart, dEnd = -1, 0, -1, -1
        #if cIdentity > 0 and fIdentity > 0 and cStart > fStart and dIndex < 0 and ddIndex < 0 and ffIndex < 0:
        #    print 'DELETED', sampleId, 'C<->F', cStart, fStart
        #    cIndex, cIdentity, cStart, cEnd = -1, 0, -1, -1
        #if bIdentity > 0 and fIdentity > 0 and bStart > fStart and cIndex < 0 and dIndex < 0 and ddIndex < 0 \
        #    and ffIndex < 0:
        #    print 'DELETED', sampleId, 'B<->F', bStart, fStart
        #    bIndex, bIdentity, bStart, bEnd = -1, 0, -1, -1
        #if aIdentity > 0 and fIdentity > 0 and aStart > fStart and bIndex < 0 and cIndex < 0 and dIndex < 0 \
        #    and ddIndex < 0 and ffIndex < 0:
        #    print 'DELETED', sampleId, 'A<->F', aStart, fStart
        #    aIndex, aIdentity, aStart, aEnd = -1, 0, -1, -1
        if len(sampleId): currIndex = eList.index(motifDict[sampleId]['E'])
        else: currIndex = -1
        for iE in tagdict[tagIndex]['E']: #range(len(eList)):
            if iE != currIndex: continue
            if eList[iE] in mySeq[nVectorMinCutoff:nVectorMaxCutoff]:
                eIndex = iE
        if eIndex < 0:
            sFileList = [os.path.join(tmpDir, 'E%d.fa' % iE) for iE in tagdict[tagIndex]['E']]
            #glob.glob(os.path.join(tmpDir, 'E[0-9].fa'))
            #sFileList.sort()

            if len(sampleId):
                #currIndex = eList.index(motifDict[sampleId]['E'])
                sFileList = [os.path.join(tmpDir, 'E%d.fa' % iE) for iE in tagdict[tagIndex]['E']]
                #[os.path.join(tmpDir, 'E%d.fa' % currIndex)]

            sMapList = []
            for sIndex, sFileName in zip(tagdict[tagIndex]['E'], sFileList): #range(len(sFileList)):
                #sFileName = sFileList[sIndex]
                xIndex, xIdentity, xSeq = \
                    CheckIdent(sFileName, os.path.join(tmpDir, seqId + '_VC.fa'), pMinIdentity3)
                # January 28, 2013. pMinIdentity3 = 95.0 used instead of pMinIdentity 90.0%
                # February 7, 2013. pMinIdentity3 = 98.0 instead of 95.0%
                if xIndex < 0: continue
                sMapList.append((xIdentity, sIndex, xIndex, xSeq))
            if len(sMapList):
                sMapList.sort()
                sMapList.reverse()
                xIdentity, sIndex, xIndex, xSeq = sMapList[0]
                eIndex = sIndex
                eStart, eEnd = nVectorMinCutoff + xIndex, nVectorMinCutoff + xIndex + len(xSeq)
                eIdentity = xIdentity
        else:
            eStart = nVectorMinCutoff + mySeq[nVectorMinCutoff:nVectorMaxCutoff].index(eList[eIndex])
            eEnd = eStart + len(eList[eIndex])
            eIdentity = 100.
        # RESET JH BEFORE IT CAUSES PROBLEMS
        #eCheckList = [aStart, bStart, cStart, dStart, ddStart, ffStart, fStart]
        #if eCheckList.count(-1) <= 4:
        #    if eStart < max(eCheckList):
        #        print 'DELETED', sampleId, 'ECHCECK', eCheckList
        #        eIndex, eIdentity, eStart, eEnd = -1, 0, -1, -1
        #if fIdentity > 0 and eIdentity > 0 and fStart > eStart:
        #    print 'DELETED', sampleId, 'F<->E', fStart, eStart
        #    fIndex, fIdentity, fStart, fEnd = -1, 0, -1, -1
        #if ffIdentity > 0 and eIdentity > 0 and ffStart > eStart and fIndex < 0:
        #    print 'DELETED', sampleId, 'FF<->E', ffStart, eStart
        #    ffIndex, ffIdentity, ffStart, ffEnd = -1, 0, -1, -1
        #if ddIdentity > 0 and eIdentity > 0 and ddStart > eStart and ffIndex < 0 and fIndex < 0:
        #    print 'DELETED', sampleId, 'DD<->E', ddStart, eStart
        #    ddIndex, ddIdentity, ddStart, ddEnd = -1, 0, -1, -1
        #if dIdentity > 0 and eIdentity > 0 and dStart > eStart and ddIndex < 0 and ffIndex < 0 and fIndex < 0:
        #    print 'DELETED', sampleId, 'D<->E', dStart, eStart
        #    dIndex, dIdentity, dStart, dEnd = -1, 0, -1, -1
        #if cIdentity > 0 and eIdentity > 0 and cStart > eStart and dIndex < 0 and ddIndex < 0 and ffIndex < 0 \
        #    and fIndex < 0:
        #    print 'DELETED', sampleId, 'C<->E', cStart, eStart
        #    cIndex, cIdentity, cStart, cEnd = -1, 0, -1, -1
        #if bIdentity > 0 and eIdentity > 0 and bStart > eStart and cIndex < 0 and dIndex < 0 and ddIndex < 0 \
        #    and ffIndex < 0 and fIndex < 0:
        #    print 'DELETED', sampleId, 'B<->E', bStart, eStart
        #    bIndex, bIdentity, bStart, bEnd = -1, 0, -1, -1
        #if aIdentity > 0 and eIdentity > 0 and aStart > eStart and bIndex < 0 and cIndex < 0 and dIndex < 0 \
        #    and ddIndex < 0 and ffIndex < 0 and fIndex < 0:
        #    print 'DELETED', sampleId, 'A<->E', aStart, eStart
        #    aIndex, aIdentity, aStart, aEnd = -1, 0, -1, -1
        # CHECK JH, I. FIRST BY INDEX AND SECOND BY WATER
        if len(sampleId): currIndex = jhList.index(motifDict[sampleId]['JH'])
        else: currIndex = -1
        for iJH in tagdict[tagIndex]['JH']: #range(len(jhList)):
            if iJH != currIndex: continue
            if jhList[iJH] in mySeq[-nLinkerCutoff:]:
                jhIndex = iJH
        if jhIndex < 0:
            sFileList = [os.path.join(tmpDir, 'JH%d.fa' % iJH) for iJH in tagdict[tagIndex]['JH']]
            #glob.glob(os.path.join(tmpDir, 'JH[0-9].fa'))
            #sFileList.sort()

            if len(sampleId):
                #currIndex = jhList.index(motifDict[sampleId]['JH'])
                sFileList = [os.path.join(tmpDir, 'JH%d.fa' % iJH) for iJH in tagdict[tagIndex]['JH']]
                #[os.path.join(tmpDir, 'JH%d.fa' % currIndex)]

            sMapList = []
            for sIndex, sFileName in zip(tagdict[tagIndex]['JH'], sFileList): #range(len(sFileList)):
                #sFileName = sFileList[sIndex]
                xIndex, xIdentity, xSeq = \
                    CheckIdent(sFileName, os.path.join(tmpDir, seqId + '_LK.fa'), pMinIdentity2)
                if xIndex < 0: continue
                sMapList.append((xIdentity, sIndex, xIndex, xSeq))
            if len(sMapList):
                sMapList.sort()
                sMapList.reverse()
                xIdentity, sIndex, xIndex, xSeq = sMapList[0]
                jhIndex = sIndex
                jhStart, jhEnd = len(mySeq)-nLinkerCutoff + xIndex, len(mySeq)-nLinkerCutoff + xIndex + len(xSeq)
                jhIdentity = xIdentity
        else:
            jhStart = len(mySeq) - nLinkerCutoff + mySeq[-nLinkerCutoff:].index(jhList[jhIndex])
            jhEnd = jhStart + len(jhList[jhIndex])
            jhIdentity = 100.
        # RESET JH BEFORE IT CAUSES PROBLEMS
        #jhCheckList = [aStart, bStart, cStart, dStart, ddStart, ffStart, fStart, eStart]
        #if jhCheckList.count(-1) <= 4:
        #    if jhStart < max(jhCheckList):
        #        print 'DELETED', sampleId, 'JHCHECK', jhCheckList
        #        jhIndex, jhIdentity, jhStart, jhEnd = -1, 0, -1, -1
        #if eIdentity > 0 and jhIdentity > 0 and eStart > jhStart:
        #    print 'DELETED', sampleId, 'E<->JH', eStart, jhStart
        #    eIndex, eIdentity, eStart, eEnd = -1, 0, -1, -1
        #if fIdentity > 0 and jhIdentity > 0 and fStart > jhStart and eIndex < 0:
        #    print 'DELETED', sampleId, 'F<->JH', fStart, jhStart
        #    fIndex, fIdentity, fStart, fEnd = -1, 0, -1, -1
        #if ffIdentity > 0 and jhIdentity > 0 and ffStart > jhStart and fIndex < 0 and eIndex < 0:
        #    print 'DELETED', sampleId, 'FF<->JH', ffStart, jhStart
        #    ffIndex, ffIdentity, ffStart, ffEnd = -1, 0, -1, -1
        #if ddIdentity > 0 and jhIdentity > 0 and ddStart > jhStart and ffIndex < 0 and fIndex < 0 and eIndex < 0:
        #    print 'DELETED', sampleId, 'DD<->JH', ddStart, jhStart
        #    ddIndex, ddIdentity, ddStart, ddEnd = -1, 0, -1, -1
        #if dIdentity > 0 and jhIdentity > 0 and dStart > jhStart and ddIndex < 0 and ffIndex < 0 and fIndex < 0 \
        #    and eIndex < 0:
        #    print 'DELETED', sampleId, 'D<->JH', dStart, jhStart
        #    dIndex, dIdentity, dStart, dEnd = -1, 0, -1, -1
        #if cIdentity > 0 and jhIdentity > 0 and cStart > jhStart and dIndex < 0 and ddIndex < 0 and ffIndex < 0 \
        #    and fIndex < 0 and eIndex < 0:
        #    print 'DELETED', sampleId, 'C<->JH', cStart, jhStart
        #    cIndex, cIdentity, cStart, cEnd = -1, 0, -1, -1
        #if bIdentity > 0 and jhIdentity > 0 and bStart > jhStart and cIndex < 0 and dIndex < 0 and ddIndex < 0 \
        #    and ffIndex < 0 and fIndex < 0 and eIndex < 0:
        #    print 'DELETED', sampleId, 'B<->JH', bStart, jhStart
        #    bIndex, bIdentity, bStart, bEnd = -1, 0, -1, -1
        #if aIdentity > 0 and jhIdentity > 0 and aStart > jhStart and bIndex < 0 and cIndex < 0 and dIndex < 0 \
        #    and ddIndex < 0 and ffIndex < 0 and fIndex < 0 and eIndex < 0:
        #    print 'DELETED', sampleId, 'A<->JH', aStart, jhStart
        #    aIndex, aIdentity, aStart, aEnd = -1, 0, -1, -1
        if len(sampleId): currIndex = iList.index(motifDict[sampleId]['I'])
        else: currIndex = -1
        for iI in tagdict[tagIndex]['I']: #range(len(iList)):
            if iI != currIndex: continue
            if iList[iI] in mySeq[-nLinkerCutoff:]:
                iIndex = iI
        if iIndex < 0:
            sFileList = [os.path.join(tmpDir, 'I%d.fa' % iI) for iI in tagdict[tagIndex]['I']]
            #glob.glob(os.path.join(tmpDir, 'I[0-9].fa'))
            #sFileList.sort()

            if len(sampleId):
                #currIndex = iList.index(motifDict[sampleId]['I'])
                sFileList = [os.path.join(tmpDir, 'I%d.fa' % iI) for iI in tagdict[tagIndex]['I']]
                #[os.path.join(tmpDir, 'I%d.fa' % currIndex)]

            sMapList = []
            for sIndex, sFileName in zip(tagdict[tagIndex]['I'], sFileList): #in range(len(sFileList)):
                #sFileName = sFileList[sIndex]
                xIndex, xIdentity, xSeq = \
                    CheckIdent(sFileName, os.path.join(tmpDir, seqId + '_LK.fa'), pMinIdentity + 3.)
                if xIndex < 0: continue
                sMapList.append((xIdentity, sIndex, xIndex, xSeq))
            if len(sMapList):
                sMapList.sort()
                sMapList.reverse()
                xIdentity, sIndex, xIndex, xSeq = sMapList[0]
                iIndex = sIndex
                iStart, iEnd = len(mySeq)-nLinkerCutoff + xIndex, len(mySeq)-nLinkerCutoff + xIndex + len(xSeq)
                iIdentity = xIdentity
        else:
            iStart = len(mySeq) - nLinkerCutoff + mySeq[-nLinkerCutoff:].index(iList[iIndex])
            iEnd = iStart + len(iList[iIndex])
            iIdentity = 100.
        # RESET I BEFORE IT CAUSES PROBLEMS
        #iCheckList = [aStart, bStart, cStart, dStart, ddStart, ffStart, fStart, eStart, jhStart]
        #if iCheckList.count(-1) <= 5:
        #    if iStart < max(iCheckList):
        #        print 'DELETED', sampleId, 'ICHECK', iCheckList
        #        iIndex, iIdentity, iStart, iEnd = -1, 0, -1, -1
        #if jhIdentity > 0 and iIdentity > 0 and jhStart > iStart:
        #    print 'DELETED', sampleId, 'JH<->I', jhStart, iStart
        #    jhIndex, jhIdentity, jhStart, jhEnd = -1, 0, -1, -1
        #if eIdentity > 0 and iIdentity > 0 and eStart > iStart and jhIndex < 0:
        #    print 'DELETED', sampleId, 'E<->I', eStart, iStart
        #    eIndex, eIdentity, eStart, eEnd = -1, 0, -1, -1
        #if fIdentity > 0 and iIdentity > 0 and fStart > iStart and eIndex < 0 and jhIndex < 0:
        #    print 'DELETED', sampleId, 'F<->I', fStart, iStart
        #    fIndex, fIdentity, fStart, fEnd = -1, 0, -1, -1
        #if ffIdentity > 0 and iIdentity > 0 and ffStart > iStart and fIndex < 0 and eIndex < 0 and jhIndex < 0:
        #    print 'DELETED', sampleId, 'FF<->I', ffStart, iStart
        #    ffIndex, ffIdentity, ffStart, ffEnd = -1, 0, -1, -1
        #if ddIdentity > 0 and iIdentity > 0 and ddStart > iStart and ffIndex < 0 and fIndex < 0 and eIndex < 0 \
        #    and jhIndex < 0:
        #    print 'DELETED', sampleId, 'DD<->I', ddStart, iStart
        #    ddIndex, ddIdentity, ddStart, ddEnd = -1, 0, -1, -1
        #if dIdentity > 0 and iIdentity > 0 and dStart > iStart and ddIndex < 0 and ffIndex < 0 and fIndex < 0 \
        #    and eIndex < 0 and jhIndex < 0:
        #    print 'DELETED', sampleId, 'D<->I', dStart, iStart
        #    dIndex, dIdentity, dStart, dEnd = -1, 0, -1, -1
        #if cIdentity > 0 and iIdentity > 0 and cStart > iStart and dIndex < 0 and ddIndex < 0 and ffIndex < 0 \
        #    and fIndex < 0 and eIndex < 0 and jhIndex < 0:
        #    print 'DELETED', sampleId, 'C<->I', cStart, iStart
        #    cIndex, cIdentity, cStart, cEnd = -1, 0, -1, -1
        #if bIdentity > 0 and iIdentity > 0 and bStart > iStart and cIndex < 0 and dIndex < 0 and ddIndex < 0 \
        #    and ffIndex < 0 and fIndex < 0 and eIndex < 0 and jhIndex < 0:
        #    print 'DELETED', sampleId, 'B<->I', bStart, iStart
        #    bIndex, bIdentity, bStart, bEnd = -1, 0, -1, -1
        #if aIdentity > 0 and iIdentity > 0 and aStart > iStart and bIndex < 0 and cIndex < 0 and dIndex < 0 \
        #    and ddIndex < 0 and ffIndex < 0 and fIndex < 0 and eIndex < 0 and jhIndex < 0:
        #    print 'DELETED', sampleId, 'A<->I', aStart, iStart
        #    aIndex, aIdentity, aStart, aEnd = -1, 0, -1, -1
        if len(sampleId): kSelectionIndex = kList.index(kSelectionDict[sampleId])
        else: kSelectionIndex = -1
        for iK in range(len(kList)):
            if iK != kSelectionIndex: continue
            if kList[iK] in mySeq[-nLinkerCutoff:]:
                kIndex = iK
        if kIndex < 0:
            sFileList = glob.glob(os.path.join(tmpDir, 'K[0-9].fa'))
            sFileList.sort()

            if len(sampleId):
                #kSelectionIndex = kList.index(kSelectionDict[sampleId])
                sFileList = [os.path.join(tmpDir, 'K%d.fa' % kSelectionIndex)]
                print 'kIndex selected', kSelectionIndex, sampleId, sFileList

            sMapList = []
            for sIndex in range(len(sFileList)):
                sFileName = sFileList[sIndex]
                xIndex, xIdentity, xSeq = \
                    CheckIdent(sFileName, os.path.join(tmpDir, seqId + '_LK.fa'), pMinIdentity)
                if xIndex < 0: continue
                sMapList.append((xIdentity, sIndex, xIndex, xSeq))
            if len(sMapList):
                sMapList.sort()
                sMapList.reverse()
                xIdentity, sIndex, xIndex, xSeq = sMapList[0]
                kIndex = sIndex
                kStart, kEnd = len(mySeq)-nLinkerCutoff + xIndex, len(mySeq)-nLinkerCutoff + xIndex + len(xSeq)
                kIdentity = xIdentity
        else:
            kStart = len(mySeq) - nLinkerCutoff + mySeq[-nLinkerCutoff:].index(kList[kIndex])
            kEnd = kStart + len(kList[kIndex])
            kIdentity = 100.
        # RESET K BEFORE IT CAUSES PROBLEMS
        #kCheckList = [aStart, bStart, cStart, dStart, ddStart, ffStart, fStart, eStart, jhStart, iStart]
        #if kCheckList.count(-1) <= 5:
        #    if kStart < max(kCheckList):
        #        print 'DELETED', sampleId, 'KCHECK', kCheckList
        #        kIndex, kIdentity, kStart, kEnd = -1, 0, -1, -1
        #if iIdentity > 0 and kIdentity > 0 and iStart > kStart:
        #    print 'DELETED', sampleId, 'I<->K', iStart, kStart
        #    iIndex, iIdentity, iStart, iEnd = -1, 0, -1, -1
        #if jhIdentity > 0 and kIdentity > 0 and jhStart > kStart and iIndex < 0:
        #    print 'DELETED', sampleId, 'JH<->K', jhStart, kStart
        #    jhIndex, jhIdentity, jhStart, jhEnd = -1, 0, -1, -1
        #if eIdentity > 0 and kIdentity > 0 and eStart > kStart and jhIndex < 0 and iIndex < 0:
        #    print 'DELETED', sampleId, 'E<->K', eStart, kStart
        #    eIndex, eIdentity, eStart, eEnd = -1, 0, -1, -1
        #if fIdentity > 0 and kIdentity > 0 and fStart > kStart and eIndex < 0 and jhIndex < 0 and iIndex < 0:
        #    print 'DELETED', sampleId, 'F<->K', fStart, kStart
        #    fIndex, fIdentity, fStart, fEnd = -1, 0, -1, -1
        #if ffIdentity > 0 and kIdentity > 0 and ffStart > kStart and fIndex < 0 and eIndex < 0 and jhIndex < 0 \
        #    and iIndex < 0:
        #    print 'DELETED', sampleId, 'FF<->K', ffStart, kStart
        #    ffIndex, ffIdentity, ffStart, ffEnd = -1, 0, -1, -1
        #if ddIdentity > 0 and kIdentity > 0 and ddStart > kStart and ffIndex < 0 and fIndex < 0 and eIndex < 0 \
        #    and jhIndex < 0 and iIndex < 0:
        #    print 'DELETED', sampleId, 'DD<->K', ddStart, kStart
        #    ddIndex, ddIdentity, ddStart, ddEnd = -1, 0, -1, -1
        #if dIdentity > 0 and kIdentity > 0 and dStart > kStart and ddIndex < 0 and ffIndex < 0 and fIndex < 0 \
        #    and eIndex < 0 and jhIndex < 0 and iIndex < 0:
        #    print 'DELETED', sampleId, 'D<->K', dStart, kStart
        #    dIndex, dIdentity, dStart, dEnd = -1, 0, -1, -1
        #if cIdentity > 0 and kIdentity > 0 and cStart > kStart and dIndex < 0 and ddIndex < 0 and ffIndex < 0 \
        #    and fIndex < 0 and eIndex < 0 and jhIndex < 0 and iIndex < 0:
        #    print 'DELETED', sampleId, 'C<->K', cStart, kStart
        #    cIndex, cIdentity, cStart, cEnd = -1, 0, -1, -1
        #if bIdentity > 0 and kIdentity > 0 and bStart > kStart and cIndex < 0 and dIndex < 0 and ddIndex < 0 \
        #    and ffIndex < 0 and fIndex < 0 and eIndex < 0 and jhIndex < 0 and iIndex < 0:
        #    print 'DELETED', sampleId, 'B<->K', bStart, kStart
        #    bIndex, bIdentity, bStart, bEnd = -1, 0, -1, -1
        #if aIdentity > 0 and kIdentity > 0 and aStart > kStart and bIndex < 0 and cIndex < 0 and dIndex < 0 \
        #    and ddIndex < 0 and ffIndex < 0 and fIndex < 0 and eIndex < 0 and jhIndex < 0 and iIndex < 0:
        #    print 'DELETED', sampleId, 'A<->K', aStart, kStart
        #    aIndex, aIdentity, aStart, aEnd = -1, 0, -1, -1
        # REMOVE ALL TEMPORARY FILES
        os.remove(os.path.join(tmpDir, seqId + '.fa'))
        os.remove(os.path.join(tmpDir, seqId + '_TA.fa'))
        os.remove(os.path.join(tmpDir, seqId + '_B.fa'))
        os.remove(os.path.join(tmpDir, seqId + '_VC.fa'))
        os.remove(os.path.join(tmpDir, seqId + '_LK.fa'))
    else:
        # SAVE FILE OTHERS
        open(os.path.join(outDir, '%s_SAMPLE_NOTAG.txt' % runId), 'a').write('>' + seqId + '\n' + mySeq + '\n')
        # REMOVE ALL TEMPORARY FILES
        os.remove(os.path.join(tmpDir, seqId + '.fa'))
        os.remove(os.path.join(tmpDir, seqId + '_TA.fa'))
        os.remove(os.path.join(tmpDir, seqId + '_B.fa'))
        os.remove(os.path.join(tmpDir, seqId + '_VC.fa'))
        os.remove(os.path.join(tmpDir, seqId + '_LK.fa'))
        continue
    # CHECK G. BY INDEX, RFIND IN VENTER REGION
    if eIndex < 0:
        for iG in range(len(gList)):
            if gList[iG] in mySeq[nVectorMinCutoff:nVectorMaxCutoff]:
                gIndex = iG
    else:
        for iG in range(len(gList)):
            if gList[iG] in mySeq[eStart:eEnd]:
                gIndex = iG
    if gIndex >= 0:
        if fIndex >= 0:
            if fIndex > gIndex: gIndex = -1
        if eIndex >= 0:
            if eIndex > gIndex: gIndex = -1
    if gIndex >= 0:
        if eIndex >= 0:
            gStart = eStart + mySeq[eStart:eEnd].rfind(gList[gIndex])
            gEnd = gStart + len(gList[gIndex])
            gIdentity = 100.
        else:
            gStart = nVectorMinCutoff + mySeq[nVectorMinCutoff:nVectorMaxCutoff].rfind(gList[gIndex])
            gEnd = gStart + len(gList[gIndex])
            gIdentity = 100.

    # CHECK INTEGRITY OF TAG POSITIONS
    """
    if myJunction == 'RIGHT':
        posList1 = [tagStart, aStart, bStart, cStart, dStart, ffStart, ddStart, fStart, eStart, jhStart, iStart, kStart]
        posListStr1 = ['TAG', 'A', 'B', 'C', 'D', 'FF', 'DD', 'F', 'E', 'JH', 'I', 'K']
    elif myJunction == 'LEFT':
        posList1 = [tagStart, aStart, bStart, cStart, dStart, ddStart, ffStart, fStart, eStart, jhStart, iStart, kStart]
        posListStr1 = ['TAG', 'A', 'B', 'C', 'D', 'DD', 'FF', 'F', 'E', 'JH', 'I', 'K']
    else:
        posList1 = []
        posListStr1 = []
    posList2 = [ix for ix in posList1 if ix >= 0]
    posList3 = copy.deepcopy(posList2)
    posList3.sort()
    if posList2 != posList3:
        print >> sys.stderr, seqId, myJunction
        print >> sys.stderr, 'TAG', tagIndex, tagIdentity, tagStart, tagEnd
        print >> sys.stderr, 'A', aIndex, aIdentity, aStart, aEnd
        print >> sys.stderr, 'B', bIndex, bIdentity, bStart, bEnd
        print >> sys.stderr, 'C', cIndex, cIdentity, cStart, cEnd
        print >> sys.stderr, 'D', dIndex, dIdentity, dStart, dEnd
        print >> sys.stderr, 'DD', ddIndex, ddIdentity, ddStart, ddEnd
        print >> sys.stderr, 'E', eIndex, eIdentity, eStart, eEnd
        print >> sys.stderr, 'F', fIndex, fIdentity, fStart, fEnd
        print >> sys.stderr, 'FF', ffIndex, ffIdentity, ffStart, ffEnd
        print >> sys.stderr, 'G', gIndex, gIdentity, gStart, gEnd
        print >> sys.stderr, 'J+H', jhIndex, jhIdentity, jhStart, jhEnd
        print >> sys.stderr, 'I', iIndex, iIdentity, iStart, iEnd
        print >> sys.stderr, 'K', kIndex, kIdentity, kStart, kEnd
        print >> sys.stderr, 'TAG POSITION MIS-IDENTIFIED', seqId, [(ix, iy) for ix, iy in zip(posListStr1, posList1)]
        # REMOVE TAG IDS AFTER D
        iIndex, iIdentity, iStart, iEnd = -1, 0, -1, -1
        if myJunction == 'RIGHT':
            posList1 = [tagStart, aStart, bStart, cStart, dStart, ffStart, ddStart, fStart, eStart, jhStart, \
                iStart, kStart]
            posListStr1 = ['TAG', 'A', 'B', 'C', 'D', 'FF', 'DD', 'F', 'E', 'JH', 'I', 'K']
        elif myJunction == 'LEFT':
            posList1 = [tagStart, aStart, bStart, cStart, dStart, ddStart, ffStart, fStart, eStart, jhStart, \
                iStart, kStart]
            posListStr1 = ['TAG', 'A', 'B', 'C', 'D', 'DD', 'FF', 'F', 'E', 'JH', 'I', 'K']
        else:
            posList1 = []
            posListStr1 = []
        posList2 = [ix for ix in posList1 if ix >= 0]
        posList3 = copy.deepcopy(posList2)
        posList3.sort()
        if posList2 != posList3:
            ddIndex, eIndex, fIndex, ffIndex, gIndex, jhIndex, iIndex, kIndex = (-1,)*8
            ddIdentity, eIdentity, fIdentity, ffIdentity, gIdentity, jhIdentity, iIdentity, kIdentity = (0,)*8
            ddStart, eStart, fStart, ffStart, gStart, jhStart, iStart, kStart = (-1,)*8
            ddEnd, eEnd, fEnd, ffEnd, gEnd, jhEnd, iEnd, kEnd = (-1,)*8
        #raw_input('Press Enter Key')
    """

    print 'TAG', tagIndex, tagIdentity, tagStart, tagEnd
    print 'A', aIndex, aIdentity, aStart, aEnd
    print 'B', bIndex, bIdentity, bStart, bEnd
    print 'C', cIndex, cIdentity, cStart, cEnd
    print 'D', dIndex, dIdentity, dStart, dEnd
    print 'DD', ddIndex, ddIdentity, ddStart, ddEnd
    print 'E', eIndex, eIdentity, eStart, eEnd
    print 'F', fIndex, fIdentity, fStart, fEnd
    print 'FF', ffIndex, ffIdentity, ffStart, ffEnd
    print 'G', gIndex, gIdentity, gStart, gEnd
    print 'J+H', jhIndex, jhIdentity, jhStart, jhEnd
    print 'I', iIndex, iIdentity, iStart, iEnd
    print 'K', kIndex, kIdentity, kStart, kEnd

    idList = [tagIndex, aIndex, bIndex, cIndex, dIndex, ddIndex, eIndex, fIndex, ffIndex, gIndex, jhIndex, \
        iIndex, kIndex]
    idStr = '|' + ','.join(map(str, idList))

    print seqId, idStr

    if tagIndex < 0 or aIndex < 0:
        if tagIndex < 0 or bIdentity < pMinIdentity:
            seqId2 = seqId + idStr
            open(os.path.join(outDir, '%s_SAMPLE_OTHERS.txt' % runId), 'a').write('>' + seqId2 + '\n' + mySeq + '\n')
            continue
    if cIdentity < pMinIdentity:
        if dIdentity < pMinIdentity:
            if ddIdentity < pMinIdentity:
                seqId2 = seqId + idStr
                open(os.path.join(outDir, '%s_SAMPLE_TAG_NOMATCH.txt' % runId), 'a').write('>'+seqId2+'\n'+mySeq+'\n')
                continue

    # now, several restriction enzyme is used for 454 sequencing to include many samples
    if len(sampleId): reSite = tcgaCheckDict[sampleId]
    else: reSite = ''

    if eIdentity < 100.:
        if fIdentity < pMinIdentity or gIdentity < 100.:
            if ffIdentity < pMinIdentity or gIdentity < 100.:
                # TRIM OFF "PRIMER", TILL C/D/DD, GET THEIR MAX COORDINATES
                primerEnd = max(cEnd, dEnd, ddEnd)
                noPMSeq = mySeq[primerEnd:]
                if jhIdentity < pMinIdentity:
                    if iIdentity < pMinIdentity:
                        if kIdentity < pMinIdentity:
                            seqId2 = seqId + idStr
                            # ADD STEPS FOR IDENTIFICATION OF FIRST 26/12BP AND TCGA
                            open(os.path.join(tmpDir, seqId + '_PM.fa'), 'w').write('>' + seqId + '\n' \
                                + noPMSeq + '\n')
                            #if aIndex == 1 or bIndex == 0: # LEFT
                            if myJunction == 'LEFT':
                                leftIndex, leftIdentity, leftSeq = CheckIdent(os.path.join(tmpDir, 'LEFT.fa'), \
                                    os.path.join(tmpDir, seqId + '_PM.fa'), 100.*23.5/26.)
                                os.remove(os.path.join(tmpDir, seqId + '_PM.fa'))
                                if leftIndex >= 0:
                                    noVCSeq = noPMSeq[noPMSeq.index(leftSeq)+len(leftSeq):]
                                    iTCGA = noVCSeq.rfind(reSite)

                                    checkTCGA = 0
                                    if len(sampleId):
                                        tcgaCheck = tcgaCheckDict.get(sampleId, 'X')
                                        if tcgaCheck == reSite: checkTCGA = 1
                                        print 'Checking TCGA', sampleId, checkTCGA

                                    if iTCGA >= max(len(noVCSeq) - 10, 0) and checkTCGA:
                                        open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_L_TRIMMED3L.txt' % runId), \
                                            'a').write('>' + seqId2 + '\n' + noVCSeq[:iTCGA+4] + '\n')
                                        continue
                                    else:
                                        if checkTCGA:
                                            open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_NO_TRIMMED3L.txt'%runId), \
                                                'a').write('>' + seqId2 + '\n' + noVCSeq + '\n')
                                            continue
                                        else:
                                            open(os.path.join(outDir,'%s_SAMPLE_TAG_FULLEND_NO_TRIMMED3LT.txt'%runId), \
                                                'a').write('>' + seqId2 + '\n' + noVCSeq + '\n')
                                            continue
                            #if (aIndex == 0 or bIndex == 1) and \
                            #    os.path.exists(os.path.join(tmpDir, seqId + '_PM.fa')): # RIGHT
                            if myJunction == 'RIGHT' and \
                                os.path.exists(os.path.join(tmpDir, seqId + '_PM.fa')): # RIGHT
                                rightIndex, rightIdentity, rightSeq = CheckIdent(os.path.join(tmpDir, 'RIGHT.fa'), \
                                    os.path.join(tmpDir, seqId + '_PM.fa'), 100.*10.5/12.)
                                os.remove(os.path.join(tmpDir, seqId + '_PM.fa'))
                                if rightIndex >= 0:
                                    noVCSeq = noPMSeq[noPMSeq.index(rightSeq)+len(rightSeq):]
                                    iTCGA = noVCSeq.rfind(reSite)

                                    checkTCGA = 0
                                    if len(sampleId):
                                        tcgaCheck = tcgaCheckDict.get(sampleId, 'X')
                                        if tcgaCheck == reSite: checkTCGA = 1
                                        print 'Checking TCGA', sampleId, checkTCGA

                                    if iTCGA >= max(len(noVCSeq) - 10, 0) and checkTCGA:
                                        open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_L_TRIMMED3R.txt' % runId),
                                            'a').write('>' + seqId2 + '\n' + noVCSeq[:iTCGA+4] + '\n')
                                        continue
                                    else:
                                        if checkTCGA:
                                            open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_NO_TRIMMED3R.txt'%runId), \
                                                'a').write('>' + seqId2 + '\n' + noVCSeq + '\n')
                                            continue
                                        else:
                                            open(os.path.join(outDir,'%s_SAMPLE_TAG_FULLEND_NO_TRIMMED3RT.txt'%runId), \
                                                'a').write('>' + seqId2 + '\n' + noVCSeq + '\n')
                                            continue
                            try:
                                os.remove(os.path.join(tmpDir, seqId + '_PM.fa'))
                            except:
                                pass
                            iTCGA = noPMSeq.rfind(reSite)

                            checkTCGA = 0
                            if len(sampleId):
                                tcgaCheck = tcgaCheckDict.get(sampleId, 'X')
                                if tcgaCheck == reSite: checkTCGA = 1
                                print 'Checking TCGA', sampleId, checkTCGA

                            if iTCGA >= max(len(noPMSeq) - 10, 0) and checkTCGA:
                                open(os.path.join(outDir, '%s_SAMPLE_TAG_TRUNCATED_L_TRIMMED3.txt' % runId), \
                                    'a').write('>' + seqId2 + '\n' + noPMSeq[:iTCGA+4] + '\n')
                                continue
                            else:
                                if checkTCGA:
                                    open(os.path.join(outDir, '%s_SAMPLE_TAG_TRUNCATED_NO_TRIMMED3.txt' % runId), \
                                        'a').write('>' + seqId2 + '\n' + noPMSeq + '\n')
                                    continue
                                else:
                                    open(os.path.join(outDir, '%s_SAMPLE_TAG_TRUNCATED_NO_TRIMMED3T.txt' % runId), \
                                        'a').write('>' + seqId2 + '\n' + noPMSeq + '\n')
                                    continue
                            continue
                        else:
                            # TRIM OF 'L' BASEPAIR UPSTREAM OF 'K': K1->12, K2->9, K3->22
                            if kIndex >= 0: linkerStart = kStart - kCutDict[kList[kIndex]]
                            else: print >> sys.stderr, 'ERROR2: WRONG KINDEX', seqId, mySeq
                            noPMLKSeq = mySeq[primerEnd:linkerStart]
                            seqId2 = seqId + idStr
                            open(os.path.join(tmpDir, seqId + '_PM.fa'), 'w').write('>' + seqId + '\n' \
                                + noPMLKSeq + '\n')
                            #if aIndex == 1 or bIndex == 0: # LEFT
                            if myJunction == 'LEFT':
                                leftIndex, leftIdentity, leftSeq = CheckIdent(os.path.join(tmpDir, 'LEFT.fa'), \
                                    os.path.join(tmpDir, seqId + '_PM.fa'), 100.*23.5/26.)
                                os.remove(os.path.join(tmpDir, seqId + '_PM.fa'))
                                if leftIndex >= 0:
                                    noVCLKSeq = noPMLKSeq[noPMLKSeq.index(leftSeq)+len(leftSeq):]
                                    open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_L_TRIMMED3L.txt' % runId), \
                                       'a').write('>' + seqId2 + '\n' + noVCLKSeq + '\n')
                                    continue
                            #if (aIndex == 0 or bIndex == 1) and \
                            #    os.path.exists(os.path.join(tmpDir, seqId + '_PM.fa')): # RIGHT
                            if myJunction == 'RIGHT' and \
                                os.path.exists(os.path.join(tmpDir, seqId + '_PM.fa')): # RIGHT
                                rightIndex, rightIdentity, rightSeq = CheckIdent(os.path.join(tmpDir, 'RIGHT.fa'), \
                                    os.path.join(tmpDir, seqId + '_PM.fa'), 100.*10.5/12.)
                                os.remove(os.path.join(tmpDir, seqId + '_PM.fa'))
                                if rightIndex >= 0:
                                    noVCLKSeq = noPMLKSeq[noPMLKSeq.index(rightSeq)+len(rightSeq):]
                                    open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_L_TRIMMED3R.txt' % runId), \
                                        'a').write('>' + seqId2 + '\n' + noVCLKSeq + '\n')
                                    continue
                            try:
                                os.remove(os.path.join(tmpDir, seqId + '_PM.fa'))
                            except:
                                pass
                            open(os.path.join(outDir, '%s_SAMPLE_TAG_TRUNCATED_L_TRIMMED3.txt' % runId), \
                                'a').write('>' + seqId2 + '\n' + noPMLKSeq + '\n')
                            continue
                # TRIM OFF "LINKER", TILL J+H/I, GET THEIR MIN COORDINATES
                linkerStart = -1
                if jhIndex >= 0:
                    for jSeq, hSeq in jnhList:
                        if jhList.index(jSeq + hSeq) == jhIndex:
                            linkerStart = jhStart + len(jSeq)
                else:
                    if iIndex >= 0:
                        linkerStart = iStart
                if linkerStart >= 0:
                    noPMLKSeq = mySeq[primerEnd:linkerStart]
                    seqId2 = seqId + idStr
                    if 1:
                        if 1:
                            open(os.path.join(tmpDir, seqId + '_PM.fa'), 'w').write('>' + seqId + '\n' \
                                + noPMLKSeq + '\n')
                            #if aIndex == 1 or bIndex == 0: # LEFT
                            if myJunction == 'LEFT':
                                leftIndex, leftIdentity, leftSeq = CheckIdent(os.path.join(tmpDir, 'LEFT.fa'), \
                                    os.path.join(tmpDir, seqId + '_PM.fa'), 100.*23.5/26.)
                                os.remove(os.path.join(tmpDir, seqId + '_PM.fa'))
                                if leftIndex >= 0:
                                    noVCLKSeq = noPMLKSeq[noPMLKSeq.index(leftSeq)+len(leftSeq):]
                                    open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_L_TRIMMED3L.txt' % runId), \
                                        'a').write('>' + seqId2 + '\n' + noVCLKSeq + '\n')
                                    continue
                            #if (aIndex == 0 or bIndex == 1) and \
                            #    os.path.exists(os.path.join(tmpDir, seqId + '_PM.fa')): # RIGHT
                            if myJunction == 'RIGHT' and \
                                os.path.exists(os.path.join(tmpDir, seqId + '_PM.fa')): # RIGHT
                                rightIndex, rightIdentity, rightSeq = CheckIdent(os.path.join(tmpDir, 'RIGHT.fa'), \
                                    os.path.join(tmpDir, seqId + '_PM.fa'), 100.*10.5/12.)
                                os.remove(os.path.join(tmpDir, seqId + '_PM.fa'))
                                if rightIndex >= 0:
                                    noVCLKSeq = noPMLKSeq[noPMLKSeq.index(rightSeq)+len(rightSeq):]
                                    open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_L_TRIMMED3R.txt' % runId), \
                                        'a').write('>' + seqId2 + '\n' + noVCLKSeq + '\n')
                                    continue
                            try:
                                os.remove(os.path.join(tmpDir, seqId + '_PM.fa'))
                            except:
                                pass
                            open(os.path.join(outDir, '%s_SAMPLE_TAG_TRUNCATED_L_TRIMMED3.txt' % runId), \
                                'a').write('>' + seqId2 + '\n' + noPMLKSeq + '\n')
                            continue
                else:
                    # ADD STEPS FOR IDENTIFICATION OF FIRST 26/12BP AND TCGA
                    if 1:
                        if 1:
                            open(os.path.join(tmpDir, seqId + '_PM.fa'), 'w').write('>' + seqId + '\n' \
                                + noPMSeq + '\n')
                            #if aIndex == 1 or bIndex == 0: # LEFT
                            if myJunction == 'LEFT':
                                leftIndex, leftIdentity, leftSeq = CheckIdent(os.path.join(tmpDir, 'LEFT.fa'), \
                                    os.path.join(tmpDir, seqId + '_PM.fa'), 100.*23.5/26.)
                                os.remove(os.path.join(tmpDir, seqId + '_PM.fa'))
                                if leftIndex >= 0:
                                    noVCSeq = noPMSeq[noPMSeq.index(leftSeq)+len(leftSeq):]
                                    iTCGA = noVCSeq.rfind(reSite)

                                    checkTCGA = 0
                                    if len(sampleId):
                                        tcgaCheck = tcgaCheckDict.get(sampleId, 'X')
                                        if tcgaCheck == reSite: checkTCGA = 1
                                        print 'Checking TCGA', sampleId, checkTCGA

                                    if iTCGA >= max(len(noVCSeq) - 10, 0) and checkTCGA:
                                        open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_L_TRIMMED4L.txt' % runId), \
                                            'a').write('>' + seqId2 + '\n' + noVCSeq[:iTCGA+4] + '\n')
                                        continue
                                    else:
                                        if checkTCGA:
                                            open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_NO_TRIMMED4L.txt'%runId), \
                                                'a').write('>' + seqId2 + '\n' + noVCSeq + '\n')
                                            continue
                                        else:
                                            open(os.path.join(outDir,'%s_SAMPLE_TAG_FULLEND_NO_TRIMMED4LT.txt'%runId), \
                                                'a').write('>' + seqId2 + '\n' + noVCSeq + '\n')
                                            continue
                            #if (aIndex == 0 or bIndex == 1) and \
                            #    os.path.exists(os.path.join(tmpDir, seqId + '_PM.fa')): # RIGHT
                            if myJunction == 'RIGHT' and \
                                os.path.exists(os.path.join(tmpDir, seqId + '_PM.fa')): # RIGHT
                                rightIndex, rightIdentity, rightSeq = CheckIdent(os.path.join(tmpDir, 'RIGHT.fa'), \
                                    os.path.join(tmpDir, seqId + '_PM.fa'), 100.*10.5/12.)
                                os.remove(os.path.join(tmpDir, seqId + '_PM.fa'))
                                if rightIndex >= 0:
                                    noVCSeq = noPMSeq[noPMSeq.index(rightSeq)+len(rightSeq):]
                                    iTCGA = noVCSeq.rfind(reSite)

                                    checkTCGA = 0
                                    if len(sampleId):
                                        tcgaCheck = tcgaCheckDict.get(sampleId, 'X')
                                        if tcgaCheck == reSite: checkTCGA = 1
                                        print 'Checking TCGA', sampleId, checkTCGA

                                    if iTCGA >= max(len(noVCSeq) - 10, 0) and checkTCGA:
                                        open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_L_TRIMMED4R.txt' % runId), \
                                            'a').write('>' + seqId2 + '\n' + noVCSeq[:iTCGA+4] + '\n')
                                        continue
                                    else:
                                        if checkTCGA:
                                            open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_NO_TRIMMED4R.txt'%runId), \
                                                'a').write('>' + seqId2 + '\n' + noVCSeq + '\n')
                                            continue
                                        else:
                                            open(os.path.join(outDir,'%s_SAMPLE_TAG_FULLEND_NO_TRIMMED4RT.txt'%runId), \
                                                'a').write('>' + seqId2 + '\n' + noVCSeq + '\n')
                                            continue
                            try:
                                os.remove(os.path.join(tmpDir, seqId + '_PM.fa'))
                            except:
                                pass
                            iTCGA = noPMSeq.rfind(reSite)

                            checkTCGA = 0
                            if len(sampleId):
                                tcgaCheck = tcgaCheckDict.get(sampleId, 'X')
                                if tcgaCheck == reSite: checkTCGA = 1
                                print 'Checking TCGA', sampleId, checkTCGA

                            if iTCGA >= max(len(noPMSeq) - 10, 0) and checkTCGA:
                                open(os.path.join(outDir, '%s_SAMPLE_TAG_TRUNCATED_L_TRIMMED4.txt' % runId), \
                                    'a').write('>' + seqId2 + '\n' + noPMSeq[:iTCGA+4] + '\n')
                                continue
                            else:
                                if checkTCGA:
                                    open(os.path.join(outDir, '%s_SAMPLE_TAG_TRUNCATED_NO_TRIMMED4.txt' % runId), \
                                        'a').write('>' + seqId2 + '\n' + noPMSeq + '\n')
                                    continue
                                else:
                                    open(os.path.join(outDir, '%s_SAMPLE_TAG_TRUNCATED_NO_TRIMMED4T.txt' % runId), \
                                        'a').write('>' + seqId2 + '\n' + noPMSeq + '\n')
                                    continue
                            continue
                continue
    # TRIM OFF "VECTOR", TILL E/G, GET THEIR MAX COORDINATES
    vectorEnd = max(eEnd, gEnd)
    noVCSeq = mySeq[vectorEnd:]
    if jhIdentity < pMinIdentity:
        if iIdentity < pMinIdentity:
            if kIdentity < pMinIdentity:
                seqId2 = seqId + idStr
                iTCGA = noVCSeq.rfind(reSite)

                checkTCGA = 0
                if len(sampleId):
                    tcgaCheck = tcgaCheckDict.get(sampleId, 'X')
                    if tcgaCheck == reSite: checkTCGA = 1
                    print 'Checking TCGA', sampleId, checkTCGA

                if iTCGA >= max(len(noVCSeq) - 10, 0) and checkTCGA:
                    open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_L_TRIMMED6.txt' % runId), \
                        'a').write('>' + seqId2 + '\n' + noVCSeq[:iTCGA+4] + '\n')
                    continue
                else:
                    if checkTCGA:
                        open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_NO_TRIMMED6.txt' % runId), \
                            'a').write('>' + seqId2 + '\n' + noVCSeq + '\n')
                        continue
                    else:
                        open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_NO_TRIMMED6T.txt' % runId), \
                            'a').write('>' + seqId2 + '\n' + noVCSeq + '\n')
                        continue
            else:
                # TRIM OF 'L' BASEPAIR UPSTREAM OF 'K': K1->12, K2->9, K3->22
                if kIndex >= 0: linkerStart = kStart - kCutDict[kList[kIndex]]
                else: print >> sys.stderr, 'ERROR2: WRONG KINDEX', seqId, mySeq
                noVCLKSeq = mySeq[vectorEnd:linkerStart]
                seqId2 = seqId + idStr
                open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_L_TRIMMED7.txt' % runId), \
                    'a').write('>'+seqId2+'\n' + noVCLKSeq + '\n')
                continue
    # TRIM OFF "LINKER", TILL J+H/I, GET THEIR MIN COORDINATES
    linkerStart = -1
    if jhIndex >= 0:
        for jSeq, hSeq in jnhList:
            if jhList.index(jSeq + hSeq) == jhIndex:
                linkerStart = jhStart + len(jSeq)
    else:
        if iIndex >= 0:
            linkerStart = iStart
    if linkerStart < 0:
        seqId2 = seqId + idStr
        iTCGA = noVCSeq.rfind(reSite)

        checkTCGA = 0
        if len(sampleId):
            tcgaCheck = tcgaCheckDict.get(sampleId, 'X')
            if tcgaCheck == reSite: checkTCGA = 1
            print 'Checking TCGA', sampleId, checkTCGA

        if iTCGA >= max(len(noVCSeq) - 10, 0) and checkTCGA:
            open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_L_TRIMMED5.txt' % runId), \
                'a').write('>' + seqId2 + '\n' + noVCSeq[:iTCGA+4] + '\n')
            continue
        else:
            if checkTCGA:
                open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_NO_TRIMMED5.txt' % runId), \
                    'a').write('>' + seqId2 + '\n' + noVCSeq + '\n')
                continue
            else:
                open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_NO_TRIMMED5T.txt' % runId), \
                    'a').write('>' + seqId2 + '\n' + noVCSeq + '\n')
                continue
    else:
        noVCLKSeq = mySeq[vectorEnd:linkerStart]
        seqId2 = seqId + idStr
        open(os.path.join(outDir, '%s_SAMPLE_TAG_FULLEND_L_TRIMMED8.txt' % runId), 'a').write('>' + seqId2 + '\n' \
            + noVCLKSeq + '\n')
        #print seqId2, mySeq, vectorEnd, linkerStart
        #print 'TAG', tagIndex, tagIdentity, tagStart, tagEnd
        #print 'A', aIndex, aIdentity, aStart, aEnd
        #print 'B', bIndex, bIdentity, bStart, bEnd
        #print 'C', cIndex, cIdentity, cStart, cEnd
        #print 'D', dIndex, dIdentity, dStart, dEnd
        #print 'DD', ddIndex, ddIdentity, ddStart, ddEnd
        #print 'E', eIndex, eIdentity, eStart, eEnd
        #print 'F', fIndex, fIdentity, fStart, fEnd
        #print 'FF', ffIndex, ffIdentity, ffStart, ffEnd
        #print 'G', gIndex, gIdentity, gStart, gEnd
        #print 'J+H', jhIndex, jhIdentity, jhStart, jhEnd
        #print 'I', iIndex, iIdentity, iStart, iEnd
        #print 'K', kIndex, kIdentity, kStart, kEnd
        #raw_input('Press Enter Key')
        continue

    # CHECKING...
    #raw_input('Press Enter Key')

os.system('rm -rf %s' % tmpDir)

# FINALIZE, SAVE ALL ID SEQUENCES AND ITS NUMERIC IDENTIFIERS
outfile = open(os.path.join(outDir, '%s_SAMPLE_ID_INFORMATION.txt' % runId), 'w')
for ix in range(len(tagList)):
    outfile.write('TAG' + '\t' + str(ix) + '\t' + tagList[ix] + '\n')
for ix in range(len(aList)):
    outfile.write('A' + '\t' + str(ix) + '\t' + aList[ix] + '\n')
for ix in range(len(bList)):
    outfile.write('B' + '\t' + str(ix) + '\t' + bList[ix] + '\n')
for ix in range(len(cList)):
    outfile.write('C' + '\t' + str(ix) + '\t' + cList[ix] + '\n')
for ix in range(len(dList)):
    outfile.write('D' + '\t' + str(ix) + '\t' + dList[ix] + '\n')
for ix in range(len(ddList)):
    outfile.write('DD' + '\t' + str(ix) + '\t' + ddList[ix] + '\n')
for ix in range(len(eList)):
    outfile.write('E' + '\t' + str(ix) + '\t' + eList[ix] + '\n')
for ix in range(len(fList)):
    outfile.write('F' + '\t' + str(ix) + '\t' + fList[ix] + '\n')
for ix in range(len(ffList)):
    outfile.write('FF' + '\t' + str(ix) + '\t' + ffList[ix] + '\n')
for ix in range(len(gList)):
    outfile.write('G' + '\t' + str(ix) + '\t' + gList[ix] + '\n')
for ix in range(len(jhList)):
    outfile.write('J+H' + '\t' + str(ix) + '\t' + jhList[ix] + '\n')
for ix in range(len(iList)):
    outfile.write('I' + '\t' + str(ix) + '\t' + iList[ix] + '\n')
for ix in range(len(kList)):
    outfile.write('K' + '\t' + str(ix) + '\t' + kList[ix] + '\n')
outfile.close()


