%%%%Opening functions 
function varargout = Simulator(varargin) 
% Last Modified by GUIDE v2.5 24-Aug-2016 18:32:48

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Simulator_OpeningFcn, ...
                   'gui_OutputFcn',  @Simulator_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT
function Simulator_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.

% Choose default command line output for Simulator
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);
handles.filename = varargin{1}
guidata(hObject,handles);
loadValues(handles);
close(Initialization);
function varargout = Simulator_OutputFcn(hObject, eventdata, handles) 

% Get default command line output from handles structure
varargout{1} = handles.output;


%%%% functions %%%%
function saveVariables(handles) %%%save variables
load (handles.filename);
filename = handles.filename;
studyNumber = getStimNumber(handles);
dur(studyNumber) = str2double(get(handles.durationText,'String'));
dDAR(studyNumber)=str2double(get(handles.dDARText,'String'));
dDARtau(studyNumber)=str2double(get(handles.dDARtauText,'String'));
DARss(studyNumber)=str2double(get(handles.DARssText,'String'));
Taur(studyNumber)=str2double(get(handles.TauRText,'String'));
m(studyNumber)=str2double(get(handles.mText,'String'));
Xr(studyNumber)=str2double(get(handles.XrText,'String'));
Vmax(studyNumber)= str2double(get(handles.VmaxText, 'String'));
Kmi(studyNumber) = str2double(get(handles.KmiText,'String'));
dKm(studyNumber)=str2double(get(handles.dKmText,'String'));
KmInf(studyNumber)=str2double(get(handles.KmInfText,'String'));
k(studyNumber)=str2double(get(handles.kText,'String'));
save (handles.filename,'dDAR','dDARtau','DARss','Taur','m','Xr','Vmax','Kmi','dKm','KmInf','k','studyNumber','dur','Data','numPerStudy','filename', 'stimTI','simtime1','simtime2');

function simulate(handles)
load (handles.filename);
filename = handles.filename;
studyNumber = getStimNumber(handles);
dur(studyNumber) = str2double(get(handles.durationText,'String')); %%duration
dDAR(studyNumber) =str2double(get(handles.dDARText,'String')); %%%dDAR
dDARtau(studyNumber)= str2double(get(handles.dDARtauText,'String')); %%%dDARtau
DARss(studyNumber)=str2double(get(handles.DARssText,'String')); %%%DARss
Taur(studyNumber)=str2double(get(handles.TauRText,'String')); %%%Taur
m(studyNumber)=str2double(get(handles.mText,'String')); %%%%m
Xr(studyNumber)=str2double(get(handles.XrText,'String'));%%%%Xr
Vmax(studyNumber)= str2double(get(handles.VmaxText, 'String')); %%%%Vmax
Kmi(studyNumber)= str2double(get(handles.KmiText,'String')); %%%%Kmi
dKm(studyNumber)=str2double(get(handles.dKmText,'String')); %%%%dKm
KmInf(studyNumber)=str2double(get(handles.KmInfText,'String')); %%%%KmInf
k(studyNumber)=str2double(get(handles.kText,'String')); %%%%%k
% save (handles.filename,'dDAR','dDARtau','DARss','Taur','m','Xr','Vmax','Kmi','dKm','KmInf','k','studyNumber','dur','Data','numPerStudy','filename', 'stimTI','simtime1','simtime2');
Simulate
%%%%%plot main graph
plot(handles.MainGraph,simTime,AttenuatingRelReuptakeMMmodel,'-.b','Linewidth',2);
hold(handles.MainGraph,'on');
plot(handles.MainGraph,simTime,AttenuatingRelReuptakeMMmodelwopostDAR,':r', 'Linewidth',1)
% AttenuatingRelReuptakeMMmodelwopostDAR(1500)
plot(handles.MainGraph,expTime,DAexp,'Color',[.5 .5 0],'Linewidth',3);
legend({'Simulation', 'Sim w/o post-stim release', 'Experimental'}, 'Fontsize',16)
% DAexp(1)
% legend BOXOFF
set(handles.MainGraph, 'FontSize', 14, 'FontWeight', 'B', 'XColor','w', 'YColor','w')
axes(handles.MainGraph)
xlabel('time (s)')
ylabel('[DA] (M)', 'FontSize', 18)
hold(handles.MainGraph,'off');

%%%%Plot RelReup graph
plot(handles.RelReup,simTime,DAR);
hold(handles.RelReup,'on'); 
plot(handles.RelReup,simTime,postDARtot)
plot(handles.RelReup,simTime, -UptakeRwopostDAR,':r', 'Linewidth',1);
plot(handles.RelReup,simTime, -UptakeR);
plot(handles.RelReup,expTime,DAExpDeriv,'Color',[.5 .5 0],'Linewidth',3);
plot(handles.RelReup,expTime,AttenuatingRelReuptakeMMmodelDeriv,'-.b','Linewidth',2);
set(handles.RelReup, 'FontSize', 14, 'FontWeight', 'B', 'XColor','w', 'YColor','w')
axes(handles.RelReup)
xlabel('time (s)')
ylabel('d[DA]/dt (M/s)','FontSize', 18)
hold(handles.RelReup,'off');

%%%%Plot PostDAR
plot (handles.PostDAR,simTime,DAR,':r', 'Linewidth',1);
hold(handles.PostDAR,'on');
plot (handles.PostDAR,simTime,EstimatedpostDAR,'Color',[.5 .5 0],'linewidth',3);
plot (handles.PostDAR,simTime,postDARtot,'-.b','Linewidth',2);
set(handles.PostDAR, 'FontSize', 14, 'FontWeight', 'B', 'XColor','w', 'YColor','w')
axes(handles.PostDAR)
xlabel('time (s)')
ylabel('d[DA]/dt (M/s)','FontSize', 18)
hold(handles.PostDAR,'off');
function loadValues(handles)
load (handles.filename);
studyNumber = 1;

set(handles.durationText,'String',dur(studyNumber));
set(handles.studyNumText,'String','1');
set(handles.stimNumText,'String','1');
set(handles.VmaxText,'String',Vmax(studyNumber));
set(handles.KmiText,'String',Kmi(studyNumber));
set(handles.dDARText,'String',dDAR(studyNumber));
set(handles.dDARtauText,'String',dDARtau(studyNumber));
set(handles.DARssText,'String',DARss(studyNumber));
set(handles.TauRText,'String',Taur(studyNumber));
set(handles.mText,'String',m(studyNumber));
set(handles.XrText,'String',Xr(studyNumber));
set(handles.dKmText,'String',dKm(studyNumber));
set(handles.KmInfText,'String',KmInf(studyNumber));
set(handles.kText,'String',k(studyNumber));
save (handles.filename,'dDAR','dDARtau','DARss','Taur','m','Xr','Vmax','Kmi','dKm','KmInf','k','studyNumber','dur','Data','numPerStudy','filename','stimTI','simtime1','simtime2');

function studyNum  = getStimNumber(handles)
load (handles.filename);
studyNum = (str2double(get(handles.studyNumText,'String'))-1)*numPerStudy + str2double(get(handles.stimNumText,'String'));

function changeStim(handles)
load (handles.filename);
filename = handles.filename;
studyNumber = getStimNumber(handles);

set(handles.durationText,'String',dur(studyNumber));
set(handles.VmaxText,'String',Vmax(studyNumber));
set(handles.dKmText,'String',Kmi(studyNumber));
set(handles.dDARText,'String',dDAR(studyNumber));
set(handles.dDARtauText,'String',dDARtau(studyNumber));
set(handles.DARssText,'String',DARss(studyNumber));
set(handles.TauRText,'String',Taur(studyNumber));
set(handles.mText,'String',m(studyNumber));
set(handles.XrText,'String',Xr(studyNumber));
set(handles.dKmText,'String',dKm(studyNumber));
set(handles.KmiText,'String',Kmi(studyNumber));
set(handles.KmInfText,'String',KmInf(studyNumber));
set(handles.kText,'String',k(studyNumber));
save (handles.filename,'dDAR','dDARtau','DARss','Taur','m','Xr','Vmax','Kmi','dKm','KmInf','k','dur','studyNumber','numPerStudy','Data','filename','stimTI','simtime1', 'simtime2');
%updateAll(handles);


%%%% Button Callbacks %%%%%%%%
% --- Executes on button press in SimulateButton.
function SimulateButton_Callback(hObject, eventdata, handles)
simulate(handles);

function saveStimButton_Callback(hObject, eventdata, handles)
saveVariables(handles);
function exportbutton_Callback(hObject, eventdata, handles)
% hObject    handle to exportbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
load (handles.filename);
T = table(dDAR', dDARtau', DARss',Taur', m', Xr',Kmi', dKm', KmInf', k', Vmax');
T.Properties.VariableNames{'Var1'} = 'dDAR';
T.Properties.VariableNames{'Var2'} = 'dDARtau';
T.Properties.VariableNames{'Var3'} = 'DARss';
T.Properties.VariableNames{'Var4'} = 'TauR';
T.Properties.VariableNames{'Var5'} = 'm';
T.Properties.VariableNames{'Var6'} = 'Xr';
T.Properties.VariableNames{'Var7'} = 'Kmi';
T.Properties.VariableNames{'Var8'} = 'dKm';
T.Properties.VariableNames{'Var9'} = 'KmInf';
T.Properties.VariableNames{'Var10'} = 'k';
T.Properties.VariableNames{'Var11'} = 'Vmax';
writetable(T,handles.savetext.String,'delimiter', ' ');
% --- Executes on button press in loadStimButton.
function loadStimButton_Callback(hObject, eventdata, handles)
changeStim(handles);


%%%% text callbacks %%%%%%
function dDARtauText_Callback(hObject, eventdata, handles)
simulate(handles);
function dDARText_Callback(hObject, eventdata, handles)
simulate(handles);
function DARssText_Callback(hObject, eventdata, handles)
simulate(handles);
function TauRText_Callback(hObject, eventdata, handles)
simulate(handles);
function XrText_Callback(hObject, eventdata, handles)
simulate(handles);
function dKmText_Callback(hObject, eventdata, handles)
simulate(handles);
function kText_Callback(hObject, eventdata, handles)
simulate(handles);
function mText_Callback(hObject, eventdata, handles)
simulate(handles);
function KmInfText_Callback(hObject, eventdata, handles)
simulate(handles);
function KmiText_Callback(hObject, eventdata, handles)
simulate(handles);
function VmaxText_Callback(hObject, eventdata, handles)
simulate(handles);
function studyNumText_Callback(hObject, eventdata, handles)
function savetext_Callback(hObject, eventdata, handles)
%changeStim(handles);
function stimNumText_Callback(hObject, eventdata, handles)
function durationText_Callback(hObject, eventdata, handles)
simulate(handles);

% --- Executes on button press in pushbutton3.
function pushbutton3_Callback(hObject, eventdata, handles)


%%%% createfcn %%%%
% --- Executes during object creation, after setting all properties.
function dDARtauText_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% --- Executes during object creation, after setting all properties.
function dDARText_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% --- Executes during object creation, after setting all properties.
function DARssText_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% --- Executes during object creation, after setting all properties.
function TauRText_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% --- Executes during object creation, after setting all properties.
function XrText_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% --- Executes during object creation, after setting all properties.
function dKmText_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% --- Executes during object creation, after setting all properties.
function kText_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% --- Executes during object creation, after setting all properties.
function mText_CreateFcn(hObject, eventdata, handles)
% hObject    handle to mText (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% --- Executes during object creation, after setting all properties.
function KmInfText_CreateFcn(hObject, eventdata, handles)
% hObject    handle to KmInfText (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% --- Executes during object creation, after setting all properties.
function KmiText_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% --- Executes during object creation, after setting all properties.
function VmaxText_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function studyNumText_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% --- Executes during object creation, after setting all properties.
function savetext_CreateFcn(hObject, eventdata, handles)
% hObject    handle to savetext (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% --- Executes during object creation, after setting all properties.
% --- Executes during object creation, after setting all properties.
function stimNumText_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
% --- Executes during object creation, after setting all properties.
function durationText_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function SimulateButton_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SimulateButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
