# Written by Bence Paul based on genfind.py by Spencer Rathbun
#
# This script copies all the .csv files in the src directory into a destination directory ("dst").
# Both src and dst must exist before running the script 



import os
import shutil
import fnmatch
from Tkinter import Tk
from tkFileDialog import askdirectory
from sys import exit

#Function, called below, to return the os path for files that match the filepattern (e.g. ".csv")
def gen_find(filepat,top):
    for path, dirlist, filelist in os.walk(top):
        for name in fnmatch.filter(filelist,filepat):
            yield os.path.join(path,name)


#This is the function that runs when called from the terminal
#It begins by asking for the src directory, then the dst directory, then does the copy from src to dst
if __name__ == '__main__':

    Tk().withdraw() # we don't want a full GUI, so keep the root window from appearing
    dataDir = askdirectory() # show an "Open" dialog box and return the path to the selected folder
    if not dataDir:
        exit()
    else:
        src = dataDir

    dataDir = askdirectory()
    if not dataDir:
        exit()
    else:
        dst = dataDir


    #src = 'C:\Agilent\ICPMH\Data\Dominic\20150918_Erica\20150918_Stds1.b' # input
    #dst = 'C:\Agilent\ICPMH\Data\Dominic\20150918_Erica\ExtractedFiles\Stds1' # desired     location
    
    #check that both paths exist:
    if not os.path.exists(src):
    	print "Source path does not exist: " + src
    elif not os.path.exists(dst):
    	print "Destination path does not exist: " + dst
    else:
        filesToMove = gen_find("*.csv",src)
        for name in filesToMove:
                print "Copying: \r" + name
                shutil.copy(name, dst)
