% Vessel Wall Detection using intensity gradient
% Last modified 28 April 2016 

function wall = findVW(Iinfo,lastFrame)
dir = Iinfo;
last = lastFrame;
h = waitbar(0,'Finding vessel walls...');

for n=1:1:last
    waitbar(n/last);
    filename = strcat(num2str(n),'.bmp'); % Width of source image must be an even number!
    I = imread(strcat(dir,'\',filename),'bmp');
    I = im2single(I);
    I = imadjust(I);
    I = medfilt2(I,[1,1]); %default [3,3]
    
    if n==1
        Isize = size(I);
        y = 1:1:length(I); % y-domain
        center = round(Isize(2)/2);
        window_start = 18;
        window_end = 35;
        PositionVWL = zeros(last,Isize(1));
        PositionVWR = zeros(last,Isize(1));
        PositionVWa = zeros(2,Isize(1));
    end
    
    % divides figure into left and right
    IL = imcrop(I, [1, 1, center, Isize(1)]);
    IR = imcrop(I, [center, 1, Isize(2), Isize(1)]);
    
    if n == 1
        ILsize = size(IL);
        IRsize = size(IR);
    end
    
    for j = 1:ILsize(1) %left half
        k = 0;  %number of peaks for each row
        peak = zeros(30,1); % locate peak by recording i coordinate for each row
        if j<335
            window_start = 17;
        else
            window_start = 22;
        end
        for i = window_start:window_end % can also reduce window size to 30-60
            % finding sharp peak /\
            if IL(j,i) > IL(j,i-1) % if higher than previous point "/"
                if IL(j,i) >= IL(j,i+1) % if higher than next point "/\" or "/--"
                    k = k+1;
                    peak(k,1) = i;
                end
            end
        end
        
        if j == 1   % at top row of image
            if k == 0 && n == 1
                figure
                imshow(IL)
                hold on
                line = window_start*ones(ILsize(1),1);
                line2 = window_end*ones(ILsize(1),1);
                plot(line,y,'b--')
                hold on
                plot(line2,y,'b--')
                hold off
                
                PositionVWL(n,1) = str2double(inputdlg('Enter Wall position:','Wall node on first row to be defined',1));
            elseif k == 0 && n > 1
                PositionVWL(n,1) = PositionVWL(n-1,1);
                
            elseif k == 1   % if only 1 peak exist, assign wall node to the only existing peak
                PositionVWL(n,j) = peak(k,1)-1;
            elseif k>1
                peak1 = 0.1;    % arbituary maximum intensity for peak
                for m = 1:k     % else if more than 1 peak, search through all peaks
                    if IL(j,peak(m,1)) > peak1
                        peak1 = IL(j,peak(m,1));
                        mm = m;
                    end
                end
                PositionVWL(n,j) = peak(mm,1)-1; % assign wall node to before highest peak
            end
            
        elseif j>1
            diff = 35;
            peakPrevious = PositionVWL(n,j-1)+1; % find mean wall position from rows above
            for m = 1:k % search through all peaks
                diff_temp = abs(peak(m,1)-peakPrevious); %take nearest to MEAN wall position
                if diff_temp < diff
                    diff = diff_temp;
                    PositionVWL(n,j) = peak(m,1)-1;
                end
            end
        end
    end
    
    window_start = 15;
    IR = fliplr(IR); %right half
    for j = 1:IRsize(1)
        k = 0;
        peak = zeros(30,1);
        %
        for i = window_start:window_end%can also reduce window size to 30-60
            % finding sharp peak /\
            if IR(j,i) > IR(j,i-1) % if higher than previous point "/"
                if IR(j,i) >= IR(j,i+1) % if higher than next point "/\" or "/-"
                    k = k+1;
                    peak(k,1) = i;
                end
            end
        end
        
        if j == 1
            if k == 0 && n == 1
                figure
                imshow(IR)
                hold on
                line = window_start*ones(ILsize(1),1);
                line2 = window_end*ones(ILsize(1),1);
                plot(line,y,'b--')
                hold on
                plot(line2,y,'b--')
                hold off
                PositionVWR(n,1) = inputdlg('Enter Wall position:','Wall node on first row to be defined',1);
            elseif k == 0 && n > 1
                PositionVWR(n,1) = PositionVWR(n-1,1);
                
            elseif k == 1
                PositionVWR(n,j) = peak(k,1)-1;
            elseif k>1
                peak1 = 0.1;    % arbituary maximum intensity for peak
                for m = 1:k     % else if more than 1 peak, search through all peaks
                    if IR(j,peak(m,1)) > peak1
                        peak1 = IR(j,peak(m,1));
                        mm = m;
                    end
                end
                PositionVWR(n,j) = peak(mm,1)-1; % assign wall node to before highest peak
            end
            
        elseif j>1
            diff = 35;
            peakPrevious = PositionVWR(n,j-1);
            for m = 1:k % search through total number of peak
                diff_temp = abs(peak(m,1)-peakPrevious);
                if diff_temp < diff
                    diff = diff_temp;
                    PositionVWR(n,j) = peak(m,1)-1;
                end
            end
        end
    end
    
end
close(h)

PositionVWa(1,:) = mean(PositionVWL(1:last,:));
PositionVWa(2,:) = Isize(2)-mean(PositionVWR(1:last,:));

% Start filtering algorithm
PositionVWTemp = PositionVWa;
for j=1:2
    for i = 3:Isize(1)-3
        PositionVWa(j,1)=(-1*PositionVWTemp(j,Isize(1)-1)+4*PositionVWTemp(j,Isize(1))+...
            10*PositionVWTemp(j,1)+4*PositionVWTemp(j,2)-1*PositionVWTemp(j,3))/16;
        PositionVWa(j,2)=(-1*PositionVWTemp(j,Isize(1))+4*PositionVWTemp(j,1)+...
            10*PositionVWTemp(j,2)+4*PositionVWTemp(j,3)-1*PositionVWTemp(j,4))/16;
        PositionVWa(j,i)=(-1*PositionVWTemp(j,i-2)+4*PositionVWTemp(j,i-1)+...
            10*PositionVWTemp(j,i)+4*PositionVWTemp(j,i+1)-1*PositionVWTemp(j,i+2))/16;
        PositionVWa(j,Isize(1)-1)=(-1*PositionVWTemp(j,Isize(1)-3)+4*PositionVWTemp(j,Isize(1)-2)+...
            10*PositionVWTemp(j,Isize(1)-1)+4*PositionVWTemp(j,Isize(1))-1*PositionVWTemp(j,1))/16;
        PositionVWa(j,Isize(1))=(-1*PositionVWTemp(j,Isize(1)-2)+4*PositionVWTemp(j,Isize(1)-1)+...
            10*PositionVWTemp(j,Isize(1))+4*PositionVWTemp(j,1)-1*PositionVWTemp(j,2))/16;
    end
end
% End of filtering algorithm
%}
wall.L = PositionVWa(1,:);
wall.R = PositionVWa(2,:);
wall.height = 1:1:length(I);

end