function varargout = CFL_pre(varargin)
% CFL_PRE MATLAB code for CFL_pre.fig
%      CFL_PRE, by itself, creates a new CFL_PRE or raises the existing
%      singleton*.
%
%      H = CFL_PRE returns the handle to a new CFL_PRE or the handle to
%      the existing singleton*.
%
%      CFL_PRE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in CFL_PRE.M with the given input arguments.
%
%      CFL_PRE('Property','Value',...) creates a new CFL_PRE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before CFL_pre_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to CFL_pre_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help CFL_pre

% Last Modified by GUIDE v2.5 27-Apr-2016 14:56:21

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @CFL_pre_OpeningFcn, ...
    'gui_OutputFcn',  @CFL_pre_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before CFL_pre is made visible.
function CFL_pre_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to CFL_pre (see VARARGIN)

% Choose default command line output for CFL_pre
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes CFL_pre wait for user response (see UIRESUME)
% uiwait(handles.figure1);
clc
handles.gridspacing = 10;
handles.gridFlag = 0;
handles.roiFlag = 0;
handles.angle = 0;
handles.zoomLevel = 0;
handles.openfileFlag = 0;
guidata(hObject, handles);
axes(handles.axes1); %select the axes
axis off;
set(handles.gridButton, 'Enable', 'off');
set(handles.grid_no, 'Enable', 'off');
set(handles.zoomSlider, 'Enable','off');
set(handles.rotationSlider, 'Enable','off');
set(handles.rotationButton, 'Enable','off');
set(handles.roiButton, 'Enable','off');
set(handles.resetButton, 'Enable', 'off');
set(handles.extractButton,'Enable','off');
set(handles.confirmButton, 'Enable','off');

set(handles.zoomSlider,'Units','Points');
set(handles.zoomSlider,'Value',1);
set(handles.zoomSlider,'Min',1);
set(handles.zoomSlider,'Max',10);
set(handles.zoomSlider,'SliderStep',[1/9,1/9]);

set(handles.rotationSlider,'Min',-90);
set(handles.rotationSlider,'Max',90);
set(handles.rotationSlider,'Value',0);
set(handles.rotationSlider,'SliderStep',[1,1]./1800);

% --- Outputs from this function are returned to the command line.
function varargout = CFL_pre_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% --- Executes on button press in openfileButton.
function openfileButton_Callback(hObject, eventdata, handles)
% hObject    handle to openfileButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[fileName, pathName] = uigetfile('*.avi', 'Open Uncompress AVI video');

if isequal(handles.openfileFlag,1)
    handles=resetFn(handles);
end

if fileName ~= 0
    vidObj = VideoReader(strcat(pathName,fileName));    
    handles.pathName = pathName;
    handles.fileName = fileName;
    I = readFrame(vidObj);
    handles.imageWidth = vidObj.Width;
    handles.imageHeight = vidObj.Height;
    axes(handles.axes1);
    imshow(I)
    handles.I = I;
    handles.J = I;
    set(handles.roiButton, 'Enable','off');
    set(handles.gridButton, 'Enable', 'on');
    set(handles.grid_no, 'Enable', 'on');
    set(handles.rotationButton, 'Enable', 'on');
    set(handles.rotationButton, 'Value', 1);
    set(handles.rotationSlider, 'Enable', 'on');
    set(handles.zoomSlider, 'Enable','on');
    set(handles.resetButton, 'Enable', 'on');
    set(handles.confirmButton, 'Enable','on');
    set(handles.text3,'String',fileName);
    handles.openfileFlag = 1;
    guidata(hObject, handles);
end


% --- Executes on button press in gridButton.
function gridButton_Callback(hObject, eventdata, handles)
% hObject    handle to gridButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Hint: get(hObject,'Value') returns toggle state of gridButton
handles.gridFlag = get(hObject,'Value');
axes(handles.axes1); %select the axes
if isequal(handles.gridFlag,1)
    grid_on(handles);
    %zoom(handles.zoomLevel);
else
    imshow(handles.I)
    zoom(handles.zoomLevel);
end
guidata(hObject, handles);

function grid_on(handles)
[r,c] = size(handles.I);
n = handles.gridspacing; %total number of grid
gsr = round(r/n); %grid spacing
gsc = round(c/n); %grid spacing
hold on
for k = 1:gsr:r
    x = [1 c];
    y = [k k];
    plot(x,y,'Color','r','LineStyle','-');
end
for k = 1:gsc:c
    x = [k k];
    y = [1 r];
    plot(x,y,'Color','r','LineStyle','-');
end
hold off


function grid_no_Callback(hObject, eventdata, handles)
% hObject    handle to grid_no (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of grid_no as text
%        str2double(get(hObject,'String')) returns contents of grid_no as a double
handles.gridspacing = str2double(get(hObject,'String'));
if isequal(handles.gridFlag,0)
    imshow(handles.I)
    grid_on(handles);
    zoom(handles.zoomLevel);
    set(handles.gridButton,'Value',1);
else
    imshow(handles.I)
    grid_on(handles);
    zoom(handles.zoomLevel);
end


guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function grid_no_CreateFcn(hObject, eventdata, handles)
% hObject    handle to grid_no (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on slider movement.
function zoomSlider_Callback(hObject, eventdata, handles)
% hObject    handle to zoomSlider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
zoom out
handles.zoomLevel = get(hObject,'Value');
imshow(handles.I);
zoom(handles.zoomLevel);
if isequal(handles.gridFlag ,1)
    grid_on(handles);
end

guidata(hObject,handles);


% --- Executes during object creation, after setting all properties.
function zoomSlider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to zoomSlider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function rotationSlider_Callback(hObject, eventdata, handles)
% hObject    handle to rotationSlider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
angle = get(hObject,'Value');
I = imrotate(handles.J,angle,'bilinear');
imshow(I);
zoom(handles.zoomLevel);
handles.I = I;

if isequal(handles.gridFlag ,1)
    grid_on(handles);
end
set(handles.text2,'String',num2str(angle,'%.1f'));
handles.angle = angle;

guidata(hObject,handles);


% --- Executes during object creation, after setting all properties.
function rotationSlider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to rotationSlider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on button press in rotationButton.
function rotationButton_Callback(hObject, eventdata, handles)
% hObject    handle to rotationButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Hint: get(hObject,'Value') returns toggle state of rotationButton
if isequal(get(hObject,'Value'),1)
    set(handles.rotationSlider, 'Enable','on');
else
    set(handles.rotationSlider, 'Enable','off');
end
guidata(hObject,handles);


% --- Executes on button press in resetButton.
function resetButton_Callback(hObject, eventdata, handles)
% hObject    handle to resetButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles = resetFn(handles);
guidata(hObject,handles);

function handles = resetFn(handles)
imshow(handles.J);
set(handles.rotationSlider,'Value',0);
set(handles.zoomSlider,'Value',1);
set(handles.gridButton,'Value',0);
set(handles.text2,'String',num2str(0.0,'%.1f'));
set(handles.extractButton, 'Enable','off');
set(handles.roiButton, 'Enable','off');
set(handles.confirmButton, 'Enable', 'on');

set(handles.gridButton, 'Enable', 'on');
set(handles.grid_no, 'Enable', 'on');
set(handles.rotationButton, 'Enable', 'on');
set(handles.zoomSlider, 'Enable','on');
set(handles.rotationSlider, 'Enable','on');

handles.angle = 0;
handles.I = handles.J;
handles.gridspacing = 10;
handles.gridFlag = 0;
handles.zoomLevel = 0;
handles.roiFlag = 0;



% --- Executes on button press in roiButton.
function roiButton_Callback(hObject, eventdata, handles)
% hObject    handle to roiButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
rect = [0 0 0 0];
handles.roiFlag = 0;

% temp_x = round(handles.imageWidth/2);
% temp_y = round(handles.imageHeight/2);
[r,c] = size(handles.I);
temp_x = round(c/2);
temp_y = round(r/2);
fh = figure('MenuBar','none');
figure(fh)
imshow(handles.I);
title('Double click to confirm the ROI');
roih = imrect(gca,[1,1,temp_x,temp_y]); %roi handle
fcn = makeConstrainToRectFcn('imellipse',get(gca,'XLim'),get(gca,'YLim'));
setPositionConstraintFcn(roih,fcn);
rect = wait(roih);
if sum(rect) ~= 0
    btn = questdlg('Confrim the ROI','','Confirm','No','No');
    switch btn
        case 'Confirm'
            axes(handles.axes1)
            imshow(handles.I)
            rectangle('Position',rect,'EdgeColor','r');
            close(fh);
            set(handles.extractButton, 'Enable','on');
            set(handles.roiButton, 'Enable','off');
            set(handles.confirmButton, 'Enable','off');
            handles.roiFlag = 1;
        case 'No'
            close(fh);
            set(handles.extractButton, 'Enable','off');
    end
end
handles.roi = rect;
guidata(hObject,handles);

% --- Executes on button press in confirmButton.
function confirmButton_Callback(hObject, eventdata, handles)
% hObject    handle to confirmButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
choice = questdlg('Confirm the editing','','Confirm','No','No');
switch choice
    case'Confirm'
        imshow(handles.I)
        zoom(handles.zoomLevel);
        set(handles.gridButton, 'Enable', 'off');
        set(handles.grid_no, 'Enable', 'off');        
        set(handles.zoomSlider, 'Enable','off');
        set(handles.rotationSlider, 'Enable','off');
        set(handles.rotationButton, 'Enable','off');
        set(handles.roiButton, 'Enable','on');        
        set(handles.extractButton, 'Enable','on');        
    case 'No'
        set(handles.gridButton, 'Enable', 'on');
        set(handles.grid_no, 'Enable', 'on');
        set(handles.rotationButton, 'Enable', 'on');
        set(handles.zoomSlider, 'Enable','on');        
        set(handles.rotationSlider, 'Enable','on');
        set(handles.roiButton, 'Enable','off');
        set(handles.extractButton, 'Enable','off');
end

% --- Executes on button press in extractButton.
function extractButton_Callback(hObject, eventdata, handles)
% hObject    handle to extractButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
pathName = handles.pathName;
fileName = handles.fileName;
imDir = strcat(pathName,fileName(1:end-4));
temp = exist(imDir,'dir');
if isequal(temp,0)
    mkdir(imDir);    
else
    rmdir(imDir,'s');
    mkdir(imDir);
end

wh = waitbar(0,'Extracting images');
vidObj = VideoReader([pathName,fileName]);
totalFrames = vidObj.Duration*vidObj.FrameRate;
n=1;
while hasFrame(vidObj)
    waitbar(n/totalFrames);
    I = readFrame(vidObj);    
    if handles.angle ~= 0
        I = imrotate(I, handles.angle,'bilinear');        
    end    
    if isequal(handles.roiFlag,1)        
        I = imcrop(I,handles.roi);
    end    
    im_name = strcat(imDir,'\',num2str(n),'.bmp');    
    imwrite(I,im_name,'bmp');
    n = n + 1;
end
close(wh)
set(handles.gridButton, 'Enable', 'off');
set(handles.grid_no, 'Enable', 'off');
set(handles.rotationButton, 'Enable', 'off');
set(handles.zoomSlider, 'Enable','off');
set(handles.rotationSlider, 'Enable','off');
set(handles.resetButton, 'Enable', 'off');
set(handles.extractButton, 'Enable', 'off');
set(handles.roiButton, 'Enable', 'off');
set(handles.openfileButton, 'Enable', 'off');
set(handles.confirmButton, 'Enable', 'off');
