function varargout = CFL_measure(varargin)
% CFL_MEASURE M-file for CFL_measure.fig
%      CFL_MEASURE, by itself, creates a new CFL_MEASURE or raises the existing
%      singleton*.
%
%      H = CFL_MEASURE returns the handle to a new CFL_MEASURE or the handle to
%      the existing singleton*.
%
%      CFL_MEASURE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in CFL_MEASURE.M with the given input arguments.
%
%      CFL_MEASURE('Property','Value',...) creates a new CFL_MEASURE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Manual_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to CFL_measure_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help CFL_measure

% Last Modified by GUIDE v2.5 29-Apr-2016 11:43:17

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @CFL_measure_OpeningFcn, ...
    'gui_OutputFcn',  @CFL_measure_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CFL_measure_OpeningFcn(hObject, eventdata, handles, varargin)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to CFL_measure (see VARARGIN)

clc
handles.leftLevel = 0;
handles.AutoContr = 0; %auto image contrast
handles.med = 0; % median filter for image
handles.spatiotemporal = 0; %counter for spatial measurement
handles.vwFlag = 0;
handles.threshFlag = 0;
handles.sliderLineFlag = 0;

axes(handles.axes1); %select the axes
axis off;
axes(handles.axes2); %select the axes
axis off;
axes(handles.axes5); %select the axes
axis off; %remove the axis tick marks
axes(handles.axes6); %select the axes
axis off; %remove the axis tick marks

set(handles.sliderThresh, 'Enable','off');
set(handles.sliderLine, 'Enable','off');
set(handles.calculateButton, 'Enable','off');
set(handles.AutoCon, 'Enable','off');
set(handles.medFil, 'Enable','off');
set(handles.VW, 'Enable','off');

set(handles.ManualThresh, 'Enable','off');
set(handles.AutoThresh, 'Enable','off');
set(handles.SpatialVar, 'Enable','off');
set(handles.TempVar, 'Enable','off');
set(handles.ThreshAlgo, 'Enable','off');
set(handles.calculateButton, 'Enable','off');
set(handles.PixRes, 'Enable','off');
set(handles.FrameRate, 'Enable','off');
set(handles.StartFrame, 'Enable','off');
set(handles.LastFrame, 'Enable','off');
set(handles.exportButton, 'Enable','off');
set(handles.FrameSelect, 'Enable','off');
% Choose default command line output for CFL_measure
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes CFL_measure wait for user response (see UIRESUME)
% uiwait(handles.CFL_measure);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function sliderThresh_Callback(hObject, eventdata, handles)  %Left Slider
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if isequal(handles.vwFlag,0)
    msgbox('Determine vessel wall')
else
    %obtains the slider value from the slider component
    sliderValue = floor(get(handles.sliderThresh,'Value')); %get int value
    %puts the slider value into the edit text component
    set(handles.left_thres,'String',num2str(sliderValue));    
    handles.leftLevel = sliderValue;
    level = sliderValue/255; %threshold level
    handles.level = level;
    handles.BW = im2bw(handles.Ishow, level);    
    for i = 1:length(handles.wall.height)
        handles.BW(i,1:round(handles.wall.L(i)))=1;
        handles.BW(i,round(handles.wall.R(i)):end)=1;
    end    
    handles.BW = ~handles.BW;
    handles.BW = bwareaopen(handles.BW, 50);
    handles.BW = ~handles.BW;    
    for t=1:2
        handles.BW = imfill(handles.BW,'holes');
        handles.BW = ~handles.BW;
    end            
    
    axes(handles.axes1);
    imshow(handles.Ishow);
    hold on;
    plot(handles.wall.L,handles.wall.height,'k','LineWidth',1)
    plot(handles.wall.R,handles.wall.height,'k','LineWidth',1)    
    [B,L,N] = bwboundaries(handles.BW);
    for k=1:length(B),
        boundary = B{k};
        if(k > N)
            plot(boundary(:,2),boundary(:,1),'g','LineWidth',1);
        else
            plot(boundary(:,2),boundary(:,1),'k','LineWidth',1);
        end
    end
    hold off                  
    axes(handles.axes2); %select the axes
    axis off; %remove the axis tick marks
    imshow(handles.BW); %final image show
    hold on
    plot(handles.wall.L,handles.wall.height,'k','LineWidth',1)
    plot(handles.wall.R,handles.wall.height,'k','LineWidth',1)
    axes(handles.axes5);
    imhist(handles.Ishow); %show gray level histogram
    hold on
    line([sliderValue sliderValue], [0,max(imhist(handles.Ishow))],'Color','r','LineWidth',2)
    hold off
    handles.threshFlag = 1;
    set(handles.exportButton,'Enable','off');
end
guidata(hObject, handles);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function selectfolderButton_Callback(hObject, eventdata, handles)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
handles.temp = uigetdir;
if isequal(handles.temp,0)
    clc
    disp('Selection cancelled')
else
    Totframe = length(dir([handles.temp,'\*.bmp']));
    handles.totalFrame = Totframe;
    if Totframe >= 1
        numlist = 1:1:Totframe;
        set(handles.FrameSelect, 'Enable','on');
        set(handles.medFil,'Enable','on');
        set(handles.AutoCon,'Enable','on');
        set(handles.FrameSelect, 'String',strtrim(cellstr(num2str(numlist'))'));
        set(handles.FrameSelect, 'Value',1);        
        str = strcat(handles.temp,'\1.bmp');
        handles.I = imread(str);
        handles.Ishow = handles.I;
        handles.Iadj = imadjust(handles.I);
        handles.Imed = medfilt2(handles.I);
        handles.Iadjmed = imadjust(handles.Imed);
        handles.Imedadj = medfilt2(handles.Iadj);        
        
        axes(handles.axes1); %select the axes1
        imshow(handles.Ishow); %place image onto the axes
        axes(handles.axes5);
        imhist(handles.Ishow); %show gray level histogram
        set(handles.VW, 'Enable','on');        
    else
        str = ('Image does not exist!');
        msgbox(str);
    end        
    guidata(hObject,handles);
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function calculateButton_Callback(hObject, eventdata, handles)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if isequal(handles.threshFlag,0)
    msgbox('Determine the thresholding')
else        
    if isequal(get(handles.SpatialVar,'Value'),1)
            if isempty(get(handles.PixRes,'String'))
                msgbox('Enter Pixel Resolution!')
            else
                handles.cfl=zeros(2,length(handles.wall.height));
                for y = 1:length(handles.wall.height)
                    handles.cfl(1,y) = sum(handles.BW(y,round(handles.wall.L(y)):...
                        round(size(handles.BW,2)/2)))*handles.PixelResol;
                    handles.cfl(2,y) = sum(handles.BW(y,round(size(handles.BW,2)/2):...
                        round(handles.wall.R(y))))*handles.PixelResol;
                end
                axes(handles.axes6);
                plot(handles.wall.height.*handles.PixelResol,handles.cfl(1,:),'r')
                hold on
                plot(handles.wall.height.*handles.PixelResol,handles.cfl(2,:),'b')
                xlabel('Distance along vessel [\mum]')
                ylabel('CFL Width [\mum]')
                legend('Left','Right')
                hold off
                set(handles.exportButton, 'Enable','on');
            end
            
    else
            if isempty(get(handles.FrameRate,'String'))
                msgbox('Enter Frame Rate!')
            elseif isempty(get(handles.StartFrame,'String'))
                msgbox('Enter Start Frame!')
            elseif isempty(get(handles.LastFrame,'String'))
                msgbox('Enter Last Frame!')
            elseif isempty(get(handles.PixRes,'String'))
                msgbox('Enter Pixel Resolution!')
            else
                start = str2double(get(handles.StartFrame,'String'));
                lastframe = str2double(get(handles.LastFrame,'String'));
                y = floor(get(handles.sliderLine,'Value'));
                handles.cfl = zeros(2,lastframe-start+1);
                h = waitbar(0,'In Progress...');                
                for n = start:lastframe
                    waitbar(n/lastframe);
                    %load image
                    str = strcat(handles.temp,'\',num2str(n),'.bmp');
                    I = imread(str);                    
                    if isequal(get(handles.medFil,'Value'),1)
                        I = medfilt2(I);
                    end
                    if isequal(get(handles.AutoCon,'Value'),1)
                        I = imadjust(I);
                    end                                        
                    BW = im2bw(I,handles.level);
                    
                    %Remove holes and noises and artifacts
                    for i = 1:length(handles.wall.height)
                        BW(i,1:round(handles.wall.L(i)))=1;
                        BW(i,round(handles.wall.R(i)):end)=1;
                    end
                    BW = ~BW;
                    BW = bwareaopen(BW, 50);
                    BW = ~BW;
                    for t=1:2
                        BW = imfill(BW,'holes');
                        BW = ~BW;
                    end
                    %Count CFL temporal profile at analysis line y(white pixels)
                    handles.cfl(1,n) = sum(BW(y,round(handles.wall.L(y)):...
                        round(size(BW,2)/2)))*handles.PixelResol;
                    handles.cfl(2,n) = sum(BW(y,round(size(BW,2)/2):...
                        round(handles.wall.R(y))))*handles.PixelResol;
                end
                close(h)
                axes(handles.axes6);
                plot((1:lastframe)./handles.fps,handles.cfl(1,:),'r')
                hold on
                plot((1:lastframe)./handles.fps,handles.cfl(2,:),'b')
                xlabel('Time [s]')
                ylabel('CFL Width [\mum]')
                legend('Left','Right')
                hold off
                set(handles.exportButton, 'Enable','on');
            end
    end
end
guidata(hObject,handles);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% --- Executes during object creation, after setting all properties.
function left_thres_CreateFcn(hObject, eventdata, handles)
% hObject    handle to left_thres (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes during object creation, after setting all properties.
function Manual_CreateFcn(hObject, eventdata, handles)
% hObject    handle to CFL_measure (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes during object creation, after setting all properties.
function sliderThresh_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderThresh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end

% --- Outputs from this function are returned to the command line.
function varargout = CFL_measure_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% --- Executes during object creation, after setting all properties.
function axes1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to axes1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate axes1


% --- Executes during object deletion, before destroying properties.
function axes1_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to axes1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on selection change in ThreshAlgo (Auto thresholding).
function ThreshAlgo_Callback(hObject, eventdata, handles)
% hObject    handle to ThreshAlgo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Determine the selected data set.
val = get(hObject,'Value');
% Set current data to the selected data set.
handles.level = threshAlgo(handles.Ishow,val);
set(handles.sliderThresh,'Value',handles.level*255);
set(handles.left_thres,'String',num2str(handles.level*255));
drawnow;
handles.BW = im2bw(handles.Ishow,handles.level);
for i = 1:length(handles.wall.height)
    handles.BW(i,1:round(handles.wall.L(i))+1) = 1;
    handles.BW(i,round(handles.wall.R(i))-1:end) = 1;
end
handles.BW = ~handles.BW;
handles.BW = bwareaopen(handles.BW, 50);
handles.BW = ~handles.BW;
for t=1:2
    handles.BW = imfill(handles.BW,'holes');
    handles.BW = ~handles.BW;
end

axes(handles.axes2); %select the axes
imshow(handles.BW); %final image show
axis off; %remove the axis tick marks
hold on
plot(handles.wall.L,handles.wall.height,'k','LineWidth',1)
plot(handles.wall.R,handles.wall.height,'k','LineWidth',1)
if isequal(handles.sliderLineFlag,1)
    if isequal(get(handles.TempVar,'Value'),1)
    sliderValue = floor(get(handles.sliderLine,'Value')); %get int value
    plot(1:size(handles.BW,2),ones(1,size(handles.BW,2))*sliderValue,'b','LineWidth',2)
    end
end
hold off

axes(handles.axes1);
imshow(handles.Ishow);
hold on
plot(handles.wall.L,handles.wall.height,'k','LineWidth',1)
plot(handles.wall.R,handles.wall.height,'k','LineWidth',1)
[B,L,N] = bwboundaries(handles.BW);
for k=1:length(B),
    boundary = B{k};
    if(k > N)
        plot(boundary(:,2),boundary(:,1),'g','LineWidth',1);
    else
        plot(boundary(:,2),boundary(:,1),'k','LineWidth',1);
    end
end
if isequal(handles.sliderLineFlag,1)
    if isequal(get(handles.TempVar,'Value'),1)
    sliderValue = floor(get(handles.sliderLine,'Value')); %get int value
    plot(1:size(handles.BW,2),ones(1,size(handles.BW,2))*sliderValue,'b','LineWidth',2)
    end
end
hold off

axes(handles.axes5);
imhist(handles.Ishow); %show gray level histogram
hold on
line([handles.level*255 handles.level*255], [0,max(imhist(handles.Ishow))],'Color','r','LineWidth',2)
hold off
handles.threshFlag = 1;
set(handles.exportButton,'Enable','off');
guidata(hObject,handles)
% Hints: contents = cellstr(get(hObject,'String')) returns ThreshAlgo contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ThreshAlgo

% --- Executes during object creation, after setting all properties.
function ThreshAlgo_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ThreshAlgo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in AutoContr (Auto AutoContr).
function AutoCon_Callback(hObject, eventdata, handles)
% hObject    handle to AutoContr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if get(hObject,'Value')==1
    handles.AutoContr = 1;
    if handles.med == 1
        handles.Ishow = handles.Iadjmed;
    else
        handles.Ishow = handles.Iadj;
    end
else
    handles.AutoContr = 0;
    if handles.med == 1
        handles.Ishow = handles.Imed;
    else
        handles.Ishow = handles.I;
    end
end
axes(handles.axes1); %select the axes1
imshow(handles.Ishow); %place image onto the axes
hold on
if isequal(handles.vwFlag,1)
    plot(handles.wall.L,handles.wall.height,'k','LineWidth',1)
    plot(handles.wall.R,handles.wall.height,'k','LineWidth',1)
end
hold off
axes(handles.axes5); %analysis line display
imhist(handles.Ishow);
guidata(hObject,handles);
% Hint: get(hObject,'Value') returns toggle state of AutoContr


% --- Executes on button press in medFil (Median filter).
function medFil_Callback(hObject, eventdata, handles)
% hObject    handle to medFil (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if get(hObject,'Value')==1
    handles.med = 1;
    if handles.AutoContr == 1
        handles.Ishow = handles.Imedadj;
    else
        handles.Ishow = handles.Imed;
    end
else
    handles.med = 0;
    if handles.AutoContr == 1
        handles.Ishow = handles.Iadj;
    else
        handles.Ishow = handles.I;
    end
end
axes(handles.axes1); %select the axes1
imshow(handles.Ishow); %place image onto the axes
hold on
if isequal(handles.vwFlag,1)
    plot(handles.wall.L,handles.wall.height,'k','LineWidth',2)
    plot(handles.wall.R,handles.wall.height,'k','LineWidth',2)
end
hold off
axes(handles.axes5); %analysis line display
imhist(handles.Ishow);
guidata(hObject,handles);
% Hint: get(hObject,'Value') returns toggle state of medFil

% --- Executes on button press in VW (Show vessel wall).
function VW_Callback(hObject, eventdata, handles)
% hObject    handle to VW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if handles.totalFrame <= 700
    lastFrame = handles.totalFrame;
else
    lastFrame = 700;
end
handles.wall = findVW(handles.temp,lastFrame); %call recon image function
set(handles.sliderLine, 'min',1);
set(handles.sliderLine, 'Value',1);
set(handles.sliderLine, 'max',length(handles.wall.height));
set(handles.currentY,'String',['y: ','1']);    
axes(handles.axes1); %select the axes
imshow(handles.Ishow); %final image show
hold on
plot(handles.wall.L,handles.wall.height,'k','LineWidth',2)
plot(handles.wall.R,handles.wall.height,'k','LineWidth',2)
hold off
set(handles.ManualThresh, 'Enable','on');
set(handles.AutoThresh, 'Enable','on');
set(handles.AutoThresh, 'Value',1);
set(handles.ThreshAlgo, 'Enable','on');
set(handles.sliderThresh, 'Enable','off');
set(handles.PixRes, 'Enable','on');
set(handles.SpatialVar,'Value',1);
set(handles.SpatialVar, 'Enable','on');
set(handles.TempVar, 'Enable','on');
set(handles.AutoCon, 'Enable','on');
set(handles.medFil, 'Enable','on');
set(handles.calculateButton,'Enable','on');
handles.vwFlag = 1;
handles.threshFlag = 0;
cla (handles.axes2);
guidata(hObject,handles)


% --- Executes on button press in ManualThresh (CFL_measure).
function ManualThresh_Callback(hObject, eventdata, handles)
% hObject    handle to ManualThresh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Hint: get(hObject,'Value') returns toggle state of ManualThresh
set(handles.ManualThresh,'Value',1);
set(handles.AutoThresh,'Value',0);
set(handles.sliderThresh,'Enable','on');
set(handles.ThreshAlgo,'Enable','off');
set(handles.exportButton,'Enable','off');
guidata(hObject,handles)

% --- Executes on button press in AutoThresh (Auto).
function AutoThresh_Callback(hObject, eventdata, handles)
% hObject    handle to AutoThresh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Hint: get(hObject,'Value') returns toggle state of AutoThresh
set(handles.AutoThresh,'Value',1);
set(handles.ThreshAlgo,'Enable','on');
set(handles.sliderThresh,'Enable','off');
set(handles.ManualThresh,'Value',0);
set(handles.exportButton,'Enable','off');
guidata(hObject,handles)


function PixRes_Callback(hObject, eventdata, handles) %Pixel resolution
% hObject    handle to PixRes (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.PixelResol = str2double(get(hObject,'String'));

guidata(hObject,handles)
% Hints: get(hObject,'String') returns contents of PixRes as text
%        str2double(get(hObject,'String')) returns contents of PixRes as a double


% --- Executes during object creation, after setting all properties.
function PixRes_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PixRes (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function FrameRate_Callback(hObject, eventdata, handles) %frame rate
% hObject    handle to FrameRate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.fps = str2double(get(hObject,'String'));
guidata(hObject,handles)
% Hints: get(hObject,'String') returns contents of FrameRate as text
%        str2double(get(hObject,'String')) returns contents of FrameRate as a double


% --- Executes during object creation, after setting all properties.
function FrameRate_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FrameRate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in exportButton (save .csv).
function exportButton_Callback(hObject, eventdata, handles)
% hObject    handle to exportButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
methods = get(handles.SpatialVar,'Value');
if isequal(methods,1)
    currentFrame = get(handles.FrameSelect,'Value');
    fname = strcat('CFL_spatial_','frame_no_',num2str(currentFrame),'.csv');
    dlmwrite(fname,handles.cfl');
else
    lineY = num2str(floor(get(handles.sliderLine,'Value')));    
    fname = strcat('CFL_temporal_y',lineY,'_',...
         (get(handles.StartFrame,'String')),'-',...
         (get(handles.LastFrame,'String')),'_frames.csv');     
    dlmwrite(fname,handles.cfl');
end
set(handles.exportButton,'Enable','off');
guidata(hObject,handles)



function StartFrame_Callback(hObject, eventdata, handles)
% hObject    handle to StartFrame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of StartFrame as text
%        str2double(get(hObject,'String')) returns contents of StartFrame as a double
x = get(hObject,'String');
try
    y=x{1};
    z = str2num(strtok(y));    
catch
    z = str2num(strtok(x));
end
lower_limit = 1;
upper_limit = handles.totalFrame;
output = z*(z <= upper_limit)*(z >= lower_limit);
if isempty(output) || (~output)    
    output = lower_limit;    
    str = sprintf('Enter a number between %d and %d', lower_limit, upper_limit);
    msgbox(str);
end
set(hObject,'String',num2str(output)); 
guidata(hObject,handles)

% --- Executes during object creation, after setting all properties.
function StartFrame_CreateFcn(hObject, eventdata, handles)
% hObject    handle to StartFrame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function LastFrame_Callback(hObject, eventdata, handles)
% hObject    handle to LastFrame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of LastFrame as text
%        str2double(get(hObject,'String')) returns contents of LastFrame as a double

x = get(hObject,'String');
try
    y = x{1};
    z = str2num(strtok(y));    
catch
    z = str2num(strtok(x));
end
lower_limit = 1;
upper_limit = handles.totalFrame;
output = z*(z <= upper_limit)*(z >= lower_limit);
if isempty(output) || (~output)
      output = lower_limit*(z <= lower_limit) + upper_limit*(z >= upper_limit);
      if isempty(output)
          output = lower_limit;
      end
      str = sprintf('Enter a number between %d and %d', lower_limit, upper_limit);
      msgbox(str);
end
set(hObject,'String',num2str(output)); 
guidata(hObject,handles)



% --- Executes during object creation, after setting all properties.
function LastFrame_CreateFcn(hObject, eventdata, handles)
% hObject    handle to LastFrame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on slider movement.
function sliderLine_Callback(hObject, eventdata, handles)
% hObject    handle to sliderLine (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%obtains the slider value from the slider component
if isequal(handles.threshFlag,0)
    msgbox('Determine the thresholding')    
else
    handles.sliderLineFlag = 1;
    sliderValue = floor(get(handles.sliderLine,'Value')); %get int value
    set(handles.currentY,'String',['y: ',num2str(sliderValue)]);    
    axes(handles.axes1);
    imshow(handles.Ishow);
    hold on;
    plot(handles.wall.L,handles.wall.height,'k','LineWidth',1)
    plot(handles.wall.R,handles.wall.height,'k','LineWidth',1)
    hold on
    [B,L,N] = bwboundaries(handles.BW);
    for k=1:length(B),
        boundary = B{k};
        if(k > N)
            plot(boundary(:,2),boundary(:,1),'g','LineWidth',1);
        else
            plot(boundary(:,2),boundary(:,1),'k','LineWidth',1);
        end
    end
    plot(1:size(handles.BW,2),ones(1,size(handles.BW,2))*sliderValue,'b','LineWidth',2)
    hold off
    
    axes(handles.axes2); %select the axes
    imshow(handles.BW); %final image show
    hold on
    plot(handles.wall.L,handles.wall.height,'k','LineWidth',1)
    plot(handles.wall.R,handles.wall.height,'k','LineWidth',1)
    plot(1:size(handles.BW,2),ones(1,size(handles.BW,2))*sliderValue,'b','LineWidth',2)
    axis off; %remove the axis tick marks
    hold off
    guidata(hObject,handles)
end

%puts the slider value into the edit text component
% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.

function sliderLine_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderLine (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end

% --- Executes when selected object is changed in uipanel22.
function uipanel22_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in uipanel22
% eventdata  structure with the following fields (see UIBUTTONGROUP)
%	EventName: string 'SelectionChanged' (read only)
%	OldValue: handle of the previously selected object or empty if none was selected
%	NewValue: handle of the currently selected object
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on selection change in FrameSelect.
function FrameSelect_Callback(hObject, eventdata, handles)
% hObject    handle to FrameSelect (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
n = get(hObject,'Value');
str = strcat(handles.temp,'\',num2str(n),'.bmp');
handles.I = imread(str);
handles.Ishow = handles.I;
handles.Iadj = imadjust(handles.I);
handles.Imed = medfilt2(handles.I);
handles.Iadjmed = imadjust(handles.Imed);
handles.Imedadj = medfilt2(handles.Iadj);
cla (handles.axes2);
cla (handles.axes5);
cla (handles.axes6);
axes(handles.axes6);
axis off;
legend('off');

set(handles.medFil,'Value',0)
set(handles.AutoCon,'Value',0)
set(handles.AutoCon, 'Enable','on');
set(handles.medFil, 'Enable','on');
handles.AutoContr = 0;
handles.med = 0;
axes(handles.axes1); %select the axes1
imshow(handles.Ishow); %place image onto the axes
hold on
if isequal(handles.vwFlag,1)
    plot(handles.wall.L,handles.wall.height,'k','LineWidth',2)
    plot(handles.wall.R,handles.wall.height,'k','LineWidth',2)
end
hold off

axes(handles.axes5);
imhist(handles.Ishow); %show gray level histogram
handles.OtsuLevel = graythresh(handles.Ishow);
handles.BW = im2bw(handles.Ishow,handles.OtsuLevel);
handles.threshFlag = 0;
set(handles.VW, 'Enable','on');
set(handles.SpatialVar,'Value',1);
set(handles.exportButton, 'Enable','off');
guidata(hObject,handles);

% Hints: contents = cellstr(get(hObject,'String')) returns FrameSelect contents as cell array
%        contents{get(hObject,'Value')} returns selected item from FrameSelect


% --- Executes during object creation, after setting all properties.
function FrameSelect_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FrameSelect (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in SpatialVar.
function SpatialVar_Callback(hObject, eventdata, handles)
% hObject    handle to SpatialVar (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Hint: get(hObject,'Value') returns toggle state of SpatialVar
if isequal(handles.threshFlag,1)
    axes(handles.axes2); %select the axes
    imshow(handles.BW); %final image show
    axis off; %remove the axis tick marks
    hold on
    plot(handles.wall.L,handles.wall.height,'k','LineWidth',1)
    plot(handles.wall.R,handles.wall.height,'k','LineWidth',1)
    hold off
    
    axes(handles.axes1);
    imshow(handles.Ishow);
    hold on
    plot(handles.wall.L,handles.wall.height,'k','LineWidth',1)
    plot(handles.wall.R,handles.wall.height,'k','LineWidth',1)
    [B,L,N] = bwboundaries(handles.BW);
    for k=1:length(B),
        boundary = B{k};
        if(k > N)
            plot(boundary(:,2),boundary(:,1),'g','LineWidth',1);
        else
            plot(boundary(:,2),boundary(:,1),'k','LineWidth',1);
        end
    end
    hold off
end
set(handles.PixRes, 'Enable','on');
set(handles.sliderLine, 'Enable','off');
set(handles.FrameRate, 'Enable','off');
set(handles.StartFrame, 'Enable','off');
set(handles.LastFrame, 'Enable','off');
set(handles.exportButton,'Enable','off');
guidata(hObject,handles);




% --- Executes on button press in TempVar.
function TempVar_Callback(hObject, eventdata, handles)
% hObject    handle to TempVar (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of TempVar
if isequal(handles.threshFlag,1)
    axes(handles.axes2); %select the axes
    imshow(handles.BW); %final image show
    axis off; %remove the axis tick marks
    hold on
    plot(handles.wall.L,handles.wall.height,'k','LineWidth',1)
    plot(handles.wall.R,handles.wall.height,'k','LineWidth',1)
    if isequal(handles.sliderLineFlag,1)
        if isequal(get(handles.TempVar,'Value'),1)
            sliderValue = floor(get(handles.sliderLine,'Value')); %get int value
            plot(1:size(handles.BW,2),ones(1,size(handles.BW,2))*sliderValue,'b','LineWidth',2)
        end
    end
    hold off
    
    axes(handles.axes1);
    imshow(handles.Ishow);
    hold on
    plot(handles.wall.L,handles.wall.height,'k','LineWidth',1)
    plot(handles.wall.R,handles.wall.height,'k','LineWidth',1)
    [B,L,N] = bwboundaries(handles.BW);
    for k=1:length(B),
        boundary = B{k};
        if(k > N)
            plot(boundary(:,2),boundary(:,1),'g','LineWidth',1);
        else
            plot(boundary(:,2),boundary(:,1),'k','LineWidth',1);
        end
    end
    if isequal(handles.sliderLineFlag,1)
        if isequal(get(handles.TempVar,'Value'),1)
            sliderValue = floor(get(handles.sliderLine,'Value')); %get int value
            plot(1:size(handles.BW,2),ones(1,size(handles.BW,2))*sliderValue,'b','LineWidth',2)
        end
    end
    hold off
end
set(handles.PixRes, 'Enable','off');
set(handles.sliderLine, 'Enable','on');
set(handles.ThreshAlgo, 'Enable','on');
set(handles.FrameRate, 'Enable','on');
set(handles.StartFrame, 'Enable','on');
set(handles.LastFrame, 'Enable','on');
set(handles.exportButton,'Enable','off');
guidata(hObject,handles);
