% Name: generate_gratings.m
% Created 10/2015
%
% Description: Creates SIM binary gratings
%              
% Laurence Young <ljy24@cam.ac.uk>
rots      = [0 2*pi/3 4*pi/3];  % rotation
phases    = [0 2*pi/3 4*pi/3];  % phase shift
period    = 9;                  % period
duty      = 0.5;                % duty cycle   
mask      = true;               % apply circular mask?

width     = 1280;
height    = 1024;
fpath     = '.\period9\';

nImage = 0;
for rot = rots
    for phase = phases
        offset = period*phase/(2*pi);
        [x,y] = meshgrid(0:(width-1),0:(height-1));
        r = x.*cos(rot)-y.*sin(rot)+offset;
        r = r/period;
        m = mod(r,1);
        grating = m >= duty;

        if mask
            grating = circular_mask(grating,0.25,false);
        end

        grating = logical(grating);
        imwrite(grating,[fpath 'grating_' num2str(nImage,'%.3d') '.bmp'],'bmp');

        nImage = nImage + 1;
    end;
end;

