% Name: circular_mask.m
% Created 10/2015
%
% Description: Apply a circular mask 
% Params: 
%  data   - input matrix
%  ratio  - mask size
%  invert - invert mask?
%
% Laurence Young <ljy24@cam.ac.uk>
function [ masked ] = circular_mask(data, ratio, invert)
dims = size(data);
width = dims(1);
height = dims(2);
[W, H] = meshgrid(1:width,1:height);

if invert
    mask = sqrt((W-width/2-1).^2 + (H-height/2-1).^2) > ratio*width/2;
else
    mask = sqrt((W-width/2-1).^2 + (H-height/2-1).^2) < ratio*width/2;
end

masked = data .* mask';
end