function [postConv]=makeSeriesFromCoordinatesLMUdata(res,pixelsize,PSFSize,imsize,totim,frametime);


%load data from particle tracking 'res' and
%make image series from particles coordinates
%define the filter for convolution
if mod(ceil(PSFSize/pixelsize*6),2)==0
            filtersize = ceil(PSFSize/pixelsize*4)+1;
elseif mod(ceil(PSFSize/pixelsize*6),2)~=0 
            filtersize = ceil(PSFSize/pixelsize*4);
end


postConv=zeros(imsize,imsize,totim);




for i=1:totim %for every timestep
  indtime=find(round(res(:,7)/frametime)==i);
  xdiff=squeeze(res(indtime,1));
  ydiff=squeeze(res(indtime,2));

preConv=accumarray([ceil(ydiff),ceil(xdiff)],ones(1,length(xdiff))',[imsize,imsize]);
postConv(:,:,i)=convolveGaussian(preConv,filtersize,PSFSize/pixelsize);
clear xdiff ydiff
end


   
    

