function [barint,barrg,barcc,IdivRg]=findFeatureCharacter(image);

%Elvis Pandzic 2012
%this function loads image from series that one wants to track
%then user is prompted to select square containing 
%one of feautres to be tracked and caharcteristic 
%metrics are established...the output of this 
%function are loaded in 'mpretrack_init' 
%to be assessed if it picks all features of interest.



% barint - The minimum intensity you want to accept.
% barrg - The maximum Rg squared you want to accept.
% barcc - The maximum eccentricity you want to accept.
% IdivRg - minimum ratio of Intensity/pixel to be accepted (integrated
%           intensity / Rg squared of feature)

[crop,rect] = serimcropold(image);
mask=(crop>0.05*max(max(crop)));

%eccentricity estimate
ecce=regionprops(crop>0.05*max(max(crop)),'Eccentricity');
barcc=ecce.Eccentricity;

%Rg estimate
dg=regionprops(crop>0.05*max(max(crop)),'EquivDiameter');
barrg=dg.EquivDiameter/2;

%minimumintensity to accept
barint=0.05*max(max(crop));

%Integrated intensity / Rg
totint=sum(sum(mask.*double(crop)));
IdivRg=totint/barrg;