/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Shape;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Line
extends Shape {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/ROI/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Line.class);
    private Double y1;
    private Double x2;
    private Double x1;
    private Double y2;

    public Line() {
    }

    public Line(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Line".equals(tagName)) {
            LOGGER.debug("Expecting node name of Line got {}", (Object)tagName);
        }
        if (element.hasAttribute("Y1")) {
            this.setY1(Double.valueOf(element.getAttribute("Y1")));
        }
        if (element.hasAttribute("X2")) {
            this.setX2(Double.valueOf(element.getAttribute("X2")));
        }
        if (element.hasAttribute("X1")) {
            this.setX1(Double.valueOf(element.getAttribute("X1")));
        }
        if (element.hasAttribute("Y2")) {
            this.setY2(Double.valueOf(element.getAttribute("Y2")));
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public Double getY1() {
        return this.y1;
    }

    public void setY1(Double y1) {
        this.y1 = y1;
    }

    public Double getX2() {
        return this.x2;
    }

    public void setX2(Double x2) {
        this.x2 = x2;
    }

    public Double getX1() {
        return this.x1;
    }

    public void setX1(Double x1) {
        this.x1 = x1;
    }

    public Double getY2() {
        return this.y2;
    }

    public void setY2(Double y2) {
        this.y2 = y2;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element Line_element) {
        if (Line_element == null) {
            Line_element = document.createElementNS(NAMESPACE, "Line");
        }
        if (this.y1 != null) {
            Line_element.setAttribute("Y1", this.y1.toString());
        }
        if (this.x2 != null) {
            Line_element.setAttribute("X2", this.x2.toString());
        }
        if (this.x1 != null) {
            Line_element.setAttribute("X1", this.x1.toString());
        }
        if (this.y2 != null) {
            Line_element.setAttribute("Y2", this.y2.toString());
        }
        return super.asXMLElement(document, Line_element);
    }
}

