/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record.formula;

import loci.poi.hssf.model.Workbook;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.record.formula.Ptg;

public class ErrPtg
extends Ptg {
    public static final short sid = 28;
    private static final int SIZE = 7;
    private byte field_1_error_code;

    public ErrPtg() {
    }

    public ErrPtg(RecordInputStream in) {
        this.field_1_error_code = in.readByte();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(28 + this.ptgClass);
        array[offset + 1] = this.field_1_error_code;
    }

    public String toFormulaString(Workbook book) {
        switch (this.field_1_error_code) {
            case 0: {
                return "#NULL!";
            }
            case 7: {
                return "#DIV/0!";
            }
            case 15: {
                return "#VALUE!";
            }
            case 23: {
                return "#REF!";
            }
            case 29: {
                return "#NAME?";
            }
            case 36: {
                return "#NUM!";
            }
            case 42: {
                return "#N/A";
            }
        }
        return "#N/A";
    }

    public int getSize() {
        return 7;
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public Object clone() {
        ErrPtg ptg = new ErrPtg();
        ptg.field_1_error_code = this.field_1_error_code;
        return ptg;
    }
}

