/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.macro;

import ij.IJ;
import ij.macro.ExtensionDescriptor;
import ij.macro.Functions;
import ij.macro.MacroExtension;
import ij.plugin.PlugIn;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import loci.plugins.util.LibraryChecker;

public class MacroFunctions
implements PlugIn,
MacroExtension {
    protected ExtensionDescriptor[] extensions = this.buildExtensions();

    public void run(String arg) {
        if (!LibraryChecker.checkImageJ()) {
            return;
        }
        if (!IJ.macroRunning()) {
            IJ.error((String)"Cannot install extensions from outside a macro.");
            return;
        }
        Functions.registerExtensions((MacroExtension)this);
    }

    public ExtensionDescriptor[] getExtensionFunctions() {
        return this.extensions;
    }

    public String handleExtension(String name, Object[] args) {
        Class[] c = null;
        if (args != null) {
            c = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                c[i] = args[i].getClass();
            }
        }
        try {
            this.getClass().getMethod(name, c).invoke((Object)this, args);
        }
        catch (NoSuchMethodException exc) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            exc.printStackTrace(new PrintStream(out));
            IJ.error((String)new String(out.toByteArray()));
        }
        catch (IllegalAccessException exc) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            exc.printStackTrace(new PrintStream(out));
            IJ.error((String)new String(out.toByteArray()));
        }
        catch (InvocationTargetException exc) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            exc.printStackTrace(new PrintStream(out));
            IJ.error((String)new String(out.toByteArray()));
        }
        return null;
    }

    protected ExtensionDescriptor[] buildExtensions() {
        Method[] m = this.getClass().getMethods();
        ExtensionDescriptor[] desc = new ExtensionDescriptor[m.length];
        for (int i = 0; i < m.length; ++i) {
            Class<?>[] c = m[i].getParameterTypes();
            int[] types = new int[c.length];
            for (int j = 0; j < c.length; ++j) {
                if (c[j] == String.class) {
                    types[j] = 1;
                    continue;
                }
                if (c[j] == Double.class) {
                    types[j] = 2;
                    continue;
                }
                if (c[j] == Object[].class) {
                    types[j] = 4;
                    continue;
                }
                if (c[j] == String[].class) {
                    types[j] = 17;
                    continue;
                }
                if (c[j] != Double[].class) continue;
                types[j] = 18;
            }
            desc[i] = ExtensionDescriptor.newDescriptor((String)m[i].getName(), (MacroExtension)this, (int[])types);
        }
        return desc;
    }
}

