/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.IJ;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import loci.common.Location;
import loci.common.ReflectedUniverse;
import loci.common.Region;
import loci.common.StatusEvent;
import loci.common.StatusListener;
import loci.common.StatusReporter;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelFiller;
import loci.formats.ChannelSeparator;
import loci.formats.ClassList;
import loci.formats.DimensionSwapper;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MinMaxCalculator;
import loci.formats.TileStitcher;
import loci.formats.meta.IMetadata;
import loci.formats.services.OMEXMLService;
import loci.plugins.BF;
import loci.plugins.in.ImportStep;
import loci.plugins.in.ImporterMetadata;
import loci.plugins.in.ImporterOptions;
import loci.plugins.util.IJStatusEchoer;
import loci.plugins.util.ImageProcessorReader;
import loci.plugins.util.LociPrefs;
import loci.plugins.util.LuraWave;
import loci.plugins.util.VirtualReader;
import loci.plugins.util.WindowTools;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ImportProcess
implements StatusReporter {
    private List<StatusListener> listeners = new ArrayList<StatusListener>();
    private ImporterOptions options;
    private ImportStep step;
    private IFormatReader baseReader;
    private ImageReader imageReader;
    private FileStitcher fileStitcher;
    private ChannelFiller channelFiller;
    private ChannelSeparator channelSeparator;
    private DimensionSwapper dimensionSwapper;
    private MinMaxCalculator minMaxCalculator;
    private TileStitcher tileStitcher;
    private VirtualReader virtualReader;
    private ImageProcessorReader reader;
    private boolean cancel;
    protected String idName;
    protected Location idLoc;
    protected IMetadata meta;
    private ImporterMetadata metadata;
    private String[] seriesLabels;

    public ImportProcess() throws IOException {
        this(new ImporterOptions());
    }

    public ImportProcess(ImporterOptions options) {
        this.options = options;
    }

    public boolean execute() throws FormatException, IOException {
        this.step(ImportStep.READER);
        if (this.cancel) {
            return false;
        }
        this.initializeReader();
        this.step(ImportStep.FILE);
        if (this.cancel) {
            return false;
        }
        this.initializeFile();
        this.step(ImportStep.STACK);
        if (this.cancel) {
            return false;
        }
        this.initializeStack();
        this.step(ImportStep.SERIES);
        if (this.cancel) {
            return false;
        }
        this.initializeSeries();
        this.step(ImportStep.DIM_ORDER);
        if (this.cancel) {
            return false;
        }
        this.initializeDimOrder();
        this.step(ImportStep.RANGE);
        if (this.cancel) {
            return false;
        }
        this.initializeRange();
        this.step(ImportStep.CROP);
        if (this.cancel) {
            return false;
        }
        this.initializeCrop();
        this.step(ImportStep.COLORS);
        if (this.cancel) {
            return false;
        }
        this.initializeColors();
        this.step(ImportStep.METADATA);
        if (this.cancel) {
            return false;
        }
        this.initializeMetadata();
        this.step(ImportStep.COMPLETE);
        return true;
    }

    public void cancel() {
        this.cancel = true;
    }

    public boolean wasCanceled() {
        return this.cancel;
    }

    public ImporterOptions getOptions() {
        return this.options;
    }

    public boolean isWindowless() {
        if (this.options.isWindowless()) {
            return true;
        }
        return this.baseReader != null && LociPrefs.isWindowless(this.baseReader);
    }

    public void setSeriesList(String seriesList) {
        int seriesCount = this.getSeriesCount();
        this.options.clearSeries();
        seriesList = seriesList.replaceAll("[^\\d,\\-]", "");
        StringTokenizer st = new StringTokenizer(seriesList, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int dash = token.indexOf("-");
            if (dash < 0) {
                try {
                    int s = Integer.parseInt(token) - 1;
                    this.options.setSeriesOn(s, true);
                }
                catch (NumberFormatException exc) {}
                continue;
            }
            String firstString = token.substring(0, dash);
            String lastString = token.substring(dash + 1);
            try {
                int first = Integer.parseInt(firstString) - 1;
                int last = Integer.parseInt(lastString) - 1;
                for (int s = first; s <= last && s < seriesCount; ++s) {
                    this.options.setSeriesOn(s, true);
                }
            }
            catch (NumberFormatException exc) {
            }
        }
    }

    public IFormatReader getBaseReader() {
        this.assertStep(ImportStep.READER);
        return this.baseReader;
    }

    public ImageReader getImageReader() {
        this.assertStep(ImportStep.READER);
        return this.imageReader;
    }

    public String getIdName() {
        this.assertStep(ImportStep.READER);
        return this.idName;
    }

    public Location getIdLocation() {
        this.assertStep(ImportStep.READER);
        return this.idLoc;
    }

    public IMetadata getOMEMetadata() {
        this.assertStep(ImportStep.READER);
        return this.meta;
    }

    public FileStitcher getFileStitcher() {
        this.assertStep(ImportStep.STACK);
        return this.fileStitcher;
    }

    public ChannelFiller getChannelFiller() {
        this.assertStep(ImportStep.STACK);
        return this.channelFiller;
    }

    public ChannelSeparator getChannelSeparator() {
        this.assertStep(ImportStep.STACK);
        return this.channelSeparator;
    }

    public DimensionSwapper getDimensionSwapper() {
        this.assertStep(ImportStep.STACK);
        return this.dimensionSwapper;
    }

    public MinMaxCalculator getMinMaxCalculator() {
        this.assertStep(ImportStep.STACK);
        return this.minMaxCalculator;
    }

    public VirtualReader getVirtualReader() {
        this.assertStep(ImportStep.STACK);
        return this.virtualReader;
    }

    public ImageProcessorReader getReader() {
        this.assertStep(ImportStep.STACK);
        return this.reader;
    }

    public String getCurrentFile() {
        this.assertStep(ImportStep.STACK);
        return this.reader.getCurrentFile();
    }

    public int getSeriesCount() {
        this.assertStep(ImportStep.STACK);
        return this.getReader().getSeriesCount();
    }

    public String getSeriesLabel(int s) {
        this.assertStep(ImportStep.STACK);
        return this.seriesLabels[s];
    }

    public String getStackOrder() {
        this.assertStep(ImportStep.STACK);
        String stackOrder = this.options.getStackOrder();
        if (stackOrder == null || stackOrder.equals("Default")) {
            stackOrder = this.reader.getDimensionOrder();
        }
        return stackOrder;
    }

    public int getCBegin(int s) {
        return this.options.getCBegin(s);
    }

    public int getCEnd(int s) {
        this.assertStep(ImportStep.STACK);
        int cEnd = this.options.getCEnd(s);
        if (cEnd >= 0) {
            return cEnd;
        }
        this.reader.setSeries(s);
        return this.reader.getEffectiveSizeC() - 1;
    }

    public int getCStep(int s) {
        return this.options.getCStep(s);
    }

    public int getZBegin(int s) {
        return this.options.getZBegin(s);
    }

    public int getZEnd(int s) {
        this.assertStep(ImportStep.STACK);
        int zEnd = this.options.getZEnd(s);
        if (zEnd >= 0) {
            return zEnd;
        }
        this.reader.setSeries(s);
        return this.reader.getSizeZ() - 1;
    }

    public int getZStep(int s) {
        return this.options.getZStep(s);
    }

    public int getTBegin(int s) {
        return this.options.getTBegin(s);
    }

    public int getTEnd(int s) {
        this.assertStep(ImportStep.STACK);
        int tEnd = this.options.getTEnd(s);
        if (tEnd >= 0) {
            return tEnd;
        }
        this.reader.setSeries(s);
        return this.reader.getSizeT() - 1;
    }

    public int getTStep(int s) {
        return this.options.getTStep(s);
    }

    public Region getCropRegion(int s) {
        this.assertStep(ImportStep.STACK);
        Region region = this.options.doCrop() ? this.options.getCropRegion(s) : null;
        this.reader.setSeries(s);
        int sizeX = this.reader.getSizeX();
        int sizeY = this.reader.getSizeY();
        if (region == null) {
            region = new Region(0, 0, sizeX, sizeY);
        } else {
            if (region.x < 0) {
                region.x = 0;
            }
            if (region.y < 0) {
                region.y = 0;
            }
            if (region.width <= 0 || region.x + region.width > sizeX) {
                region.width = sizeX - region.x;
            }
            if (region.height <= 0 || region.y + region.height > sizeY) {
                region.height = sizeX - region.y;
            }
        }
        return region;
    }

    public int getCCount(int s) {
        this.assertStep(ImportStep.SERIES);
        if (!this.options.isSeriesOn(s)) {
            return 0;
        }
        return (this.getCEnd(s) - this.getCBegin(s) + this.getCStep(s)) / this.getCStep(s);
    }

    public int getZCount(int s) {
        this.assertStep(ImportStep.SERIES);
        if (!this.options.isSeriesOn(s)) {
            return 0;
        }
        return (this.getZEnd(s) - this.getZBegin(s) + this.getZStep(s)) / this.getZStep(s);
    }

    public int getTCount(int s) {
        this.assertStep(ImportStep.SERIES);
        if (!this.options.isSeriesOn(s)) {
            return 0;
        }
        return (this.getTEnd(s) - this.getTBegin(s) + this.getTStep(s)) / this.getTStep(s);
    }

    public long getMemoryUsage() {
        int seriesCount = this.getSeriesCount();
        long total = 0L;
        for (int s = 0; s < seriesCount; ++s) {
            if (!this.options.isSeriesOn(s)) continue;
            this.reader.setSeries(s);
            Region cropRegion = this.getCropRegion(s);
            int bpp = FormatTools.getBytesPerPixel(this.reader.getPixelType());
            long planeSize = bpp * cropRegion.width * cropRegion.height;
            int cCount = this.getCCount(s);
            int zCount = this.getZCount(s);
            int tCount = this.getTCount(s);
            long planeCount = cCount * zCount * tCount;
            boolean isVirtual = this.options.isVirtual();
            long activeChannels = this.options.isColorModeComposite() ? (long)cCount : 1L;
            long activePlanes = isVirtual ? activeChannels : planeCount;
            long seriesSize = planeSize * activePlanes;
            total += seriesSize;
        }
        return total;
    }

    public ImporterMetadata getOriginalMetadata() {
        this.assertStep(ImportStep.METADATA);
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(StatusListener l) {
        List<StatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusListener(StatusListener l) {
        List<StatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(StatusEvent e) {
        List<StatusListener> list = this.listeners;
        synchronized (list) {
            for (StatusListener l : this.listeners) {
                l.statusUpdated(e);
            }
        }
    }

    private void initializeReader() throws FormatException, IOException {
        this.computeNameAndLocation();
        this.createBaseReader();
    }

    private void initializeFile() throws FormatException, IOException {
        this.saveDefaults();
        BF.status(this.options.isQuiet(), "Analyzing " + this.getIdName());
        this.baseReader.setMetadataFiltered(true);
        this.baseReader.setOriginalMetadataPopulated(true);
        this.baseReader.setGroupFiles(!this.options.isUngroupFiles());
        this.baseReader.setId(this.options.getId());
    }

    private void initializeStack() throws FormatException, IOException {
        IFormatReader r = this.baseReader;
        if (this.options.isGroupFiles()) {
            this.fileStitcher = new FileStitcher(this.baseReader);
            r = this.fileStitcher;
            String id = this.options.getId();
            this.options.setId(id);
            this.fileStitcher.setUsingPatternIds(true);
            this.fileStitcher.setCanChangePattern(false);
        }
        r.setId(this.options.getId());
        if (this.options.isGroupFiles()) {
            this.options.setId(this.fileStitcher.getFilePattern().getPattern());
        }
        byte[][] lut8 = r.get8BitLookupTable();
        int sizeC = r.getSizeC();
        this.channelFiller = new ChannelFiller(r);
        r = this.channelFiller;
        if (sizeC == 1 && lut8 != null && lut8.length <= 3) {
            this.channelFiller.setFilled(false);
        }
        if (this.channelFiller.isFilled()) {
            BF.warn(this.options.isQuiet(), this.getIdName() + ": index values will be lost");
        }
        this.channelSeparator = new ChannelSeparator(r);
        r = this.channelSeparator;
        this.dimensionSwapper = new DimensionSwapper(r);
        r = this.dimensionSwapper;
        this.minMaxCalculator = new MinMaxCalculator(r);
        r = this.minMaxCalculator;
        if (this.options.doStitchTiles()) {
            this.tileStitcher = new TileStitcher(r);
            r = this.tileStitcher;
        }
        this.virtualReader = new VirtualReader(r);
        r = this.virtualReader;
        this.reader = new ImageProcessorReader(r);
        this.setId();
        this.computeSeriesLabels(this.reader);
    }

    private void initializeSeries() {
    }

    private void initializeDimOrder() {
        int seriesCount = this.getSeriesCount();
        String stackOrder = this.getStackOrder();
        for (int s = 0; s < seriesCount; ++s) {
            this.reader.setSeries(s);
            String dimOrder = this.options.getInputOrder(s);
            if (dimOrder != null) {
                this.dimensionSwapper.swapDimensions(dimOrder);
            }
            this.getDimensionSwapper().setOutputOrder(stackOrder);
            try {
                DimensionOrder order = DimensionOrder.fromString(stackOrder);
                this.getOMEMetadata().setPixelsDimensionOrder(order, s);
                continue;
            }
            catch (EnumerationException e) {
                // empty catch block
            }
        }
    }

    private void initializeRange() {
    }

    private void initializeCrop() {
    }

    private void initializeColors() {
    }

    private void initializeMetadata() {
        int seriesCount = this.getSeriesCount();
        int numEnabled = 0;
        for (int s = 0; s < seriesCount; ++s) {
            if (!this.options.isSeriesOn(s)) continue;
            ++numEnabled;
        }
        this.metadata = new ImporterMetadata(this.getReader(), this, numEnabled > 1);
    }

    private void computeNameAndLocation() {
        String id = this.options.getId();
        this.idLoc = null;
        this.idName = id;
        if (this.options.isLocal()) {
            this.idLoc = new Location(id);
            this.idName = this.idLoc.getName();
        }
    }

    private void createBaseReader() throws FormatException, IOException {
        if (this.options.isLocal() || this.options.isHTTP()) {
            BF.status(this.options.isQuiet(), "Identifying " + this.idName);
            this.imageReader = LociPrefs.makeImageReader();
            try {
                this.baseReader = this.imageReader.getReader(this.options.getId());
            }
            catch (FormatException exc) {
                WindowTools.reportException(exc, this.options.isQuiet(), "Sorry, there was an error reading the file.");
                throw exc;
            }
            catch (IOException exc) {
                WindowTools.reportException(exc, this.options.isQuiet(), "Sorry, there was a I/O problem reading the file.");
                throw exc;
            }
        } else if (this.options.isOMERO()) {
            BF.status(this.options.isQuiet(), "Establishing server connection");
            try {
                ReflectedUniverse r = new ReflectedUniverse();
                r.exec("import loci.ome.io.OmeroReader");
                r.exec("baseReader = new OmeroReader()");
                ClassList<IFormatReader> classes = new ClassList<IFormatReader>(IFormatReader.class);
                r.setVar("classes", classes);
                r.exec("class = baseReader.getClass()");
                r.exec("classes.addClass(class)");
                this.imageReader = new ImageReader(classes);
                this.baseReader = this.imageReader.getReader(this.options.getId());
            }
            catch (Exception exc) {
                WindowTools.reportException(exc, this.options.isQuiet(), "Sorry, there was a problem communicating with the server.");
                this.cancel();
                return;
            }
        } else {
            WindowTools.reportException(null, this.options.isQuiet(), "Sorry, there has been an internal error: unknown data source");
            this.cancel();
            return;
        }
        Exception exc = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = factory.getInstance(OMEXMLService.class);
            this.meta = service.createOMEXMLMetadata();
        }
        catch (DependencyException de) {
            exc = de;
        }
        catch (ServiceException se) {
            exc = se;
        }
        if (exc != null) {
            WindowTools.reportException(exc, this.options.isQuiet(), "Sorry, there was a problem constructing the OME-XML metadata store");
            throw new FormatException(exc);
        }
        this.baseReader.setMetadataStore(this.meta);
        BF.status(this.options.isQuiet(), "");
        Logger root = Logger.getRootLogger();
        if (IJ.debugMode) {
            root.setLevel(Level.DEBUG);
        } else {
            root.setLevel(Level.INFO);
        }
        root.addAppender(new IJStatusEchoer());
    }

    private void saveDefaults() {
        if (!this.options.isQuiet()) {
            this.options.setFirstTime(false);
        }
        this.options.saveOptions();
    }

    private void setId() throws FormatException, IOException {
        boolean first = true;
        for (int i = 0; i < 5; ++i) {
            String code = LuraWave.initLicenseCode();
            try {
                this.reader.setId(this.options.getId());
                return;
            }
            catch (FormatException exc) {
                if (this.options.isQuiet() || this.options.isWindowless()) {
                    throw exc;
                }
                if (!LuraWave.isLicenseCodeException(exc)) {
                    throw exc;
                }
                if ((code = LuraWave.promptLicenseCode(code, first)) == null) {
                    throw exc;
                }
                if (first) {
                    first = false;
                }
                this.reader.close();
                continue;
            }
        }
        throw new FormatException("Too many LuraWave license code attempts; giving up.");
    }

    private void computeSeriesLabels(IFormatReader r) {
        int seriesCount = r.getSeriesCount();
        this.seriesLabels = new String[seriesCount];
        for (int i = 0; i < seriesCount; ++i) {
            r.setSeries(i);
            StringBuffer sb = new StringBuffer();
            sb.append("Series_");
            sb.append(i + 1);
            sb.append(": ");
            String name = this.getOMEMetadata().getImageName(i);
            if (name != null && name.length() > 0) {
                sb.append(name);
                sb.append(": ");
            }
            sb.append(r.getSizeX());
            sb.append(" x ");
            sb.append(r.getSizeY());
            sb.append("; ");
            sb.append(r.getImageCount());
            sb.append(" plane");
            if (r.getImageCount() > 1) {
                sb.append("s");
                if (r.isOrderCertain()) {
                    sb.append(" (");
                    boolean first = true;
                    if (r.getEffectiveSizeC() > 1) {
                        sb.append(r.getEffectiveSizeC());
                        sb.append("C");
                        first = false;
                    }
                    if (r.getSizeZ() > 1) {
                        if (!first) {
                            sb.append(" x ");
                        }
                        sb.append(r.getSizeZ());
                        sb.append("Z");
                        first = false;
                    }
                    if (r.getSizeT() > 1) {
                        if (!first) {
                            sb.append(" x ");
                        }
                        sb.append(r.getSizeT());
                        sb.append("T");
                        first = false;
                    }
                    sb.append(")");
                }
            }
            this.seriesLabels[i] = sb.toString();
        }
    }

    private void step(ImportStep step) {
        this.step = step;
        this.notifyListeners(new StatusEvent(step.getStep(), ImportStep.COMPLETE.getStep(), step.getMessage()));
    }

    private void assertStep(ImportStep importStep) {
        if (this.step.getStep() <= importStep.getStep()) {
            throw new IllegalStateException("Too early in import process: current step is " + (Object)((Object)this.step) + ", but must be after " + (Object)((Object)importStep));
        }
    }
}

