/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.CompositeImage;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import loci.formats.ChannelFiller;
import loci.formats.DimensionSwapper;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.ImageReader;
import loci.formats.MinMaxCalculator;
import loci.plugins.BF;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterOptions;
import loci.plugins.util.ImageProcessorReader;
import loci.plugins.util.VirtualImagePlus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Colorizer {
    private ImportProcess process;

    public Colorizer(ImportProcess process) {
        this.process = process;
    }

    public List<ImagePlus> applyColors(List<ImagePlus> imps) {
        ImporterOptions options = this.process.getOptions();
        ImageProcessorReader reader = this.process.getReader();
        DimensionSwapper dimSwapper = this.process.getDimensionSwapper();
        ChannelFiller channelFiller = this.process.getChannelFiller();
        ImageReader imageReader = this.process.getImageReader();
        for (int i = 0; i < imps.size(); ++i) {
            boolean doComposite;
            LUT[] luts;
            ImagePlus imp = imps.get(i);
            int series = (Integer)imp.getProperty("Series");
            reader.setSeries(series);
            String stackOrder = dimSwapper.getDimensionOrder();
            int zSize = imp.getNSlices();
            int cSize = imp.getNChannels();
            int tSize = imp.getNFrames();
            int stackSize = imp.getStackSize();
            LUT[] channelLUTs = new LUT[cSize];
            boolean hasChannelLUT = false;
            for (int c = 0; c < cSize; ++c) {
                int index = FormatTools.getIndex(stackOrder, zSize, cSize, tSize, stackSize, 0, c, 0);
                channelLUTs[c] = (LUT)imp.getProperty("LUT-" + index);
                if (channelLUTs[c] == null) continue;
                hasChannelLUT = true;
            }
            int mode = -1;
            if (options.isColorModeDefault()) {
                boolean isRGB;
                boolean bl = isRGB = reader.isRGB() || imageReader.isRGB();
                if (isRGB || channelFiller.isFilled()) {
                    mode = 1;
                    luts = this.makeLUTs((ColorModel[])channelLUTs, true);
                } else if (hasChannelLUT) {
                    mode = 2;
                    luts = this.makeLUTs((ColorModel[])channelLUTs, false);
                } else {
                    mode = 3;
                    luts = null;
                }
            } else if (options.isColorModeComposite()) {
                mode = 1;
                luts = this.makeLUTs((ColorModel[])channelLUTs, true);
            } else if (options.isColorModeColorized()) {
                mode = 2;
                luts = this.makeLUTs((ColorModel[])channelLUTs, true);
            } else if (options.isColorModeGrayscale()) {
                mode = 3;
                luts = null;
            } else if (options.isColorModeCustom()) {
                mode = 2;
                luts = this.makeLUTs(series);
            } else {
                throw new IllegalStateException("Invalid color mode: " + options.getColorMode());
            }
            boolean bl = doComposite = !options.isViewStandard() && mode != -1 && cSize > 1 && cSize <= 7;
            if (doComposite) {
                CompositeImage compImage = new CompositeImage(imp, mode);
                if (luts != null) {
                    compImage.setLuts(luts);
                }
                imps.set(i, (ImagePlus)compImage);
                imp = compImage;
            } else {
                if (luts != null && luts.length > 0 && luts[0] != null) {
                    if (imp instanceof VirtualImagePlus) {
                        ((VirtualImagePlus)imp).setLUTs(luts);
                    } else if (cSize == 1) {
                        imp.getProcessor().setColorModel((ColorModel)luts[0]);
                    }
                }
                if (mode != -1 && cSize > 7) {
                    BF.warn(options.isQuiet(), "Data has too many channels for " + options.getColorMode() + " color mode");
                }
            }
            this.applyDisplayRanges(imp, series);
        }
        return imps;
    }

    private void applyDisplayRanges(ImagePlus imp, int series) {
        double min;
        double max;
        if (imp instanceof VirtualImagePlus) {
            return;
        }
        ImporterOptions options = this.process.getOptions();
        ImageProcessorReader reader = this.process.getReader();
        int pixelType = reader.getPixelType();
        boolean autoscale = options.isAutoscale() || FormatTools.isFloatingPoint(pixelType);
        int cSize = imp.getNChannels();
        double[] cMin = new double[cSize];
        double[] cMax = new double[cSize];
        Arrays.fill(cMin, Double.NaN);
        Arrays.fill(cMax, Double.NaN);
        if (autoscale) {
            MinMaxCalculator minMaxCalc = this.process.getMinMaxCalculator();
            int cBegin = this.process.getCBegin(series);
            int cStep = this.process.getCStep(series);
            for (int c = 0; c < cSize; ++c) {
                int cIndex = cBegin + c * cStep;
                Double cMinVal = null;
                Double cMaxVal = null;
                try {
                    cMinVal = minMaxCalc.getChannelGlobalMinimum(cIndex);
                    cMaxVal = minMaxCalc.getChannelGlobalMaximum(cIndex);
                }
                catch (FormatException exc) {
                }
                catch (IOException exc) {
                    // empty catch block
                }
                if (cMinVal != null) {
                    cMin[c] = cMinVal;
                }
                if (cMaxVal == null) continue;
                cMax[c] = cMaxVal;
            }
        }
        double zeroOffset = Colorizer.getZeroOffset(imp);
        if (FormatTools.isFloatingPoint(pixelType)) {
            max = Double.NaN;
            min = Double.NaN;
        } else {
            int bitDepth = reader.getBitsPerPixel();
            double halfPow = Math.pow(2.0, bitDepth - 1);
            double fullPow = 2.0 * halfPow;
            boolean signed = FormatTools.isSigned(pixelType);
            if (signed) {
                min = -halfPow;
                max = halfPow - 1.0;
            } else {
                min = 0.0;
                max = fullPow - 1.0;
            }
            for (int c = 0; c < cSize; ++c) {
                if (Double.isNaN(cMin[c])) {
                    cMin[c] = min;
                }
                if (!Double.isNaN(cMax[c])) continue;
                cMax[c] = max;
            }
        }
        if (imp instanceof CompositeImage) {
            CompositeImage compImage = (CompositeImage)imp;
            for (int c = 0; c < cSize; ++c) {
                LUT lut = compImage.getChannelLut(c + 1);
                lut.min = cMin[c] - zeroOffset;
                lut.max = cMax[c] - zeroOffset;
            }
        } else {
            double globalMin = Double.POSITIVE_INFINITY;
            double globalMax = Double.NEGATIVE_INFINITY;
            for (int c = 0; c < cSize; ++c) {
                if (cMin[c] < globalMin) {
                    globalMin = cMin[c];
                }
                if (!(cMax[c] > globalMax)) continue;
                globalMax = cMax[c];
            }
            globalMin -= zeroOffset;
            globalMax -= zeroOffset;
            ImageProcessor proc = imp.getProcessor();
            if (proc instanceof ColorProcessor) {
                ColorProcessor colorProc = (ColorProcessor)proc;
                colorProc.setMinAndMax(globalMin, globalMax, 3);
            } else {
                ColorModel model = proc.getColorModel();
                proc.setMinAndMax(globalMin, globalMax);
                proc.setColorModel(model);
                imp.setDisplayRange(globalMin, globalMax);
            }
        }
    }

    private LUT[] makeLUTs(ColorModel[] cm, boolean colorize) {
        ImporterOptions options = this.process.getOptions();
        LUT[] luts = new LUT[cm.length];
        for (int c = 0; c < luts.length; ++c) {
            if (cm[c] instanceof LUT) {
                luts[c] = (LUT)cm[c];
                continue;
            }
            if (cm[c] instanceof IndexColorModel) {
                luts[c] = new LUT((IndexColorModel)cm[c], 0.0, 255.0);
                continue;
            }
            Color color = colorize ? options.getDefaultCustomColor(c) : Color.white;
            luts[c] = this.makeLUT(color);
        }
        return luts;
    }

    private LUT[] makeLUTs(int series) {
        ImageProcessorReader reader = this.process.getReader();
        reader.setSeries(series);
        LUT[] luts = new LUT[reader.getSizeC()];
        for (int c = 0; c < luts.length; ++c) {
            luts[c] = this.makeLUT(series, c);
        }
        return luts;
    }

    private LUT makeLUT(int series, int channel) {
        ImporterOptions options = this.process.getOptions();
        Color color = options.getCustomColor(series, channel);
        if (color == null) {
            color = options.getDefaultCustomColor(channel);
        }
        return this.makeLUT(color);
    }

    private LUT makeLUT(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int lutLength = 256;
        int lutDivisor = 255;
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (int i = 0; i < 256; ++i) {
            r[i] = (byte)(i * red / 255);
            g[i] = (byte)(i * green / 255);
            b[i] = (byte)(i * blue / 255);
        }
        LUT lut = new LUT(r, g, b);
        return lut;
    }

    private static double getZeroOffset(ImagePlus imp) {
        Calibration cal = imp.getCalibration();
        if (cal.getFunction() != 0) {
            return 0.0;
        }
        double[] coeffs = cal.getCoefficients();
        if (coeffs == null || coeffs.length == 0) {
            return 0.0;
        }
        return coeffs[0];
    }
}

