/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.itk;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;

public class ITKBridgePipes {
    private static final String HASH_PREFIX = "hash:";
    private IFormatReader reader = null;
    private IFormatWriter writer = null;
    private BufferedReader in;
    private String readerPath = "";

    public void waitForInput() throws FormatException, IOException {
        String line;
        this.in = new BufferedReader(new InputStreamReader(System.in));
        while ((line = this.in.readLine()) != null) {
            this.executeCommand(line);
        }
        this.in.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean executeCommand(String commandLine) throws FormatException, IOException {
        String[] args = commandLine.split("\t");
        String command = args[0].trim();
        if (command.equals("info")) {
            String filePath = args[1].trim();
            boolean res = this.readImageInfo(filePath);
            System.out.println();
            return res;
        }
        if (command.equals("read")) {
            String filePath = args[1].trim();
            int xBegin = Integer.parseInt(args[2]);
            int xEnd = Integer.parseInt(args[3]) + xBegin - 1;
            int yBegin = Integer.parseInt(args[4]);
            int yEnd = Integer.parseInt(args[5]) + yBegin - 1;
            int zBegin = Integer.parseInt(args[6]);
            int zEnd = Integer.parseInt(args[7]) + zBegin - 1;
            int tBegin = Integer.parseInt(args[8]);
            int tEnd = Integer.parseInt(args[9]) + tBegin - 1;
            int cBegin = Integer.parseInt(args[10]);
            int cEnd = Integer.parseInt(args[11]) + cBegin - 1;
            return this.read(filePath, xBegin, xEnd, yBegin, yEnd, zBegin, zEnd, tBegin, tEnd, cBegin, cEnd);
        }
        if (command.equals("canRead")) {
            String filePath = args[1].trim();
            boolean res = this.canRead(filePath);
            System.out.println();
            return res;
        }
        if (args[0].equals("canWrite")) {
            String filePath = args[1].trim();
            boolean res = this.canWrite(filePath);
            System.out.println();
            return res;
        }
        if (command.equals("exit")) {
            boolean res = this.exit();
            System.out.println();
            return res;
        }
        if (command.equals("write")) {
            int tCount;
            int cCount;
            int zCount;
            int yCount;
            int xCount;
            int tStart;
            int cStart;
            int zStart;
            int yStart;
            int xStart;
            int rgbCCount;
            int pixelType;
            double pSizeC;
            double pSizeT;
            double pSizeZ;
            double pSizeY;
            double pSizeX;
            int dimc;
            int dimt;
            int dimz;
            int dimy;
            int dimx;
            int dims;
            int byteOrder = Integer.parseInt(args[2]);
            if (new ITKBridgePipes().write(args[1], byteOrder, dims = Integer.parseInt(args[3]), dimx = Integer.parseInt(args[4]), dimy = Integer.parseInt(args[5]), dimz = Integer.parseInt(args[6]), dimt = Integer.parseInt(args[7]), dimc = Integer.parseInt(args[8]), pSizeX = (double)Integer.parseInt(args[9]), pSizeY = (double)Integer.parseInt(args[10]), pSizeZ = (double)Integer.parseInt(args[11]), pSizeT = (double)Integer.parseInt(args[12]), pSizeC = (double)Integer.parseInt(args[13]), pixelType = Integer.parseInt(args[14]), rgbCCount = Integer.parseInt(args[15]), xStart = Integer.parseInt(args[16]), yStart = Integer.parseInt(args[18]), zStart = Integer.parseInt(args[20]), cStart = Integer.parseInt(args[22]), tStart = Integer.parseInt(args[24]), xCount = Integer.parseInt(args[17]), yCount = Integer.parseInt(args[19]), zCount = Integer.parseInt(args[21]), cCount = Integer.parseInt(args[23]), tCount = Integer.parseInt(args[25]))) return false;
        }
        System.err.println("Unknown command: " + command);
        return false;
    }

    public boolean readImageInfo(String filePath) throws FormatException, IOException {
        int itkComponentType;
        this.createReader(filePath);
        MetadataStore store = this.reader.getMetadataStore();
        IMetadata meta = (IMetadata)store;
        this.sendData("Interleaved", String.valueOf(this.reader.isInterleaved() ? 1 : 0));
        this.sendData("LittleEndian", String.valueOf(this.reader.isLittleEndian() ? 1 : 0));
        int pixelType = this.reader.getPixelType();
        switch (pixelType) {
            case 1: {
                itkComponentType = 1;
                break;
            }
            case 0: {
                itkComponentType = 2;
                break;
            }
            case 3: {
                itkComponentType = 3;
                break;
            }
            case 2: {
                itkComponentType = 4;
                break;
            }
            case 5: {
                itkComponentType = 5;
                break;
            }
            case 4: {
                itkComponentType = 6;
                break;
            }
            case 6: {
                itkComponentType = 9;
                break;
            }
            case 7: {
                itkComponentType = 10;
                break;
            }
            default: {
                itkComponentType = 0;
            }
        }
        this.sendData("PixelType", String.valueOf(itkComponentType));
        this.sendData("SizeX", String.valueOf(this.reader.getSizeX()));
        this.sendData("SizeY", String.valueOf(this.reader.getSizeY()));
        this.sendData("SizeZ", String.valueOf(this.reader.getSizeZ()));
        this.sendData("SizeT", String.valueOf(this.reader.getSizeT()));
        this.sendData("SizeC", String.valueOf(this.reader.getEffectiveSizeC()));
        this.sendData("RGBChannelCount", String.valueOf(this.reader.getRGBChannelCount()));
        this.sendData("PixelsPhysicalSizeX", String.valueOf(meta.getPixelsPhysicalSizeX(0) == null ? 1.0 : (Double)meta.getPixelsPhysicalSizeX(0).getValue() / 1000.0));
        this.sendData("PixelsPhysicalSizeY", String.valueOf(meta.getPixelsPhysicalSizeY(0) == null ? 1.0 : (Double)meta.getPixelsPhysicalSizeY(0).getValue() / 1000.0));
        this.sendData("PixelsPhysicalSizeZ", String.valueOf(meta.getPixelsPhysicalSizeZ(0) == null ? 1.0 : (Double)meta.getPixelsPhysicalSizeZ(0).getValue() / 1000.0));
        this.sendData("PixelsPhysicalSizeT", String.valueOf(meta.getPixelsTimeIncrement(0) == null ? 1.0 : meta.getPixelsTimeIncrement(0) / 1000.0));
        this.sendData("PixelsPhysicalSizeC", String.valueOf(1.0));
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.putAll(this.reader.getGlobalMetadata());
        metadata.putAll(this.reader.getSeriesMetadata());
        Set entries = metadata.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            String value = entry.getValue().toString();
            value = value.replace("\\", "\\\\").replace("\n", "\\n");
            this.sendData(key, value);
        }
        System.out.flush();
        return true;
    }

    public boolean read(String filePath, int xBegin, int xEnd, int yBegin, int yEnd, int zBegin, int zEnd, int tBegin, int tEnd, int cBegin, int cEnd) throws FormatException, IOException {
        this.createReader(filePath);
        int rgbChannelCount = this.reader.getRGBChannelCount();
        int bpp = FormatTools.getBytesPerPixel(this.reader.getPixelType());
        int xCount = this.reader.getSizeX();
        int yCount = this.reader.getSizeY();
        boolean isInterleaved = this.reader.isInterleaved();
        boolean canDoDirect = xBegin == 0 && yBegin == 0 && xEnd == xCount - 1 && yEnd == yCount - 1 && rgbChannelCount == 1;
        BufferedOutputStream out = new BufferedOutputStream(System.out, 0x6400000);
        for (int c = cBegin; c <= cEnd; ++c) {
            for (int t = tBegin; t <= tEnd; ++t) {
                for (int z = zBegin; z <= zEnd; ++z) {
                    byte[] image = this.reader.openBytes(this.reader.getIndex(z, c, t));
                    if (canDoDirect) {
                        out.write(image);
                        continue;
                    }
                    for (int y = yBegin; y <= yEnd; ++y) {
                        for (int x = xBegin; x <= xEnd; ++x) {
                            for (int i = 0; i < rgbChannelCount; ++i) {
                                for (int b = 0; b < bpp; ++b) {
                                    int index = xCount * (yCount * (rgbChannelCount * b + i) + y) + x;
                                    out.write(image[index]);
                                }
                            }
                        }
                    }
                }
            }
        }
        out.flush();
        return true;
    }

    public boolean write(String fileName, int byteOrder, int dims, int dimx, int dimy, int dimz, int dimt, int dimc, double pSizeX, double pSizeY, double pSizeZ, double pSizeT, double pSizeC, int pixelType, int rgbCCount, int xStart, int yStart, int zStart, int cStart, int tStart, int xCount, int yCount, int zCount, int cCount, int tCount) throws IOException, FormatException {
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        meta.createRoot();
        meta.setImageID("Image:0", 0);
        meta.setPixelsID("Pixels:0", 0);
        meta.setPixelsDimensionOrder(DimensionOrder.XYZCT, 0);
        try {
            meta.setPixelsType(PixelType.fromString(FormatTools.getPixelTypeString(pixelType)), 0);
        }
        catch (EnumerationException e) {
            throw new IOException(e.getMessage());
        }
        if (byteOrder == 0) {
            meta.setPixelsBinDataBigEndian(new Boolean("false"), 0, 0);
        } else {
            meta.setPixelsBinDataBigEndian(new Boolean("true"), 0, 0);
        }
        meta.setPixelsSizeX(new PositiveInteger(new Integer(dimx)), 0);
        meta.setPixelsSizeY(new PositiveInteger(new Integer(dimy)), 0);
        meta.setPixelsSizeZ(new PositiveInteger(new Integer(dimz)), 0);
        meta.setPixelsSizeC(new PositiveInteger(new Integer(dimc)), 0);
        meta.setPixelsSizeT(new PositiveInteger(new Integer(dimt)), 0);
        meta.setPixelsPhysicalSizeX(new PositiveFloat(new Double(pSizeX * 1000.0)), 0);
        meta.setPixelsPhysicalSizeY(new PositiveFloat(new Double(pSizeY * 1000.0)), 0);
        meta.setPixelsPhysicalSizeZ(new PositiveFloat(new Double(pSizeZ * 1000.0)), 0);
        meta.setPixelsTimeIncrement(new Double(pSizeT), 0);
        meta.setChannelID("Channel:0:0", 0, 0);
        meta.setChannelSamplesPerPixel(new PositiveInteger(new Integer(rgbCCount)), 0, 0);
        this.writer = new ImageWriter();
        this.writer.setMetadataRetrieve(meta);
        this.writer.setId(fileName);
        int bpp = FormatTools.getBytesPerPixel(pixelType);
        int bytesPerPlane = xCount * yCount * bpp * rgbCCount;
        int numIters = (cCount - cStart) * (tCount - tStart) * (zCount - zStart);
        System.out.print(bytesPerPlane + "\n" + fileName + "\n" + cStart + "\n" + cCount + "\n" + tStart + "\n" + tCount + "\n" + zStart + "\n" + zCount + "\n\n");
        System.out.flush();
        int no = 0;
        for (int c = cStart; c < cStart + cCount; ++c) {
            for (int t = tStart; t < tStart + tCount; ++t) {
                for (int z = zStart; z < zStart + zCount; ++z) {
                    String line = "";
                    int bytesRead = 0;
                    String test = "";
                    byte[] buf = new byte[bytesPerPlane];
                    BufferedInputStream linein = new BufferedInputStream(System.in);
                    while (bytesRead < bytesPerPlane) {
                        int read;
                        System.out.println("Bytes read: " + (bytesRead += (read = linein.read(buf, bytesRead, bytesPerPlane - bytesRead)) > 0 ? read : 0) + ". Plane no: " + no + ". Ready for more bytes.\n");
                        System.out.flush();
                    }
                    this.writer.saveBytes(no, buf, xStart, yStart, xCount, yCount);
                    System.out.println("Plane no: " + no + " saved.\n");
                    System.out.flush();
                    ++no;
                }
            }
        }
        this.in.close();
        this.writer.close();
        return true;
    }

    public boolean canRead(String filePath) throws FormatException, IOException {
        this.createReader(null);
        boolean canRead = this.reader.isThisType(filePath);
        System.out.println(canRead);
        System.out.flush();
        return true;
    }

    public boolean canWrite(String filePath) throws FormatException, IOException {
        this.writer = new ImageWriter();
        boolean canWrite = this.writer.isThisType(filePath);
        System.out.println(canWrite);
        System.out.flush();
        return true;
    }

    private IFormatReader createReader(String filePath) throws FormatException, IOException {
        if (this.readerPath == null) {
            this.reader.setId(filePath);
            this.reader.setSeries(0);
            return this.reader;
        }
        if (this.readerPath.equals(filePath)) {
            return this.reader;
        }
        if (this.reader != null) {
            this.reader.close();
        }
        System.err.println("Creating new reader for " + filePath);
        this.reader = new ImageReader();
        this.readerPath = filePath;
        this.reader.setMetadataFiltered(true);
        this.reader.setOriginalMetadataPopulated(true);
        IMetadata store = MetadataTools.createOMEXMLMetadata();
        if (store == null) {
            System.err.println("OME-Java library not found.");
        } else {
            this.reader.setMetadataStore(store);
        }
        this.reader.setGroupFiles(false);
        if (filePath != null) {
            this.reader.setId(filePath);
            this.reader.setSeries(0);
        }
        return this.reader;
    }

    public boolean exit() throws FormatException, IOException {
        this.reader.close();
        System.exit(0);
        return true;
    }

    private void sendData(String key, String value) {
        System.out.println(key);
        System.out.println(value);
    }

    public static void main(String[] args) throws FormatException, IOException {
        if (args[0].equals("info")) {
            if (!new ITKBridgePipes().readImageInfo(args[1])) {
                System.exit(1);
            }
        } else if (args[0].equals("read")) {
            int cEnd;
            int cBegin;
            int tEnd;
            int tBegin;
            int zEnd;
            int zBegin;
            int yEnd;
            int yBegin;
            int xEnd;
            int xBegin = Integer.parseInt(args[2]);
            if (!new ITKBridgePipes().read(args[1], xBegin, xEnd = Integer.parseInt(args[3]) + xBegin - 1, yBegin = Integer.parseInt(args[4]), yEnd = Integer.parseInt(args[5]) + yBegin - 1, zBegin = Integer.parseInt(args[6]), zEnd = Integer.parseInt(args[7]) + zBegin - 1, tBegin = Integer.parseInt(args[8]), tEnd = Integer.parseInt(args[9]) + tBegin - 1, cBegin = Integer.parseInt(args[10]), cEnd = Integer.parseInt(args[11]) + cBegin - 1)) {
                System.exit(1);
            }
        } else if (args[0].equals("canRead")) {
            if (!new ITKBridgePipes().canRead(args[1])) {
                System.exit(1);
            }
        } else if (args[0].equals("canWrite")) {
            if (!new ITKBridgePipes().canWrite(args[1])) {
                System.exit(1);
            }
        } else if (args[0].equals("waitForInput")) {
            new ITKBridgePipes().waitForInput();
        } else if (args[0].equals("write")) {
            int tCount;
            int cCount;
            int zCount;
            int yCount;
            int xCount;
            int tStart;
            int cStart;
            int zStart;
            int yStart;
            int xStart;
            int rgbCCount;
            int pixelType;
            double pSizeC;
            double pSizeT;
            double pSizeZ;
            double pSizeY;
            double pSizeX;
            int dimc;
            int dimt;
            int dimz;
            int dimy;
            int dimx;
            int dims;
            int byteOrder = Integer.parseInt(args[2]);
            if (!new ITKBridgePipes().write(args[1], byteOrder, dims = Integer.parseInt(args[3]), dimx = Integer.parseInt(args[4]), dimy = Integer.parseInt(args[5]), dimz = Integer.parseInt(args[6]), dimt = Integer.parseInt(args[7]), dimc = Integer.parseInt(args[8]), pSizeX = (double)Integer.parseInt(args[9]), pSizeY = (double)Integer.parseInt(args[10]), pSizeZ = (double)Integer.parseInt(args[11]), pSizeT = (double)Integer.parseInt(args[12]), pSizeC = (double)Integer.parseInt(args[13]), pixelType = Integer.parseInt(args[14]), rgbCCount = Integer.parseInt(args[15]), xStart = Integer.parseInt(args[16]), yStart = Integer.parseInt(args[18]), zStart = Integer.parseInt(args[20]), cStart = Integer.parseInt(args[22]), tStart = Integer.parseInt(args[24]), xCount = Integer.parseInt(args[17]), yCount = Integer.parseInt(args[19]), zCount = Integer.parseInt(args[21]), cCount = Integer.parseInt(args[23]), tCount = Integer.parseInt(args[25]))) {
                System.exit(1);
            }
        } else {
            System.err.println("Error: unknown command: " + args[0]);
            System.exit(1);
        }
    }
}

