/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class UnisokuReader
extends FormatReader {
    protected static final String UNISOKU_MAGIC_STRING = ":STM data";
    private String datFile;

    public UnisokuReader() {
        super("Unisoku STM", new String[]{"hdr", "dat"});
        this.domains = new String[]{"Scanning Probe Microscopy (SPM)"};
        this.suffixSufficient = false;
        this.hasCompanionFiles = true;
    }

    public boolean isThisType(String name, boolean open) {
        if (UnisokuReader.checkSuffix(name, "hdr")) {
            return super.isThisType(name, open);
        }
        if (name.indexOf(".") < 0) {
            return false;
        }
        String baseName = name.substring(0, name.lastIndexOf("."));
        Location file2 = new Location(baseName + ".HDR");
        if (!file2.exists()) {
            file2 = new Location(baseName + ".hdr");
        }
        if (!file2.exists()) {
            return false;
        }
        return super.isThisType(file2.getAbsolutePath(), open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 9;
        if (!FormatTools.validStream(stream, 9, false)) {
            return false;
        }
        return stream.readString(9).indexOf(UNISOKU_MAGIC_STRING) >= 0;
    }

    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.currentId};
        }
        return new String[]{this.currentId, this.datFile};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        RandomAccessInputStream dat = new RandomAccessInputStream(this.datFile);
        dat.order(this.isLittleEndian());
        this.readPlane(dat, x, y, w, h, buf);
        dat.close();
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.datFile = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (UnisokuReader.checkSuffix(id = new Location(id).getAbsolutePath(), "dat")) {
            id = id.substring(0, id.lastIndexOf(".")) + ".HDR";
        }
        super.initFile(id);
        this.datFile = id.substring(0, id.lastIndexOf(".")) + ".DAT";
        String header = DataTools.readFile(id);
        String[] lines = header.split("\r");
        String imageName = null;
        String remark = null;
        String date = null;
        double pixelSizeX = 0.0;
        double pixelSizeY = 0.0;
        int i = 0;
        while (i < lines.length) {
            lines[i] = lines[i].trim();
            if (!lines[i].startsWith(":")) continue;
            String key = lines[i++];
            StringBuffer data = new StringBuffer();
            while (i < lines.length && !lines[i].trim().startsWith(":")) {
                data.append(" ");
                data.append(lines[i++].trim());
            }
            String value = data.toString().trim();
            this.addGlobalMeta(key, value);
            String[] v = value.split(" ");
            if (key.equals(":data volume(x*y)")) {
                this.core[0].sizeX = Integer.parseInt(v[0]);
                this.core[0].sizeY = Integer.parseInt(v[1]);
                continue;
            }
            if (key.equals(":date; time")) {
                date = DateTools.formatDate(value, "MM/dd/yy HH:mm:ss");
                continue;
            }
            if (key.startsWith(":ascii flag; data type")) {
                int type = Integer.parseInt(value = value.substring(value.indexOf(" ") + 1));
                boolean signed = type % 2 == 1;
                int bytes = type / 2;
                this.core[0].pixelType = FormatTools.pixelTypeFromBytes(bytes, signed, bytes == 4);
                continue;
            }
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
            if (key.equals(":sample name")) {
                imageName = value;
                continue;
            }
            if (key.equals(":remark")) {
                remark = value;
                continue;
            }
            if (key.startsWith(":x_data ->")) {
                String unit = v[0];
                pixelSizeX = Double.parseDouble(v[2]) - Double.parseDouble(v[1]);
                pixelSizeX /= (double)this.getSizeX();
                if (!unit.equals("nm")) continue;
                pixelSizeX /= 1000.0;
                continue;
            }
            if (!key.startsWith(":y_data ->")) continue;
            String unit = v[0];
            pixelSizeY = Double.parseDouble(v[2]) - Double.parseDouble(v[1]);
            pixelSizeY /= (double)this.getSizeY();
            if (!unit.equals("nm")) continue;
            pixelSizeY /= 1000.0;
        }
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].indexed = false;
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].littleEndian = true;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setImageName(imageName, 0);
        store.setImageAcquiredDate(date, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(remark, 0);
            store.setPixelsPhysicalSizeX(new PositiveFloat(pixelSizeX), 0);
            store.setPixelsPhysicalSizeY(new PositiveFloat(pixelSizeY), 0);
        }
    }
}

