/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class PrairieReader
extends FormatReader {
    public static final String[] CFG_SUFFIX = new String[]{"cfg"};
    public static final String[] XML_SUFFIX = new String[]{"xml"};
    public static final String[] PRAIRIE_SUFFIXES = new String[]{"cfg", "xml"};
    private static final int PRAIRIE_TAG_1 = 33628;
    private static final int PRAIRIE_TAG_2 = 33629;
    private static final int PRAIRIE_TAG_3 = 33630;
    private String[] files;
    private TiffReader tiff;
    private String xmlFile;
    private String cfgFile;
    private boolean readXML = false;
    private boolean readCFG = false;
    private Vector<String> f;
    private Vector<String> gains;
    private Vector<String> offsets;
    private double pixelSizeX;
    private double pixelSizeY;
    private String date;
    private String laserPower;
    private String microscopeModel;
    private String objectiveManufacturer;
    private PositiveInteger magnification;
    private String immersion;
    private Double lensNA;
    private Double waitTime;
    private Vector<Double> positionX = new Vector();
    private Vector<Double> positionY = new Vector();
    private Vector<Double> positionZ = new Vector();
    private Vector<String> channels = new Vector();
    private Hashtable<String, Double> relativeTimes = new Hashtable();
    private Double zoom;

    public PrairieReader() {
        super("Prairie TIFF", new String[]{"tif", "tiff", "cfg", "xml"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return false;
        }
        Location file2 = new Location(name).getAbsoluteFile();
        Location parent = file2.getParentFile();
        String prefix = file2.getName();
        if (prefix.indexOf(".") != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        if (PrairieReader.checkSuffix(name, CFG_SUFFIX)) {
            if (prefix.lastIndexOf("Config") == -1) {
                return false;
            }
            prefix = prefix.substring(0, prefix.lastIndexOf("Config"));
        }
        if (prefix.indexOf("_") != -1) {
            prefix = prefix.substring(0, prefix.indexOf("_"));
        }
        Location xml = new Location(parent, prefix + ".xml");
        Location cfg = new Location(parent, prefix + "Config.cfg");
        boolean hasMetadataFiles = xml.exists() && cfg.exists();
        return hasMetadataFiles && super.isThisType(name, false);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 0x100020;
        if (!FormatTools.validStream(stream, 0x100020, false)) {
            return false;
        }
        String s = stream.readString(0x100020);
        if (s.indexOf("xml") != -1 && s.indexOf("PV") != -1) {
            return true;
        }
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String software = null;
        try {
            software = ifd.getIFDStringValue(305);
        }
        catch (FormatException exc) {
            return false;
        }
        if (software == null) {
            return false;
        }
        if (software.indexOf("Prairie") < 0) {
            return false;
        }
        return ifd.containsKey(new Integer(33628)) && ifd.containsKey(new Integer(33629)) && ifd.containsKey(new Integer(33630));
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.xmlFile, this.cfgFile};
        }
        Vector<String> s = new Vector<String>();
        if (this.files != null) {
            for (String file2 : this.files) {
                s.add(file2);
            }
        }
        if (this.xmlFile != null) {
            s.add(this.xmlFile);
        }
        if (this.cfgFile != null) {
            s.add(this.cfgFile);
        }
        return s.toArray(new String[s.size()]);
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiff.getOptimalTileWidth();
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiff.getOptimalTileHeight();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.tiff.setId(this.files[no]);
        return this.tiff.openBytes(0, buf, x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiff != null) {
            this.tiff.close(fileOnly);
        }
        if (!fileOnly) {
            this.cfgFile = null;
            this.xmlFile = null;
            this.tiff = null;
            this.files = null;
            this.readXML = false;
            this.readCFG = false;
            this.offsets = null;
            this.gains = null;
            this.f = null;
            this.pixelSizeY = 0.0;
            this.pixelSizeX = 0.0;
            this.laserPower = null;
            this.date = null;
            this.microscopeModel = null;
            this.objectiveManufacturer = null;
            this.magnification = null;
            this.immersion = null;
            this.lensNA = null;
            this.positionX.clear();
            this.positionY.clear();
            this.positionZ.clear();
            this.channels.clear();
            this.zoom = null;
            this.waitTime = null;
            this.relativeTimes.clear();
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (this.metadata == null) {
            this.metadata = new Hashtable();
        }
        if (this.core == null) {
            this.core = new CoreMetadata[]{new CoreMetadata()};
        }
        if (this.tiff == null) {
            this.tiff = new TiffReader();
        }
        if (PrairieReader.checkSuffix(id, PRAIRIE_SUFFIXES)) {
            if (PrairieReader.checkSuffix(id, XML_SUFFIX)) {
                LOGGER.info("Parsing XML");
                super.initFile(id);
                this.xmlFile = id;
                this.readXML = true;
            } else if (PrairieReader.checkSuffix(id, CFG_SUFFIX)) {
                LOGGER.info("Parsing CFG");
                this.cfgFile = id;
                this.readCFG = true;
                this.currentId = id;
            }
            this.f = new Vector();
            this.gains = new Vector();
            this.offsets = new Vector();
            String xml = XMLTools.sanitizeXML(DataTools.readFile(id)).trim();
            if (PrairieReader.checkSuffix(id, XML_SUFFIX)) {
                this.core[0].imageCount = 0;
            }
            PrairieHandler handler = new PrairieHandler();
            XMLTools.parseXML(xml, (DefaultHandler)handler);
            boolean minimumMetadata = this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM;
            MetadataStore store = this.makeFilterMetadata();
            if (PrairieReader.checkSuffix(id, XML_SUFFIX)) {
                this.core[0].sizeT = this.getImageCount() / (this.getSizeZ() * this.getSizeC());
                this.files = new String[this.f.size()];
                this.f.copyInto(this.files);
                if (this.tiff == null) {
                    this.tiff = new TiffReader();
                }
                this.tiff.setId(this.files[0]);
                LOGGER.info("Populating metadata");
                if (this.getSizeZ() == 0) {
                    this.core[0].sizeZ = 1;
                }
                if (this.getSizeT() == 0) {
                    this.core[0].sizeT = 1;
                }
                this.core[0].dimensionOrder = "XYCZT";
                this.core[0].pixelType = 3;
                this.core[0].rgb = false;
                this.core[0].interleaved = false;
                this.core[0].littleEndian = this.tiff.isLittleEndian();
                this.core[0].indexed = this.tiff.isIndexed();
                this.core[0].falseColor = false;
                MetadataTools.populatePixels(store, this, !minimumMetadata);
                if (this.date != null) {
                    this.date = DateTools.formatDate(this.date, "MM/dd/yyyy h:mm:ss a");
                    if (this.date != null) {
                        store.setImageAcquiredDate(this.date, 0);
                    }
                } else {
                    MetadataTools.setDefaultCreationDate(store, id, 0);
                }
                if (!minimumMetadata) {
                    int i;
                    String instrumentID = MetadataTools.createLSID("Instrument", 0);
                    store.setInstrumentID(instrumentID, 0);
                    store.setImageInstrumentRef(instrumentID, 0);
                    store.setPixelsPhysicalSizeX(new PositiveFloat(this.pixelSizeX), 0);
                    store.setPixelsPhysicalSizeY(new PositiveFloat(this.pixelSizeY), 0);
                    for (i = 0; i < this.getSizeC(); ++i) {
                        String offset;
                        String gain = i < this.gains.size() ? this.gains.get(i) : null;
                        String string = offset = i < this.offsets.size() ? this.offsets.get(i) : null;
                        if (offset != null) {
                            try {
                                store.setDetectorSettingsOffset(new Double(offset), 0, i);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        if (gain != null) {
                            try {
                                store.setDetectorSettingsGain(new Double(gain), 0, i);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        String detectorID = MetadataTools.createLSID("Detector", 0, i);
                        store.setDetectorID(detectorID, 0, i);
                        store.setDetectorSettingsID(detectorID, 0, i);
                        store.setDetectorType(this.getDetectorType("Other"), 0, i);
                        store.setDetectorZoom(this.zoom, 0, i);
                        if (i >= this.channels.size()) continue;
                        store.setChannelName(this.channels.get(i), 0, i);
                    }
                    for (i = 0; i < this.getImageCount(); ++i) {
                        int[] zct = this.getZCTCoords(i);
                        int index = FormatTools.getIndex(this.getDimensionOrder(), this.getSizeZ(), 1, this.getSizeT(), this.getImageCount() / this.getSizeC(), zct[0], 0, zct[2]);
                        double xPos = this.positionX.get(index);
                        double yPos = this.positionY.get(index);
                        double zPos = this.positionZ.get(index);
                        if (!Double.isNaN(xPos)) {
                            store.setPlanePositionX(xPos, 0, i);
                        }
                        if (!Double.isNaN(yPos)) {
                            store.setPlanePositionY(yPos, 0, i);
                        }
                        if (!Double.isNaN(zPos)) {
                            store.setPlanePositionZ(zPos, 0, i);
                        }
                        store.setPlaneDeltaT(this.relativeTimes.get(String.valueOf(i + 1)), 0, i);
                    }
                    if (this.microscopeModel != null) {
                        store.setMicroscopeModel(this.microscopeModel, 0);
                    }
                    String objective = MetadataTools.createLSID("Objective", 0, 0);
                    store.setObjectiveID(objective, 0, 0);
                    store.setImageObjectiveSettingsID(objective, 0);
                    if (this.magnification != null) {
                        store.setObjectiveNominalMagnification(this.magnification, 0, 0);
                    }
                    store.setObjectiveManufacturer(this.objectiveManufacturer, 0, 0);
                    store.setObjectiveImmersion(this.getImmersion(this.immersion), 0, 0);
                    store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
                    store.setObjectiveLensNA(this.lensNA, 0, 0);
                    if (this.laserPower != null) {
                        String laser = MetadataTools.createLSID("LightSource", 0, 0);
                        store.setLaserID(laser, 0, 0);
                        try {
                            store.setLaserPower(new Double(this.laserPower), 0, 0);
                        }
                        catch (NumberFormatException e) {}
                    }
                }
            } else if (PrairieReader.checkSuffix(id, CFG_SUFFIX)) {
                store.setPixelsTimeIncrement(this.waitTime, 0);
            }
            if (!this.readXML || !this.readCFG) {
                String[] listing;
                File file2 = new File(id).getAbsoluteFile();
                File parent = file2.getParentFile();
                for (String name : listing = file2.exists() ? parent.list() : Location.getIdMap().keySet().toArray(new String[0])) {
                    if ((this.readXML || !PrairieReader.checkSuffix(name, XML_SUFFIX)) && (!this.readXML || !PrairieReader.checkSuffix(name, CFG_SUFFIX))) continue;
                    String dir = "";
                    if (file2.exists() && !(dir = parent.getPath()).endsWith(File.separator)) {
                        dir = dir + File.separator;
                    }
                    this.initFile(dir + name);
                }
            }
        } else if (this.isGroupFiles()) {
            String[] listing;
            LOGGER.info("Finding XML file");
            Location file3 = new Location(id).getAbsoluteFile();
            Location parent = file3.getParentFile();
            for (String name : listing = parent.list()) {
                if (!PrairieReader.checkSuffix(name, PRAIRIE_SUFFIXES)) continue;
                this.initFile(new Location(parent, name).getAbsolutePath());
                return;
            }
        } else {
            this.files = new String[]{id};
            this.tiff.setId(this.files[0]);
            this.core = this.tiff.getCoreMetadata();
            this.metadataStore = this.tiff.getMetadataStore();
            Hashtable<String, Object> globalMetadata = this.tiff.getGlobalMetadata();
            for (String key : globalMetadata.keySet()) {
                this.addGlobalMeta(key.toString(), globalMetadata.get(key));
            }
        }
        if (this.currentId == null) {
            this.currentId = id;
        }
    }

    public class PrairieHandler
    extends DefaultHandler {
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("PVScan")) {
                PrairieReader.this.date = attributes.getValue("date");
            } else if (qName.equals("Frame")) {
                int zIndex;
                String index = attributes.getValue("index");
                if (index != null && (zIndex = Integer.parseInt(index)) > PrairieReader.this.getSizeZ()) {
                    ++((PrairieReader)PrairieReader.this).core[0].sizeZ;
                }
                PrairieReader.this.relativeTimes.put(index, new Double(attributes.getValue("relativeTime")));
            } else if (qName.equals("File")) {
                int cIndex;
                ++((PrairieReader)PrairieReader.this).core[0].imageCount;
                File current = new File(PrairieReader.this.currentId).getAbsoluteFile();
                String dir = "";
                if (current.exists()) {
                    dir = current.getPath();
                    dir = dir.substring(0, dir.lastIndexOf(File.separator) + 1);
                }
                PrairieReader.this.f.add(dir + attributes.getValue("filename"));
                String ch = attributes.getValue("channel");
                String channelName = attributes.getValue("channelName");
                if (channelName == null) {
                    channelName = ch;
                }
                if (ch != null && (cIndex = Integer.parseInt(ch)) > PrairieReader.this.getSizeC() && !PrairieReader.this.channels.contains(channelName)) {
                    ++((PrairieReader)PrairieReader.this).core[0].sizeC;
                    PrairieReader.this.channels.add(channelName);
                }
            } else if (qName.equals("Key")) {
                String key = attributes.getValue("key");
                String value = attributes.getValue("value");
                PrairieReader.this.addGlobalMeta(key, value);
                if (key.equals("pixelsPerLine")) {
                    ((PrairieReader)PrairieReader.this).core[0].sizeX = Integer.parseInt(value);
                } else if (key.equals("linesPerFrame")) {
                    ((PrairieReader)PrairieReader.this).core[0].sizeY = Integer.parseInt(value);
                } else if (key.equals("micronsPerPixel_XAxis")) {
                    try {
                        PrairieReader.this.pixelSizeX = Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {}
                } else if (key.equals("micronsPerPixel_YAxis")) {
                    try {
                        PrairieReader.this.pixelSizeY = Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {}
                } else if (key.equals("objectiveLens")) {
                    String[] tokens = value.split(" ");
                    if (tokens.length > 0) {
                        PrairieReader.this.objectiveManufacturer = tokens[0];
                    }
                    if (tokens.length > 1) {
                        String mag = tokens[1].toLowerCase().replaceAll("x", "");
                        try {
                            PrairieReader.this.magnification = new PositiveInteger(new Integer(mag));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (tokens.length > 2) {
                        PrairieReader.this.immersion = tokens[2];
                    }
                } else if (key.equals("objectiveLensNA")) {
                    try {
                        PrairieReader.this.lensNA = new Double(value);
                    }
                    catch (NumberFormatException e) {}
                } else if (key.equals("imagingDevice")) {
                    PrairieReader.this.microscopeModel = value;
                } else if (key.startsWith("pmtGain_")) {
                    PrairieReader.this.gains.add(value);
                } else if (key.startsWith("pmtOffset_")) {
                    PrairieReader.this.offsets.add(value);
                } else if (key.equals("laserPower_0")) {
                    PrairieReader.this.laserPower = value;
                } else if (key.equals("positionCurrent_XAxis")) {
                    try {
                        PrairieReader.this.positionX.add(new Double(value));
                        PrairieReader.this.addGlobalMeta("X position for position #" + PrairieReader.this.positionX.size(), value);
                    }
                    catch (NumberFormatException e) {
                        PrairieReader.this.positionX.add(Double.NaN);
                    }
                } else if (key.equals("positionCurrent_YAxis")) {
                    try {
                        PrairieReader.this.positionY.add(new Double(value));
                        PrairieReader.this.addGlobalMeta("Y position for position #" + PrairieReader.this.positionY.size(), value);
                    }
                    catch (NumberFormatException e) {
                        PrairieReader.this.positionY.add(Double.NaN);
                    }
                } else if (key.equals("positionCurrent_ZAxis")) {
                    try {
                        PrairieReader.this.positionZ.add(new Double(value));
                        PrairieReader.this.addGlobalMeta("Z position for position #" + PrairieReader.this.positionZ.size(), value);
                    }
                    catch (NumberFormatException e) {
                        PrairieReader.this.positionZ.add(Double.NaN);
                    }
                } else if (key.equals("opticalZoom")) {
                    try {
                        PrairieReader.this.zoom = new Double(value);
                    }
                    catch (NumberFormatException e) {}
                } else if (key.equals("bitDepth")) {
                    ((PrairieReader)PrairieReader.this).core[0].bitsPerPixel = Integer.parseInt(value);
                }
            } else if (qName.equals("PVTSeriesElementWait")) {
                try {
                    PrairieReader.this.waitTime = new Double(attributes.getValue("waitTime"));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }
}

