/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.POIService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.PositiveFloat;

public class PCIReader
extends FormatReader {
    public static final int PCI_MAGIC_BYTES = -791735840;
    private HashMap<Integer, String> imageFiles;
    private POIService poi;
    private HashMap<Integer, Double> timestamps;
    private String creationDate;
    private int binning;
    private Vector<Double> uniqueZ;

    public PCIReader() {
        super("Compix Simple-PCI", "cxd");
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        return stream.readInt() == -791735840;
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        String file2 = this.imageFiles.get(0);
        try {
            RandomAccessInputStream s = this.poi.getDocumentStream(file2);
            TiffParser tp = new TiffParser(s);
            if (tp.isValidHeader()) {
                IFD ifd = tp.getFirstIFD();
                s.close();
                return (int)ifd.getTileWidth();
            }
            s.close();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile width", e);
        }
        catch (IOException e) {
            LOGGER.debug("Could not retrieve tile width", e);
        }
        return super.getOptimalTileWidth();
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        String file2 = this.imageFiles.get(0);
        try {
            RandomAccessInputStream s = this.poi.getDocumentStream(file2);
            TiffParser tp = new TiffParser(s);
            if (tp.isValidHeader()) {
                IFD ifd = tp.getFirstIFD();
                s.close();
                return (int)ifd.getTileLength();
            }
            s.close();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile height", e);
        }
        catch (IOException e) {
            LOGGER.debug("Could not retrieve tile height", e);
        }
        return super.getOptimalTileHeight();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        String file2 = this.imageFiles.get(no);
        RandomAccessInputStream s = this.poi.getDocumentStream(file2);
        TiffParser tp = new TiffParser(s);
        if (tp.isValidHeader()) {
            IFD ifd = tp.getFirstIFD();
            tp.getSamples(ifd, buf, x, y, w, h);
        } else {
            s.seek(0L);
            this.readPlane(s, x, y, w, h, buf);
        }
        s.close();
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.imageFiles = null;
            this.timestamps = null;
            if (this.poi != null) {
                this.poi.close();
            }
            this.poi = null;
            this.binning = 0;
            this.creationDate = null;
            this.uniqueZ = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        String[] files;
        boolean zFirst;
        super.initFile(id);
        this.imageFiles = new HashMap();
        this.timestamps = new HashMap();
        this.uniqueZ = new Vector();
        try {
            ServiceFactory factory = new ServiceFactory();
            this.poi = factory.getInstance(POIService.class);
        }
        catch (DependencyException de) {
            throw new FormatException("POI library not found", de);
        }
        this.poi.initialize(Location.getMappedId(this.currentId));
        double scaleFactor = 1.0;
        Vector<String> allFiles = this.poi.getDocumentList();
        if (allFiles.size() == 0) {
            throw new FormatException("No files were found - the .cxd may be corrupt.");
        }
        double firstZ = 0.0;
        double secondZ = 0.0;
        for (String name : allFiles) {
            RandomAccessInputStream stream;
            block30: {
                String relativePath;
                block37: {
                    double zPos;
                    block38: {
                        block36: {
                            String parent;
                            block35: {
                                block34: {
                                    block33: {
                                        int bits;
                                        block32: {
                                            block31: {
                                                block29: {
                                                    int separator = name.lastIndexOf(File.separator);
                                                    parent = name.substring(0, separator);
                                                    relativePath = name.substring(separator + 1);
                                                    stream = null;
                                                    if (!(relativePath.startsWith("Bitmap") || relativePath.equals("Data") && parent.indexOf("Image") != -1)) {
                                                        stream = this.poi.getDocumentStream(name);
                                                        stream.order(true);
                                                    }
                                                    if (stream != null && stream.length() == 8L) {
                                                        double value = stream.readDouble();
                                                        stream.seek(0L);
                                                        String key = name.replace(File.separatorChar, ' ');
                                                        key = key.replaceAll("Root Entry ", "");
                                                        key = key.replaceAll("Field Data ", "");
                                                        key = key.replaceAll("Details ", "");
                                                        this.addGlobalMeta(key, value);
                                                    }
                                                    if (!relativePath.equals("Field Count")) break block29;
                                                    this.core[0].imageCount = stream.readInt();
                                                    break block30;
                                                }
                                                if (!relativePath.equals("File Has Image")) break block31;
                                                if (stream.readShort() == 0) {
                                                    throw new FormatException("This file does not contain image data.");
                                                }
                                                break block30;
                                            }
                                            if (!relativePath.startsWith("Bitmap") && (!relativePath.equals("Data") || parent.indexOf("Image") == -1)) break block32;
                                            this.imageFiles.put(this.imageFiles.size(), name);
                                            if (this.getSizeX() == 0 || this.getSizeY() == 0) break block30;
                                            int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
                                            int plane = this.getSizeX() * this.getSizeY() * bpp;
                                            if (this.getSizeC() != 0) break block30;
                                            this.core[0].sizeC = this.poi.getFileSize(name) / plane;
                                            break block30;
                                        }
                                        if (relativePath.indexOf("Image_Depth") == -1) break block33;
                                        boolean firstBits = this.core[0].bitsPerPixel == 0;
                                        this.core[0].bitsPerPixel = bits = (int)stream.readDouble();
                                        while (bits % 8 != 0 || bits == 0) {
                                            ++bits;
                                        }
                                        if (bits % 3 == 0) {
                                            this.core[0].sizeC = 3;
                                            bits /= 3;
                                            this.core[0].bitsPerPixel /= 3;
                                        }
                                        this.core[0].pixelType = FormatTools.pixelTypeFromBytes(bits /= 8, false, false);
                                        if (this.getSizeC() > 1 && firstBits) {
                                            this.core[0].sizeC /= bits;
                                        }
                                        break block30;
                                    }
                                    if (relativePath.indexOf("Image_Height") == -1 || this.getSizeY() != 0) break block34;
                                    this.core[0].sizeY = (int)stream.readDouble();
                                    break block30;
                                }
                                if (relativePath.indexOf("Image_Width") == -1 || this.getSizeX() != 0) break block35;
                                this.core[0].sizeX = (int)stream.readDouble();
                                break block30;
                            }
                            if (relativePath.indexOf("Time_From_Start") == -1) break block36;
                            this.timestamps.put(this.getTimestampIndex(parent), stream.readDouble());
                            break block30;
                        }
                        if (relativePath.indexOf("Position_Z") == -1) break block37;
                        zPos = stream.readDouble();
                        if (!this.uniqueZ.contains(zPos)) {
                            this.uniqueZ.add(zPos);
                        }
                        if (name.indexOf("Field 1/") == -1) break block38;
                        firstZ = zPos;
                        break block30;
                    }
                    if (name.indexOf("Field 2/") == -1) break block30;
                    secondZ = zPos;
                    break block30;
                }
                if (relativePath.equals("First Field Date & Time")) {
                    long date = (long)stream.readDouble() * 1000L;
                    this.creationDate = DateTools.convertDate(date, 1);
                } else if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                    if (relativePath.equals("Binning")) {
                        this.binning = (int)stream.readDouble();
                    } else if (relativePath.equals("Comments")) {
                        String[] lines;
                        String comments = stream.readString((int)stream.length());
                        for (String line : lines = comments.split("\n")) {
                            int eq = line.indexOf("=");
                            if (eq == -1) continue;
                            String key = line.substring(0, eq).trim();
                            String value = line.substring(eq + 1).trim();
                            this.addGlobalMeta(key, value);
                            if (!key.equals("factor")) continue;
                            if (value.indexOf(";") != -1) {
                                value = value.substring(0, value.indexOf(";"));
                            }
                            scaleFactor = Double.parseDouble(value.trim());
                        }
                    }
                }
            }
            if (stream == null) continue;
            stream.close();
        }
        boolean bl = zFirst = !new Double(firstZ).equals(new Double(secondZ));
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        this.core[0].sizeZ = this.uniqueZ.size() == 0 ? 1 : this.uniqueZ.size();
        this.core[0].sizeT = this.getImageCount() / this.getSizeZ();
        boolean bl2 = this.core[0].rgb = this.getSizeC() > 1;
        if (this.imageFiles.size() > this.getImageCount() && this.getSizeC() == 1) {
            this.core[0].sizeC = this.imageFiles.size() / this.getImageCount();
            this.core[0].imageCount *= this.getSizeC();
        } else {
            this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        }
        this.core[0].interleaved = false;
        this.core[0].dimensionOrder = zFirst ? "XYCZT" : "XYCTZ";
        this.core[0].littleEndian = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        for (String file2 : files = this.imageFiles.values().toArray(new String[this.imageFiles.size()])) {
            int separator = file2.lastIndexOf(File.separator);
            String parent = file2.substring(0, separator);
            this.imageFiles.put(this.getImageIndex(parent), file2);
        }
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        if (this.creationDate != null) {
            store.setImageAcquiredDate(this.creationDate, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, id, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setPixelsPhysicalSizeX(new PositiveFloat(scaleFactor), 0);
            store.setPixelsPhysicalSizeY(new PositiveFloat(scaleFactor), 0);
            for (int i = 0; i < this.timestamps.size(); ++i) {
                Double timestamp = new Double(this.timestamps.get(i));
                store.setPlaneDeltaT(timestamp, 0, i);
                if (i != 2) continue;
                double first = this.timestamps.get(1);
                Double increment = new Double(timestamp - first);
                store.setPixelsTimeIncrement(increment, 0);
            }
            if (this.binning > 0) {
                String instrumentID = MetadataTools.createLSID("Instrument", 0);
                String detectorID = MetadataTools.createLSID("Detector", 0);
                store.setInstrumentID(instrumentID, 0);
                store.setDetectorID(detectorID, 0, 0);
                store.setDetectorType(this.getDetectorType("Other"), 0, 0);
                store.setImageInstrumentRef(instrumentID, 0);
                for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                    store.setDetectorSettingsID(detectorID, 0, c);
                    store.setDetectorSettingsBinning(this.getBinning(this.binning + "x" + this.binning), 0, c);
                }
            }
        }
    }

    private Integer getImageIndex(String path) {
        int space = path.lastIndexOf(" ") + 1;
        if (space >= path.length()) {
            return null;
        }
        int end = path.indexOf(File.separator, space);
        String field = path.substring(space, end);
        String image = "1";
        int imageIndex = path.indexOf("Image") + 5;
        if (imageIndex >= 0) {
            end = path.indexOf(File.separator, imageIndex);
            if (end < 0) {
                end = path.length();
            }
            image = path.substring(imageIndex, end);
        }
        try {
            int channel = Integer.parseInt(image) - 1;
            return this.getEffectiveSizeC() * (Integer.parseInt(field) - 1) + channel;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Integer getTimestampIndex(String path) {
        int space = path.lastIndexOf(" ") + 1;
        if (space >= path.length()) {
            return null;
        }
        int end = path.indexOf(File.separator, space);
        return Integer.parseInt(path.substring(space, end)) - 1;
    }
}

