/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.IMinMaxStore;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;

public class DeltavisionReader
extends FormatReader {
    public static final int DV_MAGIC_BYTES_1 = 41152;
    public static final int DV_MAGIC_BYTES_2 = 49312;
    public static final String DATE_FORMAT = "EEE MMM  d HH:mm:ss yyyy";
    private static final short LITTLE_ENDIAN = -16224;
    private static final int HEADER_LENGTH = 1024;
    private static final String[] IMAGE_TYPES = new String[]{"normal", "Tilt-series", "Stereo tilt-series", "Averaged images", "Averaged stereo pairs"};
    private int extSize;
    protected int wSize;
    protected int zSize;
    protected int tSize;
    protected int numIntsPerSection;
    protected int numFloatsPerSection;
    protected DVExtHdrFields[][][] extHdrFields = null;
    private Double[] ndFilters;
    private int[] lengths;
    private String logFile;
    private String deconvolutionLogFile;

    public DeltavisionReader() {
        super("Deltavision", new String[]{"dv", "r3d", "r3d_d3d", "dv.log", "r3d.log"});
        this.suffixNecessary = false;
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public boolean isThisType(String name, boolean open) {
        if (DeltavisionReader.checkSuffix(name, "dv.log") || DeltavisionReader.checkSuffix(name, "r3d.log") || name.endsWith("_log.txt")) {
            return true;
        }
        if (DeltavisionReader.checkSuffix(name, "pnl")) {
            return false;
        }
        return super.isThisType(name, open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 98;
        if (!FormatTools.validStream(stream, 98, false)) {
            return false;
        }
        stream.seek(96L);
        int magic = stream.readShort() & 0xFFFF;
        return magic == 41152 || magic == 49312;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        if (!noPixels) {
            files.add(this.currentId);
        }
        if (this.logFile != null) {
            files.add(this.logFile);
        }
        if (this.deconvolutionLogFile != null) {
            files.add(this.deconvolutionLogFile);
        }
        return files.toArray(new String[files.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int[] coords = this.getZCTCoords(no);
        int[] newCoords = new int[4];
        int coordIndex = 0;
        int dimIndex = 2;
        while (coordIndex < newCoords.length) {
            char dim = this.getDimensionOrder().charAt(dimIndex++);
            switch (dim) {
                case 'Z': {
                    newCoords[coordIndex++] = coords[0];
                    break;
                }
                case 'C': {
                    newCoords[coordIndex++] = coords[1];
                    break;
                }
                case 'T': {
                    newCoords[coordIndex++] = this.getSeries();
                    newCoords[coordIndex++] = coords[2];
                }
            }
        }
        int planeIndex = FormatTools.positionToRaster(this.lengths, newCoords);
        long planeSize = FormatTools.getPlaneSize(this);
        long planeOffset = planeSize * (long)planeIndex;
        long offset = planeOffset + 1024L + (long)this.extSize;
        if (offset < this.in.length()) {
            this.in.seek((long)(1024 + this.extSize) + planeOffset);
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.tSize = 0;
            this.zSize = 0;
            this.wSize = 0;
            this.extSize = 0;
            this.numFloatsPerSection = 0;
            this.numIntsPerSection = 0;
            this.extHdrFields = null;
            this.ndFilters = null;
            this.deconvolutionLogFile = null;
            this.logFile = null;
            this.lengths = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (!DeltavisionReader.checkSuffix(id, "dv")) {
            if (DeltavisionReader.checkSuffix(id, "dv.log") || DeltavisionReader.checkSuffix(id, "r3d.log")) {
                id = id.substring(0, id.lastIndexOf("."));
            } else if (id.endsWith("_log.txt")) {
                id = id.substring(0, id.lastIndexOf("_")) + ".dv";
            }
            Location file2 = new Location(id).getAbsoluteFile();
            if (!file2.exists()) {
                Location dir = file2.getParentFile();
                String[] list = dir.list(true);
                String name = file2.getName();
                name = name.substring(0, name.lastIndexOf("."));
                for (String f : list) {
                    if (!DeltavisionReader.checkSuffix(f, "dv") || !f.startsWith(name)) continue;
                    id = new Location(dir, f).getAbsolutePath();
                    break;
                }
            }
        }
        super.initFile(id);
        this.findLogFiles();
        this.in = new RandomAccessInputStream(this.currentId);
        this.initPixels();
        MetadataLevel metadataLevel = this.metadataOptions.getMetadataLevel();
        if (metadataLevel != MetadataLevel.MINIMUM) {
            this.initExtraMetadata();
        }
    }

    protected void initPixels() throws FormatException, IOException {
        LOGGER.info("Reading header");
        MetadataStore store = this.makeFilterMetadata();
        this.in.seek(96L);
        this.in.order(true);
        boolean little = this.in.readShort() == -16224;
        this.in.order(little);
        this.in.seek(0L);
        int sizeX = this.in.readInt();
        int sizeY = this.in.readInt();
        int imageCount = this.in.readInt();
        int filePixelType = this.in.readInt();
        this.in.seek(180L);
        int rawSizeT = this.in.readShort();
        int sizeT = rawSizeT == 0 ? 1 : rawSizeT;
        short sequence = this.in.readShort();
        this.in.seek(92L);
        this.extSize = this.in.readInt();
        this.in.seek(196L);
        short rawSizeC = this.in.readShort();
        short sizeC = rawSizeC == 0 ? (short)1 : rawSizeC;
        String imageSequence = this.getImageSequence(sequence);
        int sizeZ = imageCount / (sizeC * sizeT);
        LOGGER.info("Populating core metadata");
        this.core[0].littleEndian = little;
        this.core[0].sizeX = sizeX;
        this.core[0].sizeY = sizeY;
        this.core[0].imageCount = imageCount;
        String pixel = this.getPixelString(filePixelType);
        this.core[0].pixelType = this.getPixelType(filePixelType);
        this.core[0].dimensionOrder = "XY" + imageSequence.replaceAll("W", "C");
        int planeSize = this.getSizeX() * this.getSizeY() * FormatTools.getBytesPerPixel(this.getPixelType());
        int realPlaneCount = (int)((this.in.length() - 1024L - (long)this.extSize) / (long)planeSize);
        if (realPlaneCount < this.getImageCount()) {
            LOGGER.debug("Truncated file");
            this.core[0].imageCount = realPlaneCount;
            if (sizeZ == 1) {
                sizeT = realPlaneCount / sizeC;
            } else if (sizeT == 1) {
                sizeZ = realPlaneCount / sizeC;
                if (realPlaneCount % sizeC != 0) {
                    this.core[0].imageCount = ++sizeZ * sizeC;
                }
            } else if (this.getDimensionOrder().indexOf("Z") < this.getDimensionOrder().indexOf("T")) {
                sizeZ = realPlaneCount / (sizeC * sizeT);
                if (sizeZ == 0) {
                    sizeT = 1;
                    sizeZ = realPlaneCount / sizeC;
                    if (realPlaneCount % sizeC != 0) {
                        this.core[0].imageCount = ++sizeZ * sizeC;
                    }
                }
                if (this.getImageCount() > sizeZ * sizeC * sizeT) {
                    this.core[0].imageCount = imageCount;
                    sizeC = rawSizeC == 0 ? (short)1 : rawSizeC;
                    sizeT = rawSizeT == 0 ? 1 : rawSizeT;
                    sizeZ = this.getImageCount() / (sizeC * sizeT);
                }
            } else {
                sizeT = realPlaneCount / (sizeC * sizeZ);
            }
        }
        this.core[0].sizeT = sizeT;
        this.core[0].sizeC = sizeC;
        this.core[0].sizeZ = sizeZ;
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.in.seek(128L);
        this.numIntsPerSection = this.in.readShort();
        this.numFloatsPerSection = this.in.readShort();
        LOGGER.info("Reading extended header");
        this.setOffsetInfo(sequence, this.getSizeZ(), this.getSizeC(), this.getSizeT());
        this.extHdrFields = new DVExtHdrFields[this.getSizeZ()][this.getSizeC()][this.getSizeT()];
        this.ndFilters = new Double[this.getSizeC()];
        Vector<Float> uniqueTileX = new Vector<Float>();
        Vector<Float> uniqueTileY = new Vector<Float>();
        int offset = 1024 + this.numIntsPerSection * 4;
        for (int i = 0; i < this.getImageCount(); ++i) {
            DVExtHdrFields hdr;
            int[] coords = this.getZCTCoords(i);
            int z = coords[0];
            int w = coords[1];
            int t = coords[2];
            this.in.seek(offset + this.getTotalOffset(z, w, t));
            this.extHdrFields[z][w][t] = hdr = new DVExtHdrFields(this.in);
            if (!uniqueTileX.contains(Float.valueOf(hdr.stageXCoord))) {
                uniqueTileX.add(Float.valueOf(hdr.stageXCoord));
            }
            if (uniqueTileY.contains(Float.valueOf(hdr.stageYCoord))) continue;
            uniqueTileY.add(Float.valueOf(hdr.stageYCoord));
        }
        int nStagePositions = uniqueTileX.size() * uniqueTileY.size();
        if (nStagePositions > 0 && nStagePositions <= this.getSizeT()) {
            int t = this.getSizeT();
            this.core[0].sizeT /= nStagePositions;
            if (this.getSizeT() * nStagePositions != t) {
                this.core[0].sizeT = t;
                nStagePositions = 1;
            } else {
                this.core[0].imageCount /= nStagePositions;
            }
            if (nStagePositions > 1) {
                CoreMetadata originalCore = this.core[0];
                this.core = new CoreMetadata[nStagePositions];
                for (int i = 0; i < this.core.length; ++i) {
                    this.core[i] = originalCore;
                }
            }
        }
        this.lengths = new int[4];
        int lengthIndex = 0;
        int dimIndex = 0;
        while (lengthIndex < this.lengths.length) {
            char dim = imageSequence.charAt(dimIndex++);
            switch (dim) {
                case 'Z': {
                    this.lengths[lengthIndex++] = this.getSizeZ();
                    break;
                }
                case 'W': {
                    this.lengths[lengthIndex++] = this.getSizeC();
                    break;
                }
                case 'T': {
                    this.lengths[lengthIndex++] = this.getSeriesCount();
                    this.lengths[lengthIndex++] = this.getSizeT();
                }
            }
        }
        LOGGER.info("Populating original metadata");
        this.addGlobalMeta("ImageWidth", sizeX);
        this.addGlobalMeta("ImageHeight", sizeY);
        this.addGlobalMeta("NumberOfImages", imageCount);
        this.addGlobalMeta("PixelType", pixel);
        this.addGlobalMeta("Number of timepoints", rawSizeT);
        this.addGlobalMeta("Image sequence", imageSequence);
        this.addGlobalMeta("Number of wavelengths", (int)rawSizeC);
        this.addGlobalMeta("Number of focal planes", sizeZ);
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            this.setSeries(series);
            for (int plane = 0; plane < this.getImageCount(); ++plane) {
                int[] coords = this.getZCTCoords(plane);
                int tIndex = this.getSeriesCount() * coords[2] + series;
                DVExtHdrFields hdr = this.extHdrFields[coords[0]][coords[1]][tIndex];
                String prefix = "Extended header Z" + coords[0] + " W" + coords[1] + " T" + coords[2];
                this.addSeriesMeta(prefix, hdr);
                String position = " position for position #" + (series + 1);
                this.addGlobalMeta("X" + position, hdr.stageXCoord);
                this.addGlobalMeta("Y" + position, hdr.stageYCoord);
                this.addGlobalMeta("Z" + position, hdr.stageZCoord);
            }
        }
        this.setSeries(0);
        LOGGER.info("Populating OME metadata");
        MetadataTools.populatePixels(store, this, true);
        MetadataTools.setDefaultCreationDate(store, this.currentId, 0);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageInstrumentRef(instrumentID, i);
        }
    }

    protected void initExtraMetadata() throws FormatException, IOException {
        boolean logFound;
        int i;
        int i2;
        MetadataStore store = this.makeFilterMetadata();
        LOGGER.info("Reading header");
        this.in.seek(16L);
        int subImageStartX = this.in.readInt();
        int subImageStartY = this.in.readInt();
        int subImageStartZ = this.in.readInt();
        int pixelSamplingX = this.in.readInt();
        int pixelSamplingY = this.in.readInt();
        int pixelSamplingZ = this.in.readInt();
        float pixX = this.in.readFloat();
        float pixY = this.in.readFloat();
        float pixZ = this.in.readFloat();
        float xAxisAngle = this.in.readFloat();
        float yAxisAngle = this.in.readFloat();
        float zAxisAngle = this.in.readFloat();
        int xAxisSeq = this.in.readInt();
        int yAxisSeq = this.in.readInt();
        int zAxisSeq = this.in.readInt();
        float[] minWave = new float[5];
        float[] maxWave = new float[5];
        minWave[0] = this.in.readFloat();
        maxWave[0] = this.in.readFloat();
        float meanIntensity = this.in.readFloat();
        int spaceGroupNumber = this.in.readInt();
        this.in.seek(132L);
        short numSubResSets = this.in.readShort();
        short zAxisReductionQuotient = this.in.readShort();
        for (int i3 = 1; i3 <= 3; ++i3) {
            minWave[i3] = this.in.readFloat();
            maxWave[i3] = this.in.readFloat();
        }
        short type = this.in.readShort();
        short lensID = this.in.readShort();
        this.in.seek(172L);
        minWave[4] = this.in.readFloat();
        maxWave[4] = this.in.readFloat();
        this.in.seek(184L);
        float xTiltAngle = this.in.readFloat();
        float yTiltAngle = this.in.readFloat();
        float zTiltAngle = this.in.readFloat();
        this.in.skipBytes(2);
        short[] waves = new short[5];
        for (int i4 = 0; i4 < waves.length; ++i4) {
            waves[i4] = this.in.readShort();
        }
        float xOrigin = this.in.readFloat();
        float yOrigin = this.in.readFloat();
        float zOrigin = this.in.readFloat();
        this.in.skipBytes(4);
        String[] title = new String[10];
        for (int i5 = 0; i5 < title.length; ++i5) {
            title[i5] = this.in.readString(80).replaceAll("\u0000", "");
        }
        String imageType = type < IMAGE_TYPES.length ? IMAGE_TYPES[type] : "unknown";
        String imageDesc = title[0];
        if (imageDesc != null && imageDesc.length() == 0) {
            imageDesc = null;
        }
        LOGGER.info("Populating original metadata");
        this.addGlobalMeta("Sub-image starting point (X)", subImageStartX);
        this.addGlobalMeta("Sub-image starting point (Y)", subImageStartY);
        this.addGlobalMeta("Sub-image starting point (Z)", subImageStartZ);
        this.addGlobalMeta("Pixel sampling size (X)", pixelSamplingX);
        this.addGlobalMeta("Pixel sampling size (Y)", pixelSamplingY);
        this.addGlobalMeta("Pixel sampling size (Z)", pixelSamplingZ);
        this.addGlobalMeta("X element length (in um)", pixX);
        this.addGlobalMeta("Y element length (in um)", pixY);
        this.addGlobalMeta("Z element length (in um)", pixZ);
        this.addGlobalMeta("X axis angle", xAxisAngle);
        this.addGlobalMeta("Y axis angle", yAxisAngle);
        this.addGlobalMeta("Z axis angle", zAxisAngle);
        this.addGlobalMeta("Column axis sequence", xAxisSeq);
        this.addGlobalMeta("Row axis sequence", yAxisSeq);
        this.addGlobalMeta("Section axis sequence", zAxisSeq);
        this.addGlobalMeta("Image Type", imageType);
        this.addGlobalMeta("Lens ID Number", (int)lensID);
        this.addGlobalMeta("X axis tilt angle", xTiltAngle);
        this.addGlobalMeta("Y axis tilt angle", yTiltAngle);
        this.addGlobalMeta("Z axis tilt angle", zTiltAngle);
        for (i2 = 0; i2 < waves.length; ++i2) {
            this.addGlobalMeta("Wavelength " + (i2 + 1) + " (in nm)", waves[i2]);
        }
        this.addGlobalMeta("X origin (in um)", xOrigin);
        this.addGlobalMeta("Y origin (in um)", yOrigin);
        this.addGlobalMeta("Z origin (in um)", zOrigin);
        for (i2 = 0; i2 < title.length; ++i2) {
            this.addGlobalMeta("Title " + (i2 + 1), title[i2]);
        }
        for (i2 = 0; i2 < minWave.length; ++i2) {
            this.addGlobalMeta("Wavelength " + (i2 + 1) + " min. intensity", minWave[i2]);
            this.addGlobalMeta("Wavelength " + (i2 + 1) + " max. intensity", maxWave[i2]);
        }
        this.addGlobalMeta("Wavelength 1 mean intensity", meanIntensity);
        this.addGlobalMeta("Space group number", spaceGroupNumber);
        this.addGlobalMeta("Number of Sub-resolution sets", numSubResSets);
        this.addGlobalMeta("Z axis reduction quotient", zAxisReductionQuotient);
        LOGGER.info("Populating OME metadata");
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            if (store instanceof IMinMaxStore) {
                IMinMaxStore minMaxStore = (IMinMaxStore)((Object)store);
                for (i = 0; i < minWave.length; ++i) {
                    if (i >= this.getEffectiveSizeC()) continue;
                    minMaxStore.setChannelGlobalMinMax(i, minWave[i], maxWave[i], series);
                }
            }
            store.setPixelsPhysicalSizeX(new PositiveFloat(new Double(pixX)), series);
            store.setPixelsPhysicalSizeY(new PositiveFloat(new Double(pixY)), series);
            store.setPixelsPhysicalSizeZ(new PositiveFloat(new Double(pixZ)), series);
            store.setImageDescription(imageDesc, series);
        }
        boolean bl = logFound = this.isGroupFiles() ? this.parseLogFile(store) : false;
        if (this.isGroupFiles()) {
            this.parseDeconvolutionLog(store);
        }
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            for (i = 0; i < this.getImageCount(); ++i) {
                int[] coords = this.getZCTCoords(i);
                int tIndex = this.getSeriesCount() * coords[2] + series;
                DVExtHdrFields hdr = this.extHdrFields[coords[0]][coords[1]][tIndex];
                if (!logFound) {
                    store.setPlaneDeltaT(new Double(hdr.timeStampSeconds), series, i);
                }
                store.setPlaneExposureTime(new Double(hdr.expTime), series, i);
                if (logFound && this.getSeriesCount() <= 1) continue;
                store.setPlanePositionX(new Double(hdr.stageXCoord), series, i);
                store.setPlanePositionY(new Double(hdr.stageYCoord), series, i);
                store.setPlanePositionZ(new Double(hdr.stageZCoord), series, i);
            }
            for (int w = 0; w < this.getSizeC(); ++w) {
                DVExtHdrFields hdrC = this.extHdrFields[0][w][series];
                if (waves[w] > 0) {
                    store.setChannelEmissionWavelength(new PositiveInteger(Integer.valueOf(waves[w])), series, w);
                }
                if ((int)hdrC.exWavelen > 0) {
                    store.setChannelExcitationWavelength(new PositiveInteger((int)hdrC.exWavelen), series, w);
                }
                if (this.ndFilters[w] == null) {
                    this.ndFilters[w] = new Double(hdrC.ndFilter);
                }
                store.setChannelNDFilter(this.ndFilters[w], series, w);
            }
        }
    }

    private String getPixelString(int filePixelType) {
        switch (filePixelType) {
            case 0: {
                return "8 bit unsigned integer";
            }
            case 1: {
                return "16 bit signed integer";
            }
            case 2: {
                return "32 bit floating point";
            }
            case 3: {
                return "16 bit complex";
            }
            case 4: {
                return "64 bit complex";
            }
            case 6: {
                return "16 bit unsigned integer";
            }
        }
        return "unknown";
    }

    private int getPixelType(int filePixelType) {
        switch (filePixelType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 6;
            }
            case 6: {
                return 3;
            }
        }
        return 1;
    }

    private String getImageSequence(int imageSequence) {
        switch (imageSequence) {
            case 0: {
                return "ZTW";
            }
            case 1: {
                return "WZT";
            }
            case 2: {
                return "ZWT";
            }
            case 65536: {
                return "WZT";
            }
        }
        return "ZTW";
    }

    private void setOffsetInfo(int imgSequence, int numZSections, int numWaves, int numTimes) {
        int smallOffset = (this.numIntsPerSection + this.numFloatsPerSection) * 4;
        switch (imgSequence) {
            case 0: {
                this.zSize = smallOffset;
                this.tSize = this.zSize * numZSections;
                this.wSize = this.tSize * numTimes;
                break;
            }
            case 1: {
                this.wSize = smallOffset;
                this.zSize = this.wSize * numWaves;
                this.tSize = this.zSize * numZSections;
                break;
            }
            case 2: {
                this.zSize = smallOffset;
                this.wSize = this.zSize * numZSections;
                this.tSize = this.wSize * numWaves;
            }
        }
    }

    private int getTotalOffset(int currentZ, int currentW, int currentT) {
        return this.zSize * currentZ + this.wSize * currentW + this.tSize * currentT;
    }

    private void findLogFiles() throws IOException {
        if (this.getCurrentFile().lastIndexOf(".") == -1) {
            this.logFile = null;
            this.deconvolutionLogFile = null;
            return;
        }
        if (this.getCurrentFile().endsWith("_D3D.dv")) {
            this.logFile = this.getCurrentFile();
            this.logFile = this.logFile.substring(0, this.logFile.indexOf("_D3D.dv")) + ".dv.log";
        } else {
            this.logFile = this.getCurrentFile() + ".log";
            if (!new Location(this.logFile).exists()) {
                this.logFile = this.getCurrentFile();
                this.logFile = this.logFile.substring(0, this.logFile.lastIndexOf(".")) + ".log";
            }
        }
        if (!new Location(this.logFile).exists()) {
            this.logFile = null;
        }
        int dot = this.getCurrentFile().lastIndexOf(".");
        String base = this.getCurrentFile().substring(0, dot);
        this.deconvolutionLogFile = base + "_log.txt";
        if (!new Location(this.deconvolutionLogFile).exists()) {
            this.deconvolutionLogFile = null;
        }
    }

    private boolean parseLogFile(MetadataStore store) throws FormatException, IOException {
        if (this.logFile == null || !new Location(this.logFile).exists()) {
            this.logFile = null;
            return false;
        }
        LOGGER.info("Parsing log file");
        String[] lines = DataTools.readFile(this.logFile).split("[\r\n]");
        String value = "";
        String prefix = "";
        int currentImage = 0;
        for (String line : lines) {
            String date;
            int colon = line.indexOf(":");
            if (colon != -1) {
                String key;
                if (line.startsWith("Created")) {
                    key = "Created";
                    colon = 6;
                } else {
                    key = line.substring(0, colon).trim();
                }
                value = line.substring(colon + 1).trim();
                if (value.equals("") && !key.equals("")) {
                    prefix = key;
                }
                this.addGlobalMeta(prefix + " " + key, value);
                if (key.equals("Objective")) {
                    int space = value.indexOf(" ");
                    if (space == -1) continue;
                    String manufacturer = value.substring(0, space);
                    String extra = value.substring(space + 1);
                    String[] tokens = extra.split(",");
                    store.setObjectiveManufacturer(manufacturer, 0, 0);
                    String magnification = "";
                    String na = "";
                    if (tokens.length >= 1) {
                        int start;
                        int end = tokens[0].indexOf("X");
                        if (end > 0) {
                            magnification = tokens[0].substring(0, end);
                        }
                        if ((start = tokens[0].indexOf("/")) >= 0) {
                            na = tokens[0].substring(start + 1);
                        }
                    }
                    try {
                        store.setObjectiveNominalMagnification(PositiveInteger.valueOf(magnification), 0, 0);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse magnification '{}'", (Object)magnification);
                    }
                    try {
                        store.setObjectiveLensNA(new Double(na), 0, 0);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse N.A. '{}'", (Object)na);
                    }
                    if (tokens.length >= 2) {
                        store.setObjectiveCorrection(this.getCorrection(tokens[1]), 0, 0);
                    }
                    if (tokens.length <= 3) continue;
                    store.setObjectiveModel(tokens[3], 0, 0);
                    continue;
                }
                if (key.equals("Lens ID")) {
                    if (value.indexOf(",") != -1) {
                        value = value.substring(0, value.indexOf(","));
                    }
                    String objectiveID = "Objective:" + value;
                    store.setObjectiveID(objectiveID, 0, 0);
                    for (int series = 0; series < this.getSeriesCount(); ++series) {
                        store.setImageObjectiveSettingsID(objectiveID, series);
                    }
                    store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
                    store.setObjectiveImmersion(this.getImmersion("Other"), 0, 0);
                    continue;
                }
                if (key.equals("Pixel Size")) {
                    String[] pixelSizes = value.split(" ");
                    for (int q = 0; q < pixelSizes.length; ++q) {
                        Double size = null;
                        try {
                            size = new Double(pixelSizes[q].trim());
                        }
                        catch (NumberFormatException e) {
                            LOGGER.warn("Could not parse pixel size '{}'", (Object)pixelSizes[q].trim());
                        }
                        if (q == 0) {
                            for (int series = 0; series < this.getSeriesCount(); ++series) {
                                store.setPixelsPhysicalSizeX(new PositiveFloat(size), series);
                            }
                        }
                        if (q == 1) {
                            for (int series = 0; series < this.getSeriesCount(); ++series) {
                                store.setPixelsPhysicalSizeY(new PositiveFloat(size), series);
                            }
                        }
                        if (q != 2) continue;
                        for (int series = 0; series < this.getSeriesCount(); ++series) {
                            store.setPixelsPhysicalSizeZ(new PositiveFloat(size), series);
                        }
                    }
                    continue;
                }
                if (key.equals("Binning")) {
                    store.setDetectorType(this.getDetectorType("Other"), 0, 0);
                    String detectorID = MetadataTools.createLSID("Detector", 0, 0);
                    store.setDetectorID(detectorID, 0, 0);
                    for (int series = 0; series < this.getSeriesCount(); ++series) {
                        for (int c = 0; c < this.getSizeC(); ++c) {
                            store.setDetectorSettingsBinning(this.getBinning(value), series, c);
                            store.setDetectorSettingsID(detectorID, series, c);
                        }
                    }
                    continue;
                }
                if (key.equals("Type")) {
                    store.setDetectorModel(value, 0, 0);
                    continue;
                }
                if (key.equals("Gain")) {
                    value = value.replaceAll("X", "");
                    try {
                        for (int series = 0; series < this.getSeriesCount(); ++series) {
                            for (int c = 0; c < this.getSizeC(); ++c) {
                                store.setDetectorSettingsGain(new Double(value), series, c);
                            }
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse gain '{}'", (Object)value);
                        continue;
                    }
                }
                if (key.equals("Speed")) {
                    value = value.replaceAll("KHz", "");
                    try {
                        double mhz = Double.parseDouble(value) / 1000.0;
                        for (int series = 0; series < this.getSeriesCount(); ++series) {
                            for (int c = 0; c < this.getSizeC(); ++c) {
                                store.setDetectorSettingsReadOutRate(mhz, series, c);
                            }
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse read-out rate '{}'", (Object)value);
                        continue;
                    }
                }
                if (key.equals("Temp Setting")) {
                    value = value.replaceAll("C", "").trim();
                    continue;
                }
                if (key.equals("Time Point")) {
                    int space = value.indexOf(" ");
                    if (space >= 0) {
                        value = value.substring(0, space);
                    }
                    try {
                        if (currentImage >= this.getImageCount()) continue;
                        for (int series = 0; series < this.getSeriesCount(); ++series) {
                            store.setPlaneDeltaT(new Double(value), series, currentImage);
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse timestamp '{}'", (Object)value);
                        continue;
                    }
                }
                if (key.equals("EM filter")) {
                    int cIndex = 0;
                    try {
                        cIndex = this.getZCTCoords(currentImage)[1];
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.debug("", e);
                    }
                    for (int series = 0; series < this.getSeriesCount(); ++series) {
                        store.setChannelName(value, series, cIndex);
                    }
                    continue;
                }
                if (key.equals("ND filter")) {
                    value = value.replaceAll("%", "");
                    try {
                        int cIndex = this.getZCTCoords(currentImage)[1];
                        double nd = Double.parseDouble(value);
                        this.ndFilters[cIndex] = new Double(nd / 100.0);
                    }
                    catch (NumberFormatException exc) {
                        LOGGER.warn("Could not parse ND filter '{}'", (Object)value);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.debug("", e);
                    }
                    continue;
                }
                if (!key.equals("Stage coordinates")) continue;
                if (value.length() > 1) {
                    value = value.substring(1, value.length() - 1);
                }
                String[] coords = value.split(",");
                for (int i = 0; i < coords.length; ++i) {
                    Double p = null;
                    try {
                        p = new Double(coords[i].trim());
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse stage coordinate '{}'", (Object)coords[i]);
                    }
                    if (currentImage >= this.getImageCount() || this.getSeriesCount() != 1) continue;
                    if (i == 0) {
                        store.setPlanePositionX(p, 0, currentImage);
                    }
                    if (i == 1) {
                        store.setPlanePositionY(p, 0, currentImage);
                    }
                    if (i != 2) continue;
                    store.setPlanePositionZ(p, 0, currentImage);
                }
                ++currentImage;
                continue;
            }
            if (line.startsWith("Image")) {
                prefix = line;
                continue;
            }
            if (!line.startsWith("Created")) continue;
            if (line.length() > 8) {
                line = line.substring(8).trim();
            }
            if ((date = DateTools.formatDate(line, DATE_FORMAT)) != null) {
                for (int series = 0; series < this.getSeriesCount(); ++series) {
                    store.setImageAcquiredDate(date, series);
                }
                continue;
            }
            LOGGER.warn("Could not parse date '{}'", (Object)line);
        }
        return true;
    }

    private void parseDeconvolutionLog(MetadataStore store) throws IOException {
        if (this.deconvolutionLogFile == null || !new Location(this.deconvolutionLogFile).exists()) {
            return;
        }
        LOGGER.info("Parsing deconvolution log file");
        RandomAccessInputStream s = new RandomAccessInputStream(this.deconvolutionLogFile);
        boolean doStatistics = false;
        int cc = 0;
        int tt = 0;
        String previousLine = null;
        while (s.getFilePointer() < s.length() - 1L) {
            int index;
            String line = s.readLine();
            if (line == null || line.length() == 0) continue;
            if (doStatistics) {
                String[] keys = line.split("  ");
                Vector<String> realKeys = new Vector<String>();
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = keys[i].trim();
                    if (keys[i].length() <= 0) continue;
                    realKeys.add(keys[i]);
                }
                keys = realKeys.toArray(new String[0]);
                s.readLine();
                line = s.readLine().trim();
                while (line != null && line.length() != 0) {
                    String[] values = line.split(" ");
                    Vector<String> realValues = new Vector<String>();
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = values[i].trim();
                        if (values[i].length() <= 0) continue;
                        realValues.add(values[i]);
                    }
                    values = realValues.toArray(new String[0]);
                    try {
                        if (values.length > 0) {
                            int zz = Integer.parseInt(values[0]) - 1;
                            int index2 = this.getIndex(zz, cc, tt);
                            for (int i = 1; i < keys.length; ++i) {
                                this.addGlobalMeta("Plane " + index2 + " " + keys[i], values[i]);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse Z position '{}'", (Object)values[0]);
                    }
                    catch (IllegalArgumentException iae) {
                        LOGGER.debug("", iae);
                    }
                    line = s.readLine().trim();
                }
            } else {
                int index3 = line.indexOf(".\t");
                if (index3 != -1) {
                    String key = line.substring(0, index3).trim();
                    String value = line.substring(index3 + 2).trim();
                    while (key.endsWith(".")) {
                        key = key.substring(0, key.length() - 1);
                    }
                    if (previousLine != null && (previousLine.endsWith("Deconvolution Results:") || previousLine.endsWith("open OTF"))) {
                        this.addGlobalMeta(previousLine + " " + key, value);
                    } else {
                        this.addGlobalMeta(key, value);
                    }
                }
            }
            if (line.indexOf("correcting time point\t") != -1 && (index = line.indexOf("time point\t") + 11) > 10) {
                String t = line.substring(index, line.indexOf(",", index));
                try {
                    tt = Integer.parseInt(t) - 1;
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Could not parse timepoint '{}'", (Object)t);
                }
                index = line.indexOf("wavelength\t") + 11;
                if (index > 10) {
                    String c = line.substring(index, line.indexOf(".", index));
                    try {
                        cc = Integer.parseInt(c) - 1;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse channel position '{}'", (Object)c);
                    }
                }
            }
            if (line.length() > 0 && line.indexOf(".") == -1) {
                previousLine = line;
            }
            doStatistics = line.endsWith("- reading image data...");
        }
        s.close();
    }

    private void readWavelength(int channel, MetadataStore store) throws FormatException, IOException {
        float min = this.in.readFloat();
        float max = this.in.readFloat();
        this.addGlobalMeta("Wavelength " + (channel + 1) + " min. intensity", min);
        this.addGlobalMeta("Wavelength " + (channel + 1) + " max. intensity", max);
        if (store instanceof IMinMaxStore) {
            ((IMinMaxStore)((Object)store)).setChannelGlobalMinMax(channel, min, max, 0);
        }
    }

    private class DVExtHdrFields {
        private int offsetWithInts;
        public float photosensorReading;
        public float timeStampSeconds;
        public float stageXCoord;
        public float stageYCoord;
        public float stageZCoord;
        public float minInten;
        public float maxInten;
        public float expTime;
        public float ndFilter;
        public float exWavelen;
        public float emWavelen;
        public float intenScaling;
        public float energyConvFactor;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("photosensorReading: ");
            sb.append(this.photosensorReading);
            sb.append("\ntimeStampSeconds: ");
            sb.append(this.timeStampSeconds);
            sb.append("\nstageXCoord: ");
            sb.append(this.stageXCoord);
            sb.append("\nstageYCoord: ");
            sb.append(this.stageYCoord);
            sb.append("\nstageZCoord: ");
            sb.append(this.stageZCoord);
            sb.append("\nminInten: ");
            sb.append(this.minInten);
            sb.append("\nmaxInten: ");
            sb.append(this.maxInten);
            sb.append("\nexpTime: ");
            sb.append(this.expTime);
            sb.append("\nndFilter: ");
            sb.append(this.ndFilter);
            sb.append("\nexWavelen: ");
            sb.append(this.exWavelen);
            sb.append("\nemWavelen: ");
            sb.append(this.emWavelen);
            sb.append("\nintenScaling: ");
            sb.append(this.intenScaling);
            sb.append("\nenergyConvFactor: ");
            sb.append(this.energyConvFactor);
            return sb.toString();
        }

        private DVExtHdrFields(RandomAccessInputStream in) {
            try {
                this.photosensorReading = in.readFloat();
                this.timeStampSeconds = in.readFloat();
                this.stageXCoord = in.readFloat();
                this.stageYCoord = in.readFloat();
                this.stageZCoord = in.readFloat();
                this.minInten = in.readFloat();
                this.maxInten = in.readFloat();
                in.skipBytes(4);
                this.expTime = in.readFloat() / 1000.0f;
                this.ndFilter = in.readFloat() / 100.0f;
                this.exWavelen = in.readFloat();
                this.emWavelen = in.readFloat();
                this.intenScaling = in.readFloat();
                this.energyConvFactor = in.readFloat();
            }
            catch (IOException e) {
                LOGGER.debug("Could not parse extended header", e);
            }
        }
    }
}

