 %% Copyright (C) 2014  The University of New Mexico
 %   This library is free software; you can redistribute it and/or
 %   modify it under the terms of the GNU Lesser General Public
 %   License as published by the Free Software Foundation; either
 %   version 2.1 of the License, or (at your option) any later version.

 %   This library is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 %   Lesser General Public License for more details.

 %   You should have received a copy of the GNU Lesser General Public
 %   License along with this library; if not, write to the Free Software
 %   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

%% This code is optimized for faster computers. Please contact authors dbarto@unm.com 
% For version that will run on slower computers. 


%%
function varargout = SocialCodingAnalysis(varargin)
% SOCIALCODINGANALYSIS MATLAB code for SocialCodingAnalysis.fig
%      SOCIALCODINGANALYSIS, by itself, creates a new SOCIALCODINGANALYSIS or raises the existing
%      singleton*.
%
%      H = SOCIALCODINGANALYSIS returns the handle to a new SOCIALCODINGANALYSIS or the handle to
%      the existing singleton*.
%
%      SOCIALCODINGANALYSIS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SOCIALCODINGANALYSIS.M with the given input arguments.
%
%      SOCIALCODINGANALYSIS('Property','Value',...) creates a new SOCIALCODINGANALYSIS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before SocialCodingAnalysis_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to SocialCodingAnalysis_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help SocialCodingAnalysis

% Last Modified by GUIDE v2.5 05-Aug-2014 15:33:39

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @SocialCodingAnalysis_OpeningFcn, ...
                   'gui_OutputFcn',  @SocialCodingAnalysis_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before SocialCodingAnalysis is made visible.
function SocialCodingAnalysis_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to SocialCodingAnalysis (see VARARGIN)

% Choose default command line output for SocialCodingAnalysis
loadState(handles);
handles.reloadVideo=0;
handles.output = hObject;
handles.curFrame = 1;
handles.isPlaying = 0;
handles.speed = 0;
handles.videoName = 'Null';
handles.FrameRate = 0;
% Buttons Handles Structure
handles.b1 = 1;
handles.b2 = 1;
handles.b3 = 1;
handles.b4 = 1;
handles.b5 = 1 ;
handles.b6 = 1;
handles.b7 = 1;
handles.b8 = 1;
handles.b9 = 1;
handles.b10 = 1;
handles.b11 = 1;
      
% Update handles structure
guidata(hObject, handles);


% --- Outputs from this function are returned to the command line.
function varargout = SocialCodingAnalysis_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in vload.
function vload_Callback(hObject, eventdata, handles)
% hObject    handle to vload (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%Draw loading waitbar on screen
set(handles.Loadwait,'Visible','On');
warning off
%Open dialog box filtering results to mpeg and avi
[video, videoPath] =  uigetfile({'*.mp4;'});
videoName = strcat(videoPath, video);
    
%Build Video reader object and counter number of frames
try
handles.vobj = VideoReader(videoName);
catch
    set(handles.Loadwait,'String','Could Not Load Video')
    guidata(hObject, handles);
end
handles.videoName = get(handles.vobj,'Name');
handles.FrameRate = get(handles.vobj,'FrameRate');
handles.numFrames = get(handles.vobj,'NumberOfFrames');
%Handle Change to reset GUI on 2nd videoload
%set(handles.history,'String',new_name);

% Set min & max value for progress slider
set(handles.Progress,'Min',1);
set(handles.Progress,'Max',handles.numFrames);
% Enable Play Button
set(handles.vplay,'BackgroundColor',[.9 .9 .9])
set(handles.vplay,'Enable','On');
set(handles.vplay,'String','Play');
%Set Max Number of frames
set(handles.lastFrame,'String',handles.numFrames);
%Delete Loadbar
set(handles.Loadwait,'Visible','Off')
guidata(hObject, handles);



% --- Executes on button press in vplay.
function vplay_Callback(hObject, eventdata, handles)
% hObject    handle to vplay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.vplay,'UserData',[]);
handles.isPlaying = 1;
guidata(hObject, handles);

while handles.isPlaying == 1
    vidFrames = read(handles.vobj,[handles.curFrame]);
    imagesc(vidFrames);
    drawnow;
    handles.curFrame = handles.curFrame + 1;
    pause(handles.speed);
    guidata(hObject, handles);
    %Increment Progress Bar
    set(handles.Progress,'Value',handles.curFrame);
    %Increment Frame Counter
    set(handles.frameCounter,'String',handles.curFrame);
    %If Statement to Stop
    curval = get(handles.vplay,'UserData');
    guidata(hObject, handles);
    if ~isempty(curval) && strcmp(curval, 'stop')
        handles.isPlaying = 0;
        break;
    end
    %If Statement to restart
    if handles.curFrame == handles.numFrames;
        handles.curFrame = 1
    end
    
end

% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over Progress.
function Progress_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to Progress (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.vplay,'UserData','stop');
guidata(hObject, handles);


% --- Executes on slider movement.
function playback_Callback(hObject, eventdata, handles)
% hObject    handle to playback (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

   
set(handles.vplay,'UserData','stop');
guidata(hObject, handles);
set(hObject,'Min',0);
set(hObject,'Max',1);
x = get(hObject,'Value');
handles.speed = (x);
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function playback_CreateFcn(hObject, eventdata, handles)
% hObject    handle to playback (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function Progress_Callback(hObject, eventdata, handles)
% hObject    handle to Progress (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


set(handles.vplay,'UserData','stop');
y = get(handles.Progress,'Value');
handles.curFrame = (round(y));
guidata(hObject, handles);

% --- Executes on key press with focus on Progress and none of its controls.
%function Progress_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to Progress (see GCBO)
% eventdata  structure with the following fields (see UICONTROL)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)
set(handles.vplay,'UserData','stop');
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function Progress_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Progress (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on button press in Stop.
function Stop_Callback(hObject, eventdata, handles)
% hObject    handle to Stop (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.vplay,'UserData','stop');
handles.isPlaying = 0;
guidata(hObject, handles);


% --- Executes on selection change in history.
function history_Callback(hObject, eventdata, handles)
% hObject    handle to history (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns history contents as cell array
%        contents{get(hObject,'Value')} returns selected item from history

list=get(hObject,'String');
x = get(hObject,'Value');
strang = char(list{x});
[token, remain] = strtok(strang, '=');
fraNumber = str2num(remain(2:end));
handles.curFrame = fraNumber;
vplay_Callback(hObject, eventdata, handles);
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function history_CreateFcn(hObject, eventdata, handles)
% hObject    handle to history (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in txtload.
function txtload_Callback(hObject, eventdata, handles)
% hObject    handle to txtload (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    Str1 = 0;
    Str2 = 0;
    Str3 = 0;
    Str4 = 0;
    Str5 = 0;
    Str6 = 0;
    Str7 = 0;
    Str8 = 0;
    Str9 = 0;
    Str10 = 0;
    Str11 = 0;
    tTime1=0;
    tTime2=0;
    tTime3=0;
    tTime4=0;
    tTime5=0;
    tTime6=0;
    tTime7=0;
    tTime8=0;
    tTime9=0;
    tTime10=0;
    tTime11=0;
    onsetTime1=0;
    onsetTime2=0;
    onsetTime3=0;
    onsetTime4=0;
    onsetTime5=0;
    onsetTime6=0;
    onsetTime7=0;
    onsetTime8=0;
    onsetTime9=0;
    onsetTime10=0;
    onsetTime11=0;
        
     
saveState(handles);
thelist=get(handles.history,'String');
name = uiputfile('*.txt','Save as:');
fID = fopen(name,'w');
%Write video filename to history
fprintf(fID,'Video_Name = %s \n',handles.videoName);
fprintf(fID,'FrameRate =  %f \n',handles.FrameRate);
fprintf(fID,'%s \n',datestr(now,'mm-dd-yyyy HH:MM:SS'));
for i=1:length(thelist);
fprintf(fID,(thelist{i}),'char');
fprintf(fID,'\n');
end
fclose(fID);


%Summary File
nameSum = strcat('SUM_',name);
fID = fopen(nameSum,'w');
%Write video filename to history
fprintf(fID,'Video_Name = %s \n',handles.videoName);


for i=1:length(thelist);
    tmpStr = char(thelist{i});
    %Look for Video Start time
    vidStart = strfind(tmpStr,'Video');
    if vidStart > 0
        [token, startVFrame] = strtok(tmpStr, '|');
        startFrame= strtrim(startVFrame(2:end));
    end
    %Look for On, if ON not there then k > 1 indicating Off string
    k = strfind(tmpStr,'Off');
    if k > 0
        %Going to step back to grab the on, assuming its behind the Off.
        onStr = char(thelist{i-1});
        %Build a structure to parse temp variables into fields
        timeData(i).onString = onStr;
        timeData(i).offString = tmpStr;
        [bcode, remain] = strtok(tmpStr, 'O');
        timeData(i).bcode = strtrim(bcode);
        [remain, onframe] = strtok(onStr, '|');
        [remain, offframe] = strtok(tmpStr, '|');
        timeData(i).onFrame= strtrim(onframe(2:end));
        timeData(i).offFrame= strtrim(offframe(2:end));

        %Comparsion to User entered buttons
   if strcmpi(timeData(i).bcode,get(handles.bedit1,'string'))==1
       Str1 = Str1 + 1;
       if Str1 == 1
           onsetTime1 = str2num(timeData(i).onFrame);
       end
       tTime1 = tTime1 + (str2num(timeData(i).offFrame) - str2num(timeData(i).onFrame));
   elseif strcmpi(timeData(i).bcode,get(handles.bedit2,'string'))==1
       Str2 = Str2+1;
       if Str2 == 1
           onsetTime2 = str2num(timeData(i).onFrame);
       end
       tTime2 = tTime2 + (str2num(timeData(i).offFrame) - str2num(timeData(i).onFrame));
   elseif strcmpi(timeData(i).bcode,get(handles.bedit3,'string'))==1
       Str3 = Str3+1;
       if Str3 == 1
           onsetTime3 = str2num(timeData(i).onFrame);
       end
       tTime3 = tTime3 + (str2num(timeData(i).offFrame) - str2num(timeData(i).onFrame));
   elseif strcmpi(timeData(i).bcode,get(handles.bedit4,'string'))==1
       Str4 = Str4+1;
       if Str4 == 1
           onsetTime4 = str2num(timeData(i).onFrame);
       end
       tTime4 = tTime4 + (str2num(timeData(i).offFrame) - str2num(timeData(i).onFrame));
   elseif strcmpi(timeData(i).bcode,get(handles.bedit5,'string'))==1
       Str5 = Str5+1;
       if Str5 == 1
           onsetTime5 = str2num(timeData(i).onFrame);
       end
       tTime5 = tTime5 + (str2num(timeData(i).offFrame) - str2num(timeData(i).onFrame));
   elseif strcmpi(timeData(i).bcode,get(handles.bedit6,'string'))==1
       Str6 = Str6+1;
       if Str6 == 1
           onsetTime6 = str2num(timeData(i).onFrame);
       end
       tTime6 = tTime6 + (str2num(timeData(i).offFrame) - str2num(timeData(i).onFrame));
   elseif strcmpi(timeData(i).bcode,get(handles.bedit7,'string'))==1
       Str7 = Str7+1;
       if Str7 == 1
           onsetTime7 = str2num(timeData(i).onFrame);
       end
       tTime7 = tTime7 + (str2num(timeData(i).offFrame) - str2num(timeData(i).onFrame));
   elseif strcmpi(timeData(i).bcode,get(handles.bedit8,'string'))==1
       Str8 = Str8+1;
       if Str8 == 1
           onsetTime8 = str2num(timeData(i).onFrame);
       end
       tTime8 = tTime8 + (str2num(timeData(i).offFrame) - str2num(timeData(i).onFrame));
   elseif strcmpi(timeData(i).bcode,get(handles.bedit9,'string'))==1
       Str9 = Str9+1;
       if Str9 == 1
           onsetTime9 = str2num(timeData(i).onFrame);
       end
       tTime9 = tTime9 + (str2num(timeData(i).offFrame) - str2num(timeData(i).onFrame));
   elseif strcmpi(timeData(i).bcode,get(handles.bedit10,'string'))==1
       Str10 = Str10+1;
       if Str10 == 1
           onsetTime10 = str2num(timeData(i).onFrame);
       end
       tTime10 = tTime10 + (str2num(timeData(i).offFrame) - str2num(timeData(i).onFrame));
   elseif strcmpi(timeData(i).bcode,get(handles.bedit11,'string'))==1
       Str11 = Str11+1;
       if Str11 == 1
           onsetTime11 = str2num(timeData(i).onFrame);
       end
       tTime11 = tTime11 + (str2num(timeData(i).offFrame) - str2num(timeData(i).onFrame));
   end
        
    else
    end  
end
   %save('timeData')
    tTime1 = tTime1/handles.FrameRate; avgTime1 = (tTime1/Str1); onsetTime1 = (onsetTime1-str2num(startFrame))/handles.FrameRate;
    tTime2 = tTime2/handles.FrameRate; avgTime2 = (tTime2/Str2); onsetTime2 = (onsetTime2-str2num(startFrame))/handles.FrameRate;
    tTime3 = tTime3/handles.FrameRate; avgTime3 = (tTime3/Str3); onsetTime3 = (onsetTime3-str2num(startFrame))/handles.FrameRate;
    tTime4 = tTime4/handles.FrameRate; avgTime4 = (tTime4/Str4); onsetTime4 = (onsetTime4-str2num(startFrame))/handles.FrameRate;
    tTime5 = tTime5/handles.FrameRate; avgTime5 = (tTime5/Str5); onsetTime5 = (onsetTime5-str2num(startFrame))/handles.FrameRate;
    tTime6 = tTime6/handles.FrameRate; avgTime6 = (tTime6/Str6); onsetTime6 = (onsetTime6-str2num(startFrame))/handles.FrameRate;
    tTime7 = tTime7/handles.FrameRate; avgTime7 = (tTime7/Str7); onsetTime7 = (onsetTime7-str2num(startFrame))/handles.FrameRate;
    tTime8 = tTime8/handles.FrameRate; avgTime8 = (tTime8/Str8); onsetTime8 = (onsetTime8-str2num(startFrame))/handles.FrameRate;
    tTime9 = tTime9/handles.FrameRate; avgTime9 = (tTime9/Str9); onsetTime9 = (onsetTime9-str2num(startFrame))/handles.FrameRate;
    tTime10 = tTime10/handles.FrameRate; avgTime10 = (tTime10/Str10); onsetTime10 = (onsetTime10-str2num(startFrame))/handles.FrameRate;
    tTime11= tTime11/handles.FrameRate; avgTime11 = (tTime11/Str11); onsetTime11 = (onsetTime11-str2num(startFrame))/handles.FrameRate;

    fprintf(fID, '%s %c %s %c %s %c %s %c %s \n', 'Behavior',',','Number of Occurrences',',', 'Total Duration (s)',',', 'Average Duration (s)',',', 'Time to First Onset(s)');
    fprintf(fID, '%s %c %.02f %c %.02f %c %.02f %c %.02f \n', get(handles.bedit1,'string'),',', (Str1),',', roundn(tTime1,-2),',', roundn(avgTime1,-2),',', roundn(onsetTime1,-2)); 
    fprintf(fID, '%s %c %.02f %c %.02f %c %.02f %c %.02f \n', get(handles.bedit2,'string'),',', (Str2),',', roundn(tTime2,-2),',', roundn(avgTime2,-2),',', roundn(onsetTime2,-2)); 
    fprintf(fID, '%s %c %.02f %c %.02f %c %.02f %c %.02f \n', get(handles.bedit3,'string'),',', (Str3),',', roundn(tTime3,-2),',', roundn(avgTime3,-2),',', roundn(onsetTime3,-2));
    fprintf(fID, '%s %c %.02f %c %.02f %c %.02f %c %.02f \n', get(handles.bedit4,'string'),',', (Str4),',', roundn(tTime4,-2),',', roundn(avgTime4,-2),',', roundn(onsetTime4,-2)); 
    fprintf(fID, '%s %c %.02f %c %.02f %c %.02f %c %.02f \n', get(handles.bedit5,'string'),',', (Str5),',', roundn(tTime5,-2),',', roundn(avgTime5,-2),',', roundn(onsetTime5,-2)); 
    fprintf(fID, '%s %c %.02f %c %.02f %c %.02f %c %.02f \n', get(handles.bedit6,'string'),',', (Str6),',', roundn(tTime6,-2),',', roundn(avgTime6,-2),',', roundn(onsetTime6,-2)); 
    fprintf(fID, '%s %c %.02f %c %.02f %c %.02f %c %.02f \n', get(handles.bedit7,'string'),',', (Str7),',', roundn(tTime7,-2),',', roundn(avgTime7,-2),',', roundn(onsetTime7,-2)); 
    fprintf(fID, '%s %c %.02f %c %.02f %c %.02f %c %.02f \n', get(handles.bedit8,'string'),',', (Str8),',', roundn(tTime8,-2),',', roundn(avgTime8,-2),',', roundn(onsetTime8,-2)); 
    fprintf(fID, '%s %c %.02f %c %.02f %c %.02f %c %.02f \n', get(handles.bedit9,'string'),',', (Str9),',', roundn(tTime9,-2),',', roundn(avgTime9,-2),',', roundn(onsetTime9,-2)); 
    fprintf(fID, '%s %c %.02f %c %.02f %c %.02f %c %.02f \n', get(handles.bedit10,'string'),',', (Str10),',', roundn(tTime10,-2),',', roundn(avgTime10,-2),',', roundn(onsetTime10,-2)); 
    fprintf(fID, '%s %c %.02f %c %.02f %c %.02f %c %.02f \n', get(handles.bedit11,'string'),',', (Str11),',', roundn(tTime11,-2),',', roundn(avgTime11,-2),',', roundn(onsetTime11,-2));    
    fclose(fID);



function saveState(handles)
state.listVal  = get(handles.history,'string');
state.editStr1 = get(handles.bedit1,'string');
state.editStr2 = get(handles.bedit2,'string');
state.editStr3 = get(handles.bedit3,'string');
state.editStr4 = get(handles.bedit4,'string');
state.editStr5 = get(handles.bedit5,'string');
state.editStr6 = get(handles.bedit6,'string');
state.editStr7 = get(handles.bedit7,'string');
state.editStr8 = get(handles.bedit8,'string');
state.editStr9 = get(handles.bedit9,'string');
state.editStr10 = get(handles.bedit10,'string');
state.editStr11 = get(handles.bedit11,'string');


save('shann.mat','state');


% --- Executes on button press in tim.
function tim_Callback(hObject, eventdata, handles)
% hObject    handle to tim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
x = get(hObject,'UserData');
guidata(hObject, handles);
 if ~isempty(x) && strcmp(x, 'Play')
    inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{['Session End     Frame |' num2str(handles.curFrame)]}];
    set(handles.history,'String',new_name);
    %Move history listbox value to bottom. 
    %There is Probably a better way to implment this.....
    index = size(get(handles.history,'string'), 1);
    set(hObject,'String','Video Start');
    set(handles.history,'Value',index);
    set(hObject,'UserData',[]);
    guidata(hObject,handles);
   
else
    inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{['Video Start     Frame |' num2str(handles.curFrame)]}];
    set(handles.history,'String',new_name);
    index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    set(hObject,'String','Video End Time');
    set(hObject,'UserData','Play');
    guidata(hObject,handles);
   
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over history.
function history_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to history (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



% --- Executes during object creation, after setting all properties.
function frameCounter_CreateFcn(hObject, eventdata, handles)
% hObject    handle to frameCounter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton6.
function pushbutton6_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.vplay,'UserData','stop');
p =str2double(get(handles.frameCounter,'String'));
if p > handles.numFrames
    p = 1;
end
handles.curFrame = (round(p));
set(handles.pushbutton6,'FontAngle','Normal');
guidata(hObject, handles);
vplay_Callback(hObject, eventdata, handles);


% --- Executes during object creation, after setting all properties.
function bedit1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bedit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%%%%%%%%%%% BUTTONS AND EDITBOX ROUTINES %%%%%%%


% --- Executes on button press in bbutton1.
function bbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to bbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of bbutton1

x = get(handles.bbutton1,'Value');
name = get(handles.bedit1,'string');
if x == 1
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);

    inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' On ' ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}];
    set(handles.history,'String',new_name);
    
    %Update Position in history list box
    index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    guidata(hObject,handles);
    %vplay_Callback(hObject, eventdata, handles);
    
    else
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
    inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' Off'  ' Time = ' combinedSTR ' Frame |'  num2str(handles.curFrame)]}];
    set(handles.history,'String',new_name);
    %fwrite(handles.fID,new_name,'string');
    index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    
    handles.b1=(handles.b1)+1;
 %   Stop_Callback(hObject, eventdata, handles);
 %   vplay_Callback(hObject, eventdata, handles);
    guidata(hObject,handles);
end

% --- Executes on button press in bbutton2.
function bbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to bbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of bbutton2
x = get(handles.bbutton2,'Value');
name = get(handles.bedit2,'string');

if x == 1
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' On ' ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}];
    set(handles.history,'String',new_name);
    
    %Update Position in history list box
     index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    guidata(hObject,handles);
else
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
    inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' Off'  ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}]; 
    set(handles.history,'String',new_name);
    %fwrite(handles.fID,new_name,'string');
    index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    handles.b2=handles.b2+1;
    guidata(hObject,handles);
    
end


% --- Executes on button press in bbutton3.
function bbutton3_Callback(hObject, eventdata, handles)
% hObject    handle to bbutton3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of bbutton3
x = get(handles.bbutton3,'Value');
name = get(handles.bedit3,'string');

if x == 1
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
    
    inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' On ' ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}];
    set(handles.history,'String',new_name);
    
    %Update Position in history list box
     index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    guidata(hObject,handles);
else
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
     inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' Off'  ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}]; 
    set(handles.history,'String',new_name);
    %fwrite(handles.fID,new_name,'string');
    index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    handles.b3=handles.b3+1;
    guidata(hObject,handles);
   
end


% --- Executes on button press in bbutton4.
function bbutton4_Callback(hObject, eventdata, handles)
% hObject    handle to bbutton4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of bbutton4
x = get(handles.bbutton4,'Value');
name = get(handles.bedit4,'string');

if x == 1
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
    
    inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' On ' ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}];
    set(handles.history,'String',new_name);
    
    %Update Position in history list box
     index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    guidata(hObject,handles);
else
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
     inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' Off'  ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}]; 
    set(handles.history,'String',new_name);
    %fwrite(handles.fID,new_name,'string');
    index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    handles.b4=handles.b4+1;
    guidata(hObject,handles);
   
end

% --- Executes on button press in bbutton5.
function bbutton5_Callback(hObject, eventdata, handles)
% hObject    handle to bbutton5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of bbutton5
x = get(handles.bbutton5,'Value');
name = get(handles.bedit5,'string');

if x == 1
 
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
    inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' On ' ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}];
    set(handles.history,'String',new_name);
    
    %Update Position in history list box
     index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    guidata(hObject,handles);
else
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
     inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' Off'  ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}]; 
    set(handles.history,'String',new_name);
    %fwrite(handles.fID,new_name,'string');
    index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    handles.b5=handles.b5+1;
    guidata(hObject,handles);
   
end


% --- Executes on button press in bbutton6.
function bbutton6_Callback(hObject, eventdata, handles)
% hObject    handle to bbutton6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of bbutton6
x = get(handles.bbutton6,'Value');
name = get(handles.bedit6,'string');

if x == 1
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
    
    inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' On ' ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}];
    set(handles.history,'String',new_name);
    
    %Update Position in history list box
     index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    guidata(hObject,handles);
else
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
     inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' Off'  ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}]; 
    set(handles.history,'String',new_name);
    %fwrite(handles.fID,new_name,'string');
    index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    handles.b6=handles.b6+1;
    guidata(hObject,handles);
   
end


% --- Executes on button press in bbutton7.
function bbutton7_Callback(hObject, eventdata, handles)
% hObject    handle to bbutton7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of bbutton7
x = get(handles.bbutton7,'Value');
name = get(handles.bedit7,'string');

if x == 1
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
    
    inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' On ' ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}];
    set(handles.history,'String',new_name);
    
    %Update Position in history list box
     index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    guidata(hObject,handles);
else
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
     inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' Off'  ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}]; 
    set(handles.history,'String',new_name);
    %fwrite(handles.fID,new_name,'string');
    index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    handles.b7=handles.b7+1;
    guidata(hObject,handles);
   
end


% --- Executes on button press in bbutton8.
function bbutton8_Callback(hObject, eventdata, handles)
% hObject    handle to bbutton8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of bbutton8
x = get(handles.bbutton8,'Value');
name = get(handles.bedit8,'string');

if x == 1
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
    inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' On ' ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}];
    set(handles.history,'String',new_name);
    
    %Update Position in history list box
     index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    guidata(hObject,handles);
else
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
     inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' Off'  ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}]; 
    set(handles.history,'String',new_name);
    %fwrite(handles.fID,new_name,'string');
    index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    handles.b8=handles.b8+1;
    guidata(hObject,handles);
   
end


% --- Executes on button press in bbutton9.
function bbutton9_Callback(hObject, ~, handles)
% hObject    handle to bbutton9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of bbutton9
x = get(handles.bbutton9,'Value');
name = get(handles.bedit9,'string');

if x == 1
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
    inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' On ' ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}];
    set(handles.history,'String',new_name);
    
    %Update Position in history list box
     index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    guidata(hObject,handles);
else
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
     inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' Off'  ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}]; 
    set(handles.history,'String',new_name);
    %fwrite(handles.fID,new_name,'string');
    index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    handles.b9=handles.b9+1;
    guidata(hObject,handles);
   
end


% --- Executes on button press in bbutton10.
function bbutton10_Callback(hObject, eventdata, handles)
% hObject    handle to bbutton10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of bbutton10
x = get(handles.bbutton10,'Value');
name = get(handles.bedit10,'string');

if x == 1
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
    
    inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' On ' ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}];
    set(handles.history,'String',new_name);
    
    %Update Position in history list box
     index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    guidata(hObject,handles);
else
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
     inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' Off'  ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}]; 
    set(handles.history,'String',new_name);
    %fwrite(handles.fID,new_name,'string');
    index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    handles.b10=handles.b10+1;
    guidata(hObject,handles);
   
end


% --- Executes on button press in bbutton11.
function bbutton11_Callback(hObject, eventdata, handles)
% hObject    handle to bbutton11 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of bbutton11
x = get(handles.bbutton11,'Value');
name = get(handles.bedit11,'string');

if x == 1
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
    
    inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' On ' ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}];
    set(handles.history,'String',new_name);
    
    %Update Position in history list box
     index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    guidata(hObject,handles);
else
    
    seconds = handles.curFrame/handles.FrameRate;
    hms = fix(mod(seconds, [0, 3600, 60, 1 ]) ./ [3600, 60, 1 , .1]);
    hms2 = num2cell(hms);
    stringH = num2str(hms2{1});
    stringM = num2str(hms2{2});
    stringS = num2str(hms2{3});
    stringMS = num2str(hms2{4});
    combinedSTR = strcat(stringH,':',stringM,':',stringS,'.',stringMS);
    
     inital_name=cellstr(get(handles.history,'String'));
    new_name = [inital_name;{[name ' Off'  ' Time = ' combinedSTR ' Frame |' num2str(handles.curFrame)]}]; 
    set(handles.history,'String',new_name);
    %fwrite(handles.fID,new_name,'string');
    index = size(get(handles.history,'string'), 1);
    set(handles.history,'Value',index);
    handles.b11=handles.b11+1;
    guidata(hObject,handles);
   
end

% --- Executes during object creation, after setting all properties.
function bedit2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bedit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function bedit3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bedit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function bedit4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bedit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function bedit5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bedit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes during object creation, after setting all properties.
function bedit6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bedit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes during object creation, after setting all properties.
function bedit7_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bedit7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes during object creation, after setting all properties.
function bedit8_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bedit8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function bedit9_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bedit9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function bedit10_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bedit10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes during object creation, after setting all properties.
function bedit11_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bedit11 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function bedit1_Callback(hObject, eventdata, handles)
% hObject    handle to bedit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bedit1 as text
%        str2double(get(hObject,'String')) returns contents of bedit1 as a double

function bedit2_Callback(hObject, eventdata, handles)
% hObject    handle to bedit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bedit2 as text
%        str2double(get(hObject,'String')) returns contents of bedit2 as a double

function bedit3_Callback(hObject, eventdata, handles)
% hObject    handle to bedit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bedit3 as text
%        str2double(get(hObject,'String')) returns contents of bedit3 as a double

function bedit4_Callback(hObject, eventdata, handles)
% hObject    handle to bedit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bedit4 as text
%        str2double(get(hObject,'String')) returns contents of bedit4 as a double

function bedit5_Callback(hObject, eventdata, handles)
% hObject    handle to bedit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bedit5 as text
%        str2double(get(hObject,'String')) returns contents of bedit5 as a double

function bedit6_Callback(hObject, eventdata, handles)
% hObject    handle to bedit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bedit6 as text
%        str2double(get(hObject,'String')) returns contents of bedit6 as a double

function bedit7_Callback(hObject, eventdata, handles)
% hObject    handle to bedit7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bedit7 as text
%        str2double(get(hObject,'String')) returns contents of bedit7 as a double

function bedit8_Callback(hObject, eventdata, handles)
% hObject    handle to bedit8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bedit8 as text
%        str2double(get(hObject,'String')) returns contents of bedit8 as a double

function bedit9_Callback(hObject, eventdata, handles)
% hObject    handle to bedit9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bedit9 as text
%        str2double(get(hObject,'String')) returns contents of bedit9 as a double

function bedit10_Callback(hObject, eventdata, handles)
% hObject    handle to bedit10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bedit10 as text
%        str2double(get(hObject,'String')) returns contents of bedit10 as a double

function bedit11_Callback(hObject, eventdata, handles)
% hObject    handle to bedit11 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bedit11 as text
%        str2double(get(hObject,'String')) returns contents of bedit11 as a double



%%%END Button Callbacks



function loadState(handles)
fileName = 'shann.mat'

if exist(fileName)
    load(fileName)
    set(handles.history,'string',state.listVal);
    set(handles.bedit1, 'string',state.editStr1);
    set(handles.bedit2, 'string',state.editStr2);
    set(handles.bedit3, 'string',state.editStr3);
    set(handles.bedit4, 'string',state.editStr4);
    set(handles.bedit5, 'string',state.editStr5);
    set(handles.bedit6, 'string',state.editStr6);
    set(handles.bedit7, 'string',state.editStr7);
    set(handles.bedit8, 'string',state.editStr8);
    set(handles.bedit9, 'string',state.editStr9);
    set(handles.bedit10, 'string',state.editStr10);
    set(handles.bedit11, 'string',state.editStr11);
    delete(fileName);
    
end


% --- Executes on button press in clearHistory.
function clearHistory_Callback(hObject, eventdata, handles)
% hObject    handle to clearHistory (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.history,'string',[]);


% --- Executes on key press with focus on bbutton1 and none of its controls.
function bbutton1_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to bbutton1 (see GCBO)
% eventdata  structure with the following fields (see UICONTROL)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)



% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over frameCounter.
function frameCounter_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to frameCounter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.vplay,'UserData','stop');
guidata(hObject, handles);



function frameCounter_Callback(hObject, eventdata, handles)
% hObject    handle to frameCounter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of frameCounter as text
%        str2double(get(hObject,'String')) returns contents of frameCounter as a double


% --- Executes on key press with focus on frameCounter and none of its controls.
function frameCounter_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to frameCounter (see GCBO)
% eventdata  structure with the following fields (see UICONTROL)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)
set(handles.vplay,'UserData','stop');
set(handles.pushbutton6,'FontAngle','Oblique');
guidata(hObject, handles);

% --- Executes on key press with focus on figure1 and none of its controls.
function figure1_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  structure with the following fields (see FIGURE)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)
switch eventdata.Key
  case '1'
    x = get(handles.bbutton1,'Value');
    if x == 1
        set(handles.bbutton1,'Value',0);
    else
        set(handles.bbutton1,'Value',1);
    end
    bbutton1_Callback(hObject, eventdata, handles);
 case '2'
    x = get(handles.bbutton2,'Value');
    if x == 1
        set(handles.bbutton2,'Value',0);
    else
        set(handles.bbutton2,'Value',1);
    end
    bbutton2_Callback(hObject, eventdata, handles);
 case '3'
    x = get(handles.bbutton3,'Value');
    if x == 1
        set(handles.bbutton3,'Value',0);
    else
        set(handles.bbutton3,'Value',1);
    end
    bbutton3_Callback(hObject, eventdata, handles);
case '4'
    x = get(handles.bbutton4,'Value');
    if x == 1
        set(handles.bbutton4,'Value',0);
    else
        set(handles.bbutton4,'Value',1);
    end
    bbutton4_Callback(hObject, eventdata, handles);
case '5'
    x = get(handles.bbutton5,'Value');
    if x == 1
        set(handles.bbutton5,'Value',0);
    else
        set(handles.bbutton5,'Value',1);
    end
    bbutton5_Callback(hObject, eventdata, handles);
case '6'
    x = get(handles.bbutton6,'Value');
    if x == 1
        set(handles.bbutton6,'Value',0);
    else
        set(handles.bbutton6,'Value',1);
    end
    bbutton6_Callback(hObject, eventdata, handles);
case '7'
    x = get(handles.bbutton7,'Value');
    if x == 1
        set(handles.bbutton7,'Value',0);
    else
        set(handles.bbutton7,'Value',1);
    end
    bbutton7_Callback(hObject, eventdata, handles);
case '8'
    x = get(handles.bbutton8,'Value');
    if x == 1
        set(handles.bbutton8,'Value',0);
    else
        set(handles.bbutton8,'Value',1);
    end
    bbutton8_Callback(hObject, eventdata, handles);
case '9'
    x = get(handles.bbutton9,'Value');
    if x == 1
        set(handles.bbutton9,'Value',0);
    else
        set(handles.bbutton9,'Value',1);
    end
    bbutton9_Callback(hObject, eventdata, handles);
case '0'
    x = get(handles.bbutton10,'Value');
    if x == 1
        set(handles.bbutton10,'Value',0);
    else
        set(handles.bbutton10,'Value',1);
    end
    bbutton10_Callback(hObject, eventdata, handles); 
 case 'p'
    x = get(handles.bbutton11,'Value');
    if x == 1
        set(handles.bbutton11,'Value',0);
    else
        set(handles.bbutton11,'Value',1);
    end
    bbutton11_Callback(hObject, eventdata, handles);    
end

function figure1_WindowKeyPressFcn(hObject, eventdata, handles)

function delay_Callback(hObject, eventdata, handles)
% hObject    handle to delay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of delay as text
%        str2double(get(hObject,'String')) returns contents of delay as a double


% --- Executes during object creation, after setting all properties.
function delay_CreateFcn(hObject, eventdata, handles)
% hObject    handle to delay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on slider movement.
function delayAdjust_Callback(hObject, eventdata, handles)
% hObject    handle to delayAdjust (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
set(handles.vplay,'UserData','stop');
set(handles.delayAdjust,'Min',0);
set(handles.delayAdjust,'Max',1);
x = get(hObject,'Value');
handles.speed = (x);
set(handles.delay,'String',handles.speed);
guidata(hObject, handles);
vplay_Callback(hObject, eventdata, handles);



% --- Executes during object creation, after setting all properties.
function delayAdjust_CreateFcn(hObject, eventdata, handles)
% hObject    handle to delayAdjust (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: delete(hObject) closes the figure
delete(hObject);
