%%%%%
%
% Copyright (c) 2013, Rutgers Cancer Institute of New Jersey, 
%                     Center for Biomedical Imaging & Informatics
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without 
% modification, are permitted provided that the following conditions are 
% met:    
%    Redistributions of source code must retain the above copyright 
% notice, this list of conditions and the following disclaimer.
%    Redistributions in binary form must reproduce the above copyright notice, 
% this list of conditions and the following disclaimer in     
% the documentation and/or other materials provided with the distribution
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
% ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS 
% BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
% POSSIBILITY OF SUCH DAMAGE.
%
% License to use and modify this code is granted freely to all interested, 
% as long as the original authors arereferenced and attributed as such. 
% The original authors maintain the right to be solely associated with this work.
%
% Author: Wenjin Chen, Eugenia Xu
% Date: 2013/08/01
%%%%%
function [I, folder, fn, ext, adjfile] = readImage(fullfile, config)
%%turn image into uint8, grayscale

[folder, fn, ext] = fileparts(fullfile);
I = imread(fullfile);

D = size(I, 3);

if D==3
    I = rgb2gray(I);
end

%convert to 8 bit gray scale
adjfile = '';
if isa(I, 'uint16')
    if ~strcmp(config.specialcolor, '12 bit')
        I = uint8(I);
    else
        I = uint8(I./16);
    end
    adjfile = [folder, filesep, fn, config.adj];
    imwrite(I, adjfile, 'JPEG');
    disp(['writing adj file: ', adjfile]);
end

